;+
;PROCEDURE:     load_cis_fgm_psds, filename, data = data
;INPUT:
;	filename: Name (including path) of FGM PSDS file
;	data: Variable to return magnetometer data as structure (optional)
;
;PURPOSE:   Load Cluster/FGM PSDS data.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
pro load_cis_fgm_psds, filename, data = mag_data

openr, filelun, filename, /get_lun

amag_data = {time: 0d, fgm_x: 0., fgm_y: 0., fgm_z: 0., fgm_rate: 0}
mag_data = replicate(amag_data,1000)

aline = ''
j=0

repeat begin
	readf, filelun, aline
	if aline ne '' then begin
		splitaline = strsplit(aline,' ',/extract)
		splittime = strsplit(splitaline[0],'T',/extract)
		splittime[1] = strmid(splittime[1],0,strlen(splittime[1])-1)
		mag_data[j].time = time_double(splittime[0]+'/'+splittime[1])
		mag_data[j].fgm_x = float(splitaline[1])
		mag_data[j].fgm_y = float(splitaline[2])
		mag_data[j].fgm_z = float(splitaline[3])
		mag_data[j].fgm_rate = fix(splitaline[4])
		j = j+1
		if j eq n_elements(mag_data) then begin
			new_data = replicate(amag_data,n_elements(mag_data)+1000)
			new_data[0:n_elements(mag_data)-1] = mag_data
			mag_data = new_data
		endif
	endif
endrep until eof(filelun)

mag_data = mag_data[0:j-1]

store_data,'fgm_psds',data=mag_data

end