pro print_cod_file_info,options,date_str

if options[3] eq 1l then bm3_str = '(BM3)' $
else bm3_str = ''
prod_str = strcompress(string(options[2]),/rem)
sat_str = strcompress(string(options[0]),/rem)
inst_str = 'CODIF'

case options[2] of
	1: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Raw Counts'
	2: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Raw Rates'
	3: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Raw Events'
	4: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Full Events'
	5: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' WEC Data'
	6: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' FGM Data'
	7: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Moments'
	9: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Cold Moments'
	11: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D Mass'
	12: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D Proton, 16E'
	13: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D Proton, 31E'
	14: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D Proton, 24A'
	15: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D Alphas, 16E'
	16: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D Alphas, 31E'
	17: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D High Mass, 16E'
	18: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D High Mass, 31E'
	19: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 2D Mass, 31E, 4M'
	20: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 2D Mass, 16E, 2M'
	21: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 2D Mass, 16E, 2M'
	22: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 2D Mass, 31E, 1M'
	23: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Pitch Angle Cut, 16E'
	24: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Pitch Angle Cut, 31E'
	27: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Montior Rates'
	28: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Selected Events'
	29: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' RPA'
	36: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Burst Memory Counters'
	38: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Burst Trigger Table'
	46: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D High Mass, 16E, He+'
	47: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D High Mass, 16E, O+'
	48: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D High Mass, 31E, He+'
	49: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D High Mass, 31E, O+'
	61: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' IO Read'
	62: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Memory Dump'
	else: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str
endcase

if keyword_set(str) then print,str

return
end

pro print_hia_file_info,options,date_str

if options[3] eq 1l then bm3_str = '(BM3)' $
else bm3_str = ''
prod_str = strcompress(string(options[2]),/rem)
sat_str = strcompress(string(options[0]),/rem)
inst_str = 'HIA'

case options[2] of
	0: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Sweep Diag'
	1: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Raw Counts'
	2: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Moments'
	4: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Cold Moments'
	5: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D Mass, 62E'
	6: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D Mass, 31E, 88A'
	7: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 3D Mass, 31E, 42A'
	8: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Cold 3D Mass'
	9: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 1D Mass (Spectro)'
	10: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 2D Azimuthal'
	11: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' 2D Polar'
	12: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Pitch Angle Cut'
	13: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Cold 2D Polar'
	14: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Cold 2D Azimuthal'
	15: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Hot 3D, 16E'
	16: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Hot 3D, 30E'
	17: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Hot 3D, 62E'
	18: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Hot 1D, 31E'
	19: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Hot PAD, 31E'
	20: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Hot 2D, 31E'
	21: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Hot 3D, 31E'
	22: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Cold 3D, 31E'
	23: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Hot 3D, 31E, Compressed'
	24: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Cold 3D, 31E, Compressed'
	61: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' IO Read'
	62: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str+' Memory Dump'
	else: str = date_str+' Sat: '+sat_str+' Instr: '+inst_str+' Product: '+prod_str+' '+$
		bm3_str
endcase

if keyword_set(str) then print,str

return
end

pro print_cis_file_info,options,date_str

case options[1] of
	0: print_cod_file_info,options,date_str
	1: print_hia_file_info,options,date_str
endcase

return
end

pro print_cis_data_products

l1datadir = getenv('L1DATA')
get_timespan,filetime

date_str_arr = [time_string(filetime[0],format=2,prec=-3),$
                time_string(filetime[1]-1d,format=2,prec=-3)]

if date_str_arr[0] eq date_str_arr[1] then $
        date_str_arr = date_str_arr[0] $
else begin
        done = 0
        last_date_str = date_str_arr[1]
        date_str_arr = date_str_arr[0]
        date_dummy = filetime[0]
        while done eq 0 do begin
                date_dummy = date_dummy + 60d*60d*24d
                next_date_str = time_string(date_dummy,format=2,prec=-3)
                date_str_arr = [date_str_arr,next_date_str]
                if next_date_str eq last_date_str then done = 1
        endwhile
endelse

for sat=1,4 do begin
	for inst=0,1 do begin
		for prod=0,62 do begin
			for bm3 = 0,1 do begin
			options = long([sat,inst,prod,bm3])
				for i = 0,n_elements(date_str_arr)-1 do begin
					date_str = date_str_arr[i]
					sat_num = options[0]
					sat_num = strcompress(string(sat_num),/rem)
					data_dir = l1datadir+'/'+date_str+'/CLUSTER'+sat_num+'/'
					file_str = get_cis_filename(options,date_str)
					filename = findfile(data_dir+file_str,count=file_cnt)
					if file_cnt gt 0 then $
						print_cis_file_info,options,date_str
				endfor
			endfor
		endfor
	endfor
endfor

return
end