;******************************************************************************
;* FUNCTION:     
;*      FUNCTION cluster_eph_ticks_panel, aPlotInfo, GROUP=GROUP, ACTION=ACTION
;* 
;* DESCRIPTION:  
;*	Open an editor widget for a panel, using the methods defined in the 
;*	file $papco_XX/papco_panel.pro .
;*	When the user presses the 'Done'- or the 'Cancel'-Button, the values 
;*	changed by the event-methods of papco_panel.pro are returned.
;*	The returned value is a structure containing those values and a flag,
;*	'canceled', which the caller may read out to check, whether the 
;*	window was closed using the 'Cancel' or the 'Done'-Button.
;*
;* INPUTS:       
;*      aPlotInfo       a structure of the papco_plotinfo-type
;*                      this structure is edited in the panel editor window.
;* KEYWORDS:
;*      GROUP           a WIDGET_BASE
;*	                when specified, this is used as GROUP_LEADER
;*      ACTION          a string
;*	                when specified, the 'Done'-Button is labeled with it
;*		        if not specified, the 'Done'-Button is labeled 'Done'
;*
;* OUTPUT:	 
;*      a default-structure of type papco_panel_editor_return. Though this
;*      type is nowhere defined, it is a virtually existing data-type. 
;*      All the functions in $papco_XX/papco.pro that edit plots or add new
;*      ones, expect the opened editor-windows to return a structure containing
;*      at least some fields. Typically this structure contains fields
;*      used by the papco_panel widgets, and some fields "inherited"
;*      from aplotinfo but modified by the user.
;*
;* CALLING SEQUENCE:
;*      newPlotData=cluster_eph_ticks_panel(aplotInfo, ACTION=, GROUP=)
;******************************************************************************
FUNCTION  cluster_eph_ticks_panel, aPlotInfo, GROUP=group, ACTION=ACTION

COMMON cluster_eph_ticks_panel_data, widgetData
COMMON cluster_eph

;--- if GROUP is not specified, the group-leader will be the desktop
  IF NOT KEYWORD_SET(GROUP) THEN GROUP=0
;--- set the label for the action-button
  IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

;--- the routines used by papco_panel.pro define tags for a structure. Those
;    tags will be stored in the structure 'additionalWData'. When you realize 
;    the window, you have to add your own window-specific data to that  
;    structure and afterwards assign it to widgetData.
  additionalWData={canceled:1}

;--- create the base-window ---------------------------------------------------
;    since this can be a large widget, make a left and right side.
  panel_base=papco_WIDGET_BASE(title=aPlotInfo.panelKind, row=1, $
                               GROUP_LEADER=group, /MODAL)
  panel_left=widget_base(panel_base,column=1,  /base_align_center)
  panel_right=widget_base(panel_base,column=1, /base_align_center)

;--- the first part of the window will consist of the widget that -------------
;    controls the height of that panel. This is needed for all panel editors.
  widgets=papco_panel_AddHeightWidgets(panel_left, aPlotInfo)
  additionalWData=create_struct(widgets, additionalWData)
   
;
;---  <<<<<<<<<<  insert your widgets below here!  >>>>>>>>>
;
  sc_id_base=CW_BGROUP(panel_left, sc_names, COLUMN=3, /EXCLUSIVE, /FRAME, $
                       LABEL_TOP='CLUSTER Spacecraft', $
                       UVALUE='spb_sc_id', $
                       SET_VALUE=aplotinfo.typevector(0)) 

;--- select basic coordinates -------------------------------------------------
  n_ch = n_elements(coord_names)
  coord_set = bytarr(n_ch)
  for i=0,n_ch-1 do begin
    if (aPlotInfo.typeVector(1) and 2l^i) eq 2l^i then coord_set(i)=1 $
    else coord_set(i)=0
  endfor  
  coord_base=CW_BGROUP(panel_left, coord_names, COLUMN=3, $
                       /NONEXCLUSIVE, /FRAME, $
                       LABEL_TOP='CLUSTER Coordinates', $
                       UVALUE='mpb_coord', $
                       SET_VALUE=coord_set) 
  
;
;---  <<<<<<<<<<  insert your widgets above here!  >>>>>>>>>
;   
;--- some panels might need to read/input to text files (event, text ----------
;    module). So a generic papco widget is supplied for this. 
;  widgets=papco_panel_AddFile_Widgets(panel_left, aPlotInfo)
;  additionalWData=create_struct(widgets, additionalWData)   
;--- add the papco panel widget for choosing the color bar for color plots ----
;  widgets=papco_panel_Addcolorbar_Widgets(panel_left, aPlotInfo)
;  additionalWData=create_struct(widgets, additionalWData)
;--- add the  papco panel widget for choosing the plot-style for line plots ---
;  widgets=papco_panel_add_PlotStyleButtons(panel_left, aPlotInfo, 0)
;  additionalWData=create_struct(widgets, additionalWData)
;--- add the papco panel widget for choosing the y-axis-ranges ----------------
;  widgets=papco_panel_AddYScale_Widgets(panel_right, aPlotInfo,/VERTICAL)
;  additionalWData=create_struct(widgets, additionalWData)
;--- add the papco panel widgets for choosing the z-axis-ranges ---------------
;  widgets=papco_panel_AddZScale_Widgets(panel_right, aPlotInfo,/VERTICAL)
;  additionalWData=create_struct(widgets, additionalWData)
   
;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window. This is needed for all panel editors. If you want to 
;    make use of the configure feature, then add the keyword CONFIG
  widgets=papco_panel_AddActionButtons(panel_left, Action, aPlotInfo, $
                                       /CONFIG,  ROW = 2)
  additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You always
;    need to specify the help-file, and your structure must contain the
;    'additionalWData'. You should create the helpfile in the papco_interface
;    directory of your module (a template is in the cluster_eph_ticks example module)
;    Also add the ID's of your widgets so that you can perform widget_control
;    actions in the events routine or in a refresh routine if needed.
  thisWidgetsData={helpfile:'cluster_eph_ticks_panel.help', $
                   typevector:aPlotInfo.typevector,  $
                   coord_base:coord_base}
  widgetData=papco_panel_CreateWidgetData(thisWidgetsData, additionalWData)

;--- realize the window -------------------------------------------------------
  papco_Panel_Realize, panel_base, widgetData
  papco_xmanager, 'cluster_eph_ticks_panel', panel_base

;--- the returned data consists of the standard-data inherited from
;    papco_panel.pro and your new data. Stick to the tags provided in
;    aPlotInfo, there are ample variables for the user
  returnData={typevector:widgetData.typevector}
  additionalRData=papco_panel_ReturnData(widgetData)

  return, create_struct(ReturnData, additionalRData)
   
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO cluster_eph_ticks_panel_event, event
;* 
;* DESCRIPTION:  
;*      This processes events from the XMANAGER.
;*      As this example does not extend the basic functionality of plot-
;*      editors, it directly calls the default-handler, papco_PANEL_Event
;*
;* INPUTS:       
;*      event            an XManager event
;*                  
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by XMANAGER
;******************************************************************************
PRO cluster_eph_ticks_panel_event, event
  
  COMMON cluster_eph_ticks_panel_data, widgetData

  WIDGET_CONTROL,GET_UVALUE=uval, event.id

; in this editor, we only need to process the channel slider events. events
; other than those from your own widgets need to be passed on to 
; 'papco_panel_Event', which handles the events generated
; by the papco-provided panel widgets. Your own added panel widgets events
; need to be processed here:  you should check 'event' for your events and call
; 'papco_panel_Event', if event was not generated by your own panel widgets.
; The best way to learn is to look at some of the other module's panel editors.


  case uval of 
    'spb_sc_id' : begin
      widgetData.typevector(0)=event.value
    end
    'mpb_coord' : BEGIN
      WIDGET_CONTROL,widgetData.coord_base,GET_VALUE=channel_event
      widgetData.typevector(1)=0
      for i=0,n_elements(channel_event)-1 do if channel_event(i) then $
       widgetData.typevector(1)=widgetData.typevector(1)+2^i  
    end
    else: begin
      widgetData=papco_panel_Event(event, widgetData)
    end  
  endcase


END
