
;*******************************************************************************
;*PEACE RAPID COMPARISON
;*
;*
;*
;*
;******************************************************************************
;********************************************************
;* trial program to compare PEACE and RAPID observations.


PRO RAPID_PEACE_COMP,starttime,endtime,sc_id

COMMON cluster_rapid_data, input_rapid_header,input_rapid_data
COMMON cluster_peace_data, input_peace_data
common mjdt, mjdt_start, mjdt_end


REST_ENERGY = 0.511;MeV

RP_COMB=1
SNGLE_PEACE_PA=1
starttime='06/14/2002 12:00:00'
endtime='06/14/2002 13:00:00'
sc_id=2


;******************** read in PEACE DATA

papco, /set_only ;compile papco but dont run

IF sc_id lT 5 THEN sc_str = '4'
IF sc_id lT 4 THEN sc_str = '3'
IF sc_id lT 3 THEN sc_str = '2'
IF sc_id lT 2 THEN sc_str = '1'

result = convert_timeToSeconds(starttime, /t90, /mjdt)
t1 = result.value
result = convert_timeToSeconds(endtime, /t90, /mjdt)
t2 = result.value
mjdt_start = t1 & mjdt_end = t2

convert_t90_to_date, mjdt_start, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt
year=strcompress(yr,/REMOVE_ALL)
day=strcompress(day_oy,/REMOVE_ALL)
daystamp=year+day

plotinfo_HEEA = papco_getplotinfostruct()
plotinfo_HEEA.ioptions(0)=(sc_id-1)
plotinfo_HEEA.soptions(3)='full_HEEA, 3_C'+sc_str+' HEEA PA 30deg                ' 
plotinfo_HEEA.soptions(1)='full_HEEA'
plotinfo_HEEA.soptions(2)='/n/radbelt/dlnk/cluster/peace/SDDAS_output/full_HEEA/CLUSTER-'+sc_str+'_HSPAD_'+daystamp+'000000_V1.cdf'


plotinfo_HEEA_PSD = papco_getplotinfostruct()
plotinfo_HEEA_PSD.ioptions(0)=(sc_id-1)
plotinfo_HEEA_PSD.soptions(3)='full_HEEA, 3_C'+sc_str+' HEEA PA 30deg                ' 
plotinfo_HEEA_PSD.soptions(1)='full_HEEA'

plotinfo_HEEA_PSD.soptions(2)='/n/radbelt/dlnk/cluster/peace/SDDAS_output/full_HEEA/CLUSTER_PSD-'+sc_str+'_HSPAD_'+daystamp+'000000_V2.cdf'



;read in PEACE_HEEA DATA for selected time period

read_cluster_peace,plotinfo_HEEA,/verb
PEACE_DATA=input_peace_data
read_cluster_peace,plotinfo_HEEA_PSD,/verb             
PEACE_PSD_DATA=input_peace_data
PEACE_EPOCH=PEACE_DATA.EPOCH

;index out fill values
;READ IN RAPID DATA


plotinfo_RAPID = papco_getplotinfostruct()
OUTPUT=2
plotInfo_RAPID.ioptions(11)=0
plotinfo_RAPID.typevector(0)=(sc_id-1)
plotinfo_RAPID.typevector(1)=1
plotinfo_RAPID.typevector(2)=0
plotinfo_RAPID.dataunits=(3)
plotinfo_RAPID.ioptions(5) = 0
plotinfo_RAPID.ioptions(1)=0
plotinfo_RAPID.ioptions(3)=1
;plotinfo_RAPID.ioptions(0) = 0

r_cluster_rapid,plotinfo_RAPID


  p_cluster_rapid_spec, [-99, 0, 0], plotInfo_RAPID, OUTPUT=2

rapid_low_channels= input_RAPID_header.CH_POSITIONS(0,*,*,1) 
rapid_high_channels=input_RAPID_header.CH_POSITIONS(1,*,*,1) 
rapid_centre_channels=10^((alog10(rapid_low_channels)+alog10(rapid_high_channels))/2)

;do PSD calculation, start by getting energy bin values
low_PEACE = PEACE_DATA.BAND_LOW_SCAN.DAT
high_PEACE =   PEACE_DATA.BAND_HIGH_SCAN.DAT 
center_PEACE =   PEACE_DATA.CENTER_SCAN.DAT
low_PEACE_channel =  center_PEACE - low_PEACE
high_PEACE_channel = center_PEACE + high_PEACE

size_PEACE_LOW = size(low_PEACE_channel)
size_RAPID_low = size(rapid_low_channels)

;start Hilmer PSD calculation
;first calc p2c2 approx using high/low energy bin values

PEACE_KMIN = (low_PEACE_channel)/(1000); assumes PEACE energy table is in eV and converts to KeV
PEACE_KMAX = (high_PEACE_channel)/(1000);

RAPID_KMIN =  (rapid_low_channels)
RAPID_KMAX =  (rapid_high_channels)


;get TAI of papco start time of plot
convert_t90_to_date, mjdt_start, yr,doy,hr,min,sec,mo,cmo,dom, /mjdt
tai_1=UTC2TAI({YEAR:yr, MONTH:mo, DAY:dom, HOUR:hr, MINUTE:min, $
                 SECOND:sec, MILLISECOND:0})
;get CDF epoch of papco start time of plot
CDF_EPOCH,epoch_1, yr, mo, dom, hr, min, sec, 0, /COMPUTE_EPOCH

convert_t90_to_date, mjdt_end, yr,doy,hr,min,sec,mo,cmo,dom, /mjdt
tai_2=UTC2TAI({YEAR:yr, MONTH:mo, DAY:dom, HOUR:hr, MINUTE:min, $
                 SECOND:sec, MILLISECOND:0})

;cdf epoch is in milliseconds since 01 Jan 00:00:00.000
offset = tai_1-(epoch_1/1000.0);offset between start time of plot and epoch time

RAPID_DATA=input_RAPID_data.DATA
RAPID_TIME=input_RAPID_DATA.TIME

tai_RAPID = RAPID_TIME

;PEACE is in CDF EPOCH time 
tai_PEACE=(PEACE_EPOCH.DAT)/1000.0+offset
tai_PEACE_PSD=(PEACE_PSD_DATA.EPOCH.DAT)/1000.0+offset


;limit PEACE data time to papco time
index_PEACE_PSD=where((tai_PEACE_PSD GE tai_1) AND (tai_PEACE_PSD LE tai_2),count)
index_peace =  where((tai_PEACE GE tai_1) AND (tai_PEACE LE tai_2), count)
 
RAPID_DATA=transpose(RAPID_DATA)


matt_papco_hilmer_phase_space_density,RAPID_KMIN,RAPID_KMAX,RAPID_DATA,RAPID_PSD

pp=(PEACE_DATA.(3).DAT)
size_peace=size(pp)
SDDAS_PSD=dblarr(13,size_peace(2),size_peace(1))
HILMER_PSD=dblarr(13,size_peace(2),size_peace(1))
HILMER_PSD_CLEANED=dblarr(13,size_peace(1))
HILMER_PSD_CLEANED(*,*)=!VALUES.F_NAN
timeselect_R=10
;timeselect_P=timeselect_R-360
timeselect_P=timeselect_R
ytitle='sec^3/km^6'
xtitle='eV'
yrange=[1e-15,1e5]
xrange=[35,400000]

title_time=tai2utc(tai_rapid(timeselect_R),/ecs)
title_psd_time=tai2utc(tai_PEACE_PSD(timeselect_P),/ecs)
title='RAPID time '+title_time+',  PEACE time '+title_psd_time
ERASE
for i=0,12 do begin
 
 PEACE_PA_DATA=PEACE_DATA.(i+3).DAT
 SDDAS_PSD(i,*,*)=transpose(PEACE_PSD_DATA.(i+3).DAT)
 PEACE_PA_DATA=transpose(PEACE_PA_DATA)*1000.0
 matt_papco_hilmer_phase_space_density,PEACE_KMIN,PEACE_KMAX,PEACE_PA_DATA,PEACE_PA_PSD
 HILMER_PSD(i,*,*)=PEACE_PA_PSD
 idx=where(HILMER_PSD(i,timeselect_P,*) ne 0,c)
 idx2=where(SDDAS_PSD(i,timeselect_P,*) ne PEACE_PSD_DATA.(3).FILLVAL,cc)
 HILMER_PSD_CLEANED(i,idx)=HILMER_PSD(i,timeselect_P,idx)
 plot, center_peace(idx2),SDDAS_PSD(i,timeselect_P,idx2),psym=4,/xlog,/ylog,xrange=xrange,yrange=yrange,XTICKINTERVAL=10,xtitle=xtitle,ytitle=ytitle 
 plot, center_peace(idx),HILMER_PSD(i,timeselect_P,idx),/xlog,/ylog,xrange=xrange,yrange=yrange,XTICKINTERVAL=10,xtitle=xtitle,ytitle=ytitle 
 plot,center_peace,HILMER_PSD_CLEANED(i,*),psym=1,/xlog,/ylog,xrange=xrange,yrange=yrange,XTICKINTERVAL=10,xtitle=xtitle,ytitle=ytitle,color=5
endfor

sum_HILMER=( HILMER_PSD_CLEANED(0,*)+HILMER_PSD_CLEANED(1,*)+HILMER_PSD_CLEANED(2,*)+HILMER_PSD_CLEANED(3,*)+HILMER_PSD_CLEANED(4,*)+$
HILMER_PSD_CLEANED(5,*)+HILMER_PSD_CLEANED(6,*)+HILMER_PSD_CLEANED(7,*)+HILMER_PSD_CLEANED(8,*)+HILMER_PSD_CLEANED(9,*)+$
HILMER_PSD_CLEANED(10,*)+HILMER_PSD_CLEANED(11,*)+HILMER_PSD_CLEANED(12,*))/13.0

plot,center_peace,sum_HILMER,psym=2,/xlog,/ylog,xrange=xrange,yrange=yrange,XTICKINTERVAL=10,xtitle=xtitle,ytitle=ytitle,color=2 
rapid_centre_channels=rapid_centre_channels*1000;change to eV for plotting
plot,rapid_centre_channels,rapid_psd(timeselect_r,*),psym=-4,/xlog,/ylog,xrange=xrange,yrange=yrange,XTICKINTERVAL=10,xtitle=xtitle,ytitle=ytitle,title=title,color=2 
stop


;*********************************

stop
if RP_COMB eq 1 then begin
;ELECTRON_SPEC(idx)=!VALUES.F_NAN
energy_channels=dblarr(channels)
energy_channels(0:(size_peace_data(2)-1))=center_peace
energy_channels(size_peace_data(2):channels-1)=rapid_centre_channels(0,*)
ytitle='sec^3/km^6'
xtitle='eV'
plot,energy_channels(idx),electron_spec(timeselect,idx),psym=4,/xlog,/ylog,xrange=[35,400000],XTICKINTERVAL=10,yrange=[1e-15,1e5],xtitle=xtitle,ytitle=ytitle,title=title_time

endif







;********************************************************************************************


;**********************
;*****************************CREATE array to hold entire ELECTRON SPECTRA
rapid_centre_channels=rapid_centre_channels*1000;change to eV for plotting
size_rapid_data=size(rapid_PSD)
size_peace_data=size(peace_psd)
channels=size_peace_data(2)+size_rapid_data(2)
ELECTRON_SPEC=dblarr(size_peace_data(1),channels)
ELECTRON_SPEC(*,0:(size_peace_data(2)-1))=peace_PSD
ELECTRON_SPEC(*,size_peace_data(2):(channels-1))=rapid_psd

timeselect=7
;timeselect=timeselecta*60/4.0
title_time=tai2utc(tai_rapid(timeselect),/ecs)
title_psd_time=tai2utc(tai_PEACE_PSD(timeselect),/ecs)
print,title_time
idx=where(electron_spec(timeselect,*) ne 0)















end




;******************************************************************************
;*  NAME:        read_cluster_peace
;*
;*  DESCRIPTION: Routine to read cluster_peace files. Adheres to
;*               papco conventions: Error common block
;*                                  Uses MJDT time
;*                                  papco read philosophy
;*
;*  INPUT:       none (uses common block time from papco)
;*
;*  OUTPUT:      none (places data into common blocks)
;*
;*  KEYWORDS:    VERBOSE  -  enables print comments, save/restore comments
;*
;*  DATE:        2003
;*
;*  AUTHOR:      Matt Taylor modified version of  R. Friedel code
;*x
;******************************************************************************
pro read_cluster_peace, plotinfo, VERBOSE=VERBOSE

COMMON cluster_peace_data, input_data
COMMON mjdt, mjdt_start, mjdt_end
COMMON get_error, get_err_no, get_err_msg
get_err_no=0  &  get_err_msg='cluster_peace read succesfully'
   
; check env. variable pointing to data directory
if not (papco_check_data_env('CLUSTER_PEACE_DATA', PATH=path)) then return
   
; check VERBOSE keyword and set
if keyword_set(VERBOSE) then verbose=VERBOSE else verbose=0     

verbose = 1  

; clear data arrays for reuse
input_data=0


convert_t90_to_date, mjdt_start, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt

;make list of files to be read for time period
file = plotinfo.soptions(2) 
cdf_type = plotinfo.soptions(1) 
sat_id = 'C'+varprt(plotinfo.ioptions(0)+1)
papco_sepdir, file, path, fln, ext
;get position of date string in file
test = byte(fln) ; make ASCII codes of file string. '0'->'9' = 48->57
idx = where((test GE 48) AND (test LE 57))
test(*) = 0 & test(idx) = 1
FOR i = 0, n_elements(test)-2 DO IF test(i+1) GT 0 THEN $
  test(i+1) = test(i+1)+test(i)
idx = where(test EQ 8) & p = idx(0)-7

;get position of year string in path
test = byte(path) ; make ASCII codes of file string. '0'->'9' = 48->57
idx = where((test GE 48) AND (test LE 57), cp)
IF cp NE 0 THEN begin
    test(*) = 0 & test(idx) = 1
    FOR i = 0, n_elements(test)-2 DO IF test(i+1) GT 0 THEN $
      test(i+1) = test(i+1)+test(i)
    idx = where(test EQ 4) & py = idx(0)-3
ENDIF 


reread_PEACE:
files = strarr(mjdt_end.mjd-mjdt_start.mjd+1)
time = mjdt_start
print,mjdt_start,mjdt_end
;peace cdf's have yyyyddd
FOR i = mjdt_start.mjd, mjdt_end.mjd DO BEGIN
    time.mjd = i & time.t = 0
    if (mjdt_end.mjd eq time.mjd) AND (mjdt_end.t eq 0) THEN break
    convert_t90_to_date, time, year, day_oy, hour, minute, second,$
                         month, cmonth, day_om, /mjdt
print,day_oy
    date = string(year,day_oy, format='(i4.4,i3.3)')
    year = string(year, format='(i4.4)')
    ;substitute year in path, filename if needed
    this_path = path
    IF cp NE 0 THEN strput, this_path, year, py
    this_file = fln
    strput, this_file, date, p
    this_file = strmid(this_file, 0, p+7)
    res = findfile(this_path+this_file+'*.cdf', count = n)
    IF n NE 0 THEN this_file = res(0) ELSE this_file = ''
    files(i-mjdt_start.mjd) = this_file
ENDFOR

;test for file exist, remove from list if not exist
FOR i = 0, n_elements(files) -1 DO BEGIN
    res = findfile(files(i), count = n) 
    IF n EQ 0 THEN files(i) = ''
ENDFOR

idx = where(files NE '', n)
IF n EQ 0 THEN BEGIN
    msg = 'No '+cdf_type+' cdf files found for timeperiod'
    message, msg, /cont
    get_err_no = 1 & get_err_msg = msg
;    return
message, '!!!!!! Try to create cdf from SDDAS exportIDFS !!!!!!', /cont
ENDIF

;****************************************************************************************
;* using SDDAS exportIDFS command to export PEACE cdf's
;* exportIDFS expects following format, where exportfile is a .exp
;file created by Matt TAylor in SDDAS, which sets up particular PEACE
;data products for export. Here we only have a 13 zone DNF export for
;HEEA and LEEA. exportfile below should be layout filename without
;extension.
;* -BTime and -ETime are beginning and end times respectively,
;!!!!!!!!!!!!!!!!!!have set time to read entire day!!!
;* time format YYYY/DDD:HH:MM:SS.msc
;* exportIDFS -FName <exportfile> -Btime <starttime>  -Etime <endtime>
;* 
;****************************************************************************************

IF n EQ 0 THEN Begin
a_zero=0
convert_t90_to_date, mjdt_start, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt
SDDAS_ST_TIME = string(yr,day_oy,hr,min,sec,a_zero,format='(i4.4,i4.4,i3.3,i3.3,i3.3,i5.5)') 
SDDAS_CHK_TIME = string(yr,day_oy,hr,min,sec,format= '(i4.4,i3.3,i2.2,i2.2,i2.2)' ) 
convert_t90_to_date, mjdt_end, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt
SDDAS_END_TIME = string(yr,day_oy,hr,min,sec,a_zero,format='(i4.4,i4.4,i3.3,i3.3,i3.3,i5.5)') 
print,'nothere'
strput, SDDAS_END_TIME, '/', 4
strput, SDDAS_END_TIME, ':', 8
strput, SDDAS_END_TIME, ':', 11
strput, SDDAS_END_TIME, ':', 14
strput, SDDAS_END_TIME, '.', 17


strput, SDDAS_ST_TIME, '/', 4
strput, SDDAS_ST_TIME, ':', 8
strput, SDDAS_ST_TIME, ':', 11
strput, SDDAS_ST_TIME, ':', 14
strput, SDDAS_ST_TIME, '.', 17

;**********************************
;SDDAS_END_TIME = SDDAS_ST_TIME+':23:59:59:9999';use this to force
;whole day read
;SDDAS_ST_TIME = SDDAS_ST_TIME+':00:00:00:0000';use this to force
;whole day read
;*******************************
papco_sddas_exp_path ='~/papco_user/papco_user_modules/cluster_peace/papco_sddas_peace_exp/'
;SDDAS_EXPORT_PATH ='/n/radbelt/data0/taylor/SDDAS/SDDAS_HOME/bin/'
exp_filename = path+cdf_type+'_'+sat_id
spawn, 'unset noclobber'
spawn, papco_sddas_exp_path+'exportIDFS -FName '+exp_filename+' -BTime '+SDDAS_ST_TIME+' -ETime '+SDDAS_END_TIME
spawn, 'set noclobber'

;build check string
IF cdf_type EQ 'full_HEEA' THEN begin
check_string = 'CLUSTER-'+strmid(sat_id,1)+'_HSPAD_'+SDDAS_CHK_TIME+'_V1.cdf'
ENDIF
IF cdf_type EQ 'full_LEEA' THEN begin
check_string = 'CLUSTER-'+strmid(sat_id,1)+'_LSPAD_'+SDDAS_CHK_TIME+'_V1.cdf' 
ENDIF

check_string = check_string
check_existence = findfile(check_string, count = cnt)
  IF cnt EQ 0 THEN begin
  msg = 'No '+cdf_type+' cdf files exist/available from PEACE DATABASE'
  message, msg, /cont
  return
  ENDIF

  if cnt ne 0 then begin

    if cdf_type eq 'full_HEEA' then begin
     spawn, 'unset noclobber'
     spawn, 'mv '+check_string+ ' /n/radbelt/dlnk/cluster/peace/SDDAS_output/full_HEEA/' 
     spawn, 'set noclobber'
    endif
    if cdf_type eq 'full_LEEA' then begin
     spawn, 'unset noclobber'
     spawn, 'mv '+ check_string+ ' /n/radbelt/dlnk/cluster/peace/SDDAS_output/full_LEEA/'
     spawn, 'set noclobber'
    endif  


;******************************
files = strarr(mjdt_end.mjd-mjdt_start.mjd+1)
time = mjdt_start
stop
;peace cdf's have yyyyddd
FOR i = mjdt_start.mjd, mjdt_end.mjd DO BEGIN
    time.mjd = i & time.t = 0
    if (mjdt_end.mjd eq time.mjd) AND (mjdt_end.t eq 0) THEN break
    convert_t90_to_date, time, year, day_oy, hour, minute, second,$
                         month, cmonth, day_om, /mjdt
    date = string(year,day_oy, format='(i4.4,i3.3)')
    year = string(year, format='(i4.4)')
    ;substitute year in path, filename if needed
    this_path = path
    IF cp NE 0 THEN strput, this_path, year, py
    this_file = fln
    strput, this_file, date, p
    this_file = strmid(this_file, 0, p+7)
    res = findfile(this_path+this_file+'*.cdf', count = n)
print,res
    IF n NE 0 THEN this_file = res(0) ELSE this_file = ''
    files(i-mjdt_start.mjd) = this_file

    print, files(i-mjdt_start.mjd)
ENDFOR

;test for file exist, remove from list if not exist
FOR i = 0, n_elements(files) -1 DO BEGIN
    res = findfile(files(i), count = n) 
    IF n EQ 0 THEN files(i) = ''
ENDFOR

idx = where(files NE '', n)
IF n EQ 0 THEN BEGIN
    msg = 'No '+cdf_type+' cdf files found for timeperiod'
    message, msg, /cont
    get_err_no = 1 & get_err_msg = msg
;    return
message, '!!!!!!!!!!! SDDAS export failed', /cont
ENDIF


;******************************


 endif


ENDIF

FOR i = 0, n-1 DO BEGIN

    r_cluster_peace_onefile, files(i), plotinfo, VERBOSE=VERBOSE
                                ;need to "concatonate" the data. Not
                                ;easy, so don't read over fiel
                                ;boundaries yet!

ENDFOR

END 








PRO matt_papco_hilmer_phase_space_density, low_energy_channel_values, $
                                      top_energy_channel_values, $
                                      diff_flux, PSD
;electron_mass = 1.6726e-31;in kg
;light_speed = 2.9979e5; in km/s

REST_ENERGY = 0.511 ;MeV

;assume energy channel arrays are the same size and consequtive
;this assumes energy channel values are in keV and converts to MeV
KMIN = (low_energy_channel_values)/1000.0 
KMAX = (top_energy_channel_values)/1000.0
size_low_energy_channels = n_elements(KMIN) 
size_top_energy_channels = n_elements(KMAX)
size_diff_flux = size(diff_flux)

IF size_low_energy_channels NE size_top_energy_channels THEN $
  message,'energy bins not fully defined' ELSE $
  message,'energy bins defined', /continue
IF size_low_energy_channels NE size_diff_flux(2) THEN $
  message, 'incorrect number of energy channels in data' ELSE $
  message, 'data bin check complete', /CONTINUE

P_2_c_2 = dblarr(size_low_energy_channels)
;sets up PSD array same size as diff_flux
PSD = dblarr(size_diff_flux(1), size_diff_flux(2))
arse_PSD=PSD
;----this loop uses Hilmer et al equation to define PSD
FOR i = 0.0, size_low_energy_channels-1 DO BEGIN
    P_2_c_2(i) = (1/2.0)*(KMIN(i)*(KMIN(i)+(2*REST_ENERGY))+KMAX(i)*(KMAX(i)+(2.0*REST_ENERGY)))
    PSD(*, i) =(1.66e-10)*diff_flux(*, i)/P_2_c_2(i)
END 

;PSD is in units of  s^3 km^-6
END
