;------------------------------------------------------------------------------
;* Sets up some common blocks for CLUSTER PEACE
pro cluster_peace_commons
  
COMMON cluster_peace, sc_names, data_names, peace_cdfdir, ek_arr,cluster_peace_control
    
;setup CLUSTER spacecraft names
sc_names=['CLUSTER 1 (Rumba)','CLUSTER 2 (Salsa)', $
          'CLUSTER 3 (Samba)','CLUSTER 4 (Tango)']
sc_names=['CLUSTER 1','CLUSTER 2', 'CLUSTER 3','CLUSTER 4']

;setup plot data types
data_names = ['Spin Averaged Spectra', $
              'All Pitch Angles @ one Energy', $
              'All Energies @ one Pitch Angle', $
              'All Pitch Angles for an Energy Range', $
              'All Energies for a Pitch Angle Range', $
              'Pitch Angle Range @ an Energy Range',$
              'ANISOTROPY']

;peace_cdfdir = ['full HEEA', 'full LEEA', 'survey HEEA', 'survey LEEA']
peace_cdfdir = ['full HEEA', 'full LEEA', 'HEEA_BETA', 'LEEA_BETA','TOP_MOM','HEEA_OLAP_MOM','j_par_approx']

heea_ek = [[0.10000, 0.10000, 0.498397, 2.57194, 2.80615, 3.10052, 3.30456, 3.41405, 3.61833, 3.92974, 4.21080, 4.44697, 4.81420, 5.38892, 5.96428, 6.44104, 6.96981, 7.69622, 8.55320, 9.45042, 10.5351, 11.9179, 13.4739, 15.1131, 16.9637, 19.1295, 21.5240, 24.0850, 27.0087, 30.4484, 34.2202, 38.2203, 42.6846, 47.8097, 53.7152, 60.3113, 67.4652, 75.5652, 84.7877, 94.9629, 106.220, 118.800, 132.965, 148.764, 166.246, 185.728, 207.630, 232.346, 260.165, 291.186, 325.392, 363.477, 406.319, 453.975, 506.719, 566.115, 633.030, 709.963, 796.060, 889.443, 994.324, 1110.81, 1239.84, 1384.94, 1548.61, 1731.35, 1935.43, 2163.83, 2419.41, 2703.26, 3016.74, 3368.18, 3764.84, 4208.51, 4703.32, 5254.35, 5868.83, 6553.64, 7316.52, 8171.88, 9130.99, 10204.6, 11401.2, 12740.1, 14248.1, 15934.5, 17809.7, 19892.7, 22340.7, 23748.3, 23748.3, 23748.3, 23748.3], $
[0.10000, 0.498397, 2.57194, 2.80615, 3.10052, 3.30456, 3.41405, 3.61833, 3.92974, 4.21080, 4.44697, 4.81420, 5.38892, 5.96428, 6.44104, 6.96981, 7.69622, 8.55320, 9.45042, 10.5351, 11.9179, 13.4739, 15.1131, 16.9637, 19.1295, 21.5240, 24.0850, 27.0087, 30.4484, 34.2202, 38.2203, 42.6846, 47.8097, 53.7152, 60.3113, 67.4652, 75.5652, 84.7877, 94.9629, 106.220, 118.800, 132.965, 148.764, 166.246, 185.728, 207.630, 232.346, 260.165, 291.186, 325.392, 363.477, 406.319, 453.975, 506.719, 566.115, 633.030, 709.963, 796.060, 889.443, 994.324, 1110.81, 1239.84, 1384.94, 1548.61, 1731.35, 1935.43, 2163.83, 2419.41, 2703.26, 3016.74, 3368.18, 3764.84, 4208.51, 4703.32, 5254.35, 5868.83, 6553.64, 7316.52, 8171.88, 9130.99, 10204.6, 11401.2, 12740.1, 14248.1, 15934.5, 17809.7, 19892.7, 22340.7, 23748.3, 23748.3, 23748.3, 23748.3, 23748.3]]


leea_ek = [[0.10000, 0.10000, 0.483322, 2.44639, 2.68552, 3.02283, 3.34159, 3.48175, 3.71056, 4.19815, 4.76817, 5.27215, 5.89445, 6.61417, 7.17805, 7.67898, 8.12941, 8.57109, 9.21479, 10.1405, 11.5357, 13.3086, 15.0981, 16.8817, 18.6946, 20.6044, 22.7241, 25.1668, 28.1544, 31.8123, 35.8795, 40.0600, 44.4137, 49.0974, 54.5542, 61.1451, 68.6406, 77.0212, 86.4171, 96.6536, 107.693, 119.923, 133.771, 149.489, 167.249, 187.021, 209.075, 233.814, 261.218, 291.657, 325.853, 364.375, 407.024, 454.233, 507.375, 567.015, 636.372, 713.651, 796.580, 890.082, 994.544, 1110.14, 1240.00, 1386.35, 1549.63, 1731.78, 1935.29, 2162.66, 2417.82, 2701.20, 3011.52, 3365.22, 3767.21, 4202.88, 4687.91, 5237.52, 5845.77, 6521.41, 7287.68, 8147.80, 9103.58, 10175.6, 11366.0, 12695.0, 14195.3, 15801.6, 17500.4, 19592.7, 22396.6, 24065.7, 24065.8, 24065.8, 24065.8 ], $
[0.10000, 0.483322, 2.44639, 2.68552, 3.02283, 3.34159, 3.48175, 3.71056, 4.19815, 4.76817, 5.27215, 5.89445, 6.61417, 7.17805, 7.67898, 8.12941, 8.57109, 9.21479, 10.1405, 11.5357, 13.3086, 15.0981, 16.8817, 18.6946, 20.6044, 22.7241, 25.1668, 28.1544, 31.8123, 35.8795, 40.0600, 44.4137, 49.0974, 54.5542, 61.1451, 68.6406, 77.0212, 86.4171, 96.6536, 107.693, 119.923, 133.771, 149.489, 167.249, 187.021, 209.075, 233.814, 261.218, 291.657, 325.853, 364.375, 407.024, 454.233, 507.375, 567.015, 636.372, 713.651, 796.580, 890.082, 994.544, 1110.14, 1240.00, 1386.35, 1549.63, 1731.78, 1935.29, 2162.66, 2417.82, 2701.20, 3011.52, 3365.22, 3767.21, 4202.88, 4687.91, 5237.52, 5845.77, 6521.41, 7287.68, 8147.80, 9103.58, 1017.6, 11366.0, 12695.0, 14195.3, 15801.6, 17500.4, 19592.7, 22396.6, 24065.7, 24065.8, 24065.8, 24065.8, 24065.8]]

ek_arr = [[HEEA_EK], [LEEA_EK]]  





;finally, set up a structure for all the variables needed by the
;cluster rapid module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains mre
;descriptive and verbose tags for easier use.


cluster_peace_control = {cluster_peace_control, $
  cdf_dir:0,     cdf_dir_info:'index into the list of cdf directories ', $
  var_list:0,   var_list_info:'index into the list of variables',$
  sc_id:0,      sc_id_info:'Number of CLUSTER spacecraft; 0,1,2,3', $
  data_src:'',   data_src_info:'Data Source select; 0-full HEEA, 1-full LEEA, 2-HEEA BETA,3-LEEA BETA,4-TOP MOM,5-HEEA_OLAP_MOM,6-j para approx', $
  reload:0,     reload_info:'0-reload data, 1-Adopt memory', $
  smooth:0,     smooth_info:'Smooth line plots/spectra; smooth range', $
  pl_type:0,    pl_type_info:'Plot type select; 0-spin averaged spec,1-All PA @ 1 energy, 2-all E @ 1 PA,3-All PA for E range, 4-All E for PA range,5-PA @ E range, 6-ANISOTROPY', $
  pl_style:0.0,   pl_style_info:'Plot Style; 0-spec color, 1-multiple line', $
  pa_bin1:0.0,    pa1_info:'PITCH ANGLE BIN start',$
  pa_bin2:0.0,    pa2_info:'PITCH ANGLE BIN stop',$
  EK_CH1:0.0,    EK1_info:'energy channel start',$
  EK_CH2:0.0,    EK2_info:'energy channel stop',$
  cdf_type:0,   cdf_type_info:'index of the cdf type,ordered in units '+ $
                               '0-cnts,1-dnf,2-def', $
  cdf_file:'',   cdf_file_info:'Sample cdf file name from cdf directory', $
  cdfvar_name:'',cdfvar_name_info:'CDF variable selected i.e. HEEA 15deg etc.code only accepts certian values for plotting', $
  peace_unts:'',      units_info:'Data units; cts, DNF, DEF',$
  data_type:0,data_type_info:'PEACE data types, ie PA @ fixed E etc', $
  sauvaud:0.0, sauvaud_info:'switch to turn on sauvaud plotting format'}


;aplotinfo.typevector(0)=cdf_dir
;aplotinfo.ioptions(13)=units
;aPlotInfo.ioptions(11)=reload
;aPlotinfo.typevector(1)=var_list
;aplotinfo.ioptions(0)=sc_id
;aplotinfo.ioptions(5)=data_type
;aplotinfo.ioptions(2)=pl_stlye
;aplotinfo.ioptions(10)=smooth
;aplotinfo.iopions(6)=pa_bin1
;aPlotInfo.ioptions(7)=ek_ch1
;aPlotInfo.ioptions(8)=pa_bin2
;aPlotInfo.ioptions(9)=ek_ch2
;aplotinfo.ioptions(13)=data_src
;
;
;
;
;
;
;
;;
;
;

END 



