;******************************************************************************
;* file papcoadd_cluster_peace
;*      papcoadd_cluster_peace
;* end
;*
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      PRO addplottype_cluster_peace,plottypes_base,buttonGeometry,pb_plottype
;* 
;* DESCRIPTION:  
;*      This proc adds a button for this cluster_peace to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*      package, so that they can be automatically called when needed.
;*      The button itself can contain access to a sub-menu for further
;*      cluster_peaces.
;*
;* INPUTS:       
;*      plottypes_base  the widget ID of the parent widget to contain the
;*                      plottype buttons.
;*
;* OUTPUTS: 
;*      pb_plottype     the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for sub-types.
;*
;* KEYWORDS:
;*       none
;* 
;* CALLING SEQUENCE:
;*      addplottype_cluster_peace,plottypes_base,buttonGeometry,pb_plottype
;******************************************************************************
PRO addplottype_cluster_peace,plottypes_base,buttonGeometry,pdm_cluster_peace

MenuDesc = [ { CW_PDMENU_S, 3, strcenter('C-II PEACE',10) }, $ 
             { CW_PDMENU_S, 0, 'configure cluuster peace' }, $
             { CW_PDMENU_S, 2, 'cluster peace ' } ]  
  
pdm_cluster_peace = CW_PDMENU(plottypes_base, MenuDesc, $
                          UVALUE='pdm_cluster_peace')

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO addpanel_cluster_peace
;*
;* DESCRIPTION:  
;*      Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      Using an instance of the papco_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled. The
;*      desired default values for the plotinfo tags need to be edited by
;*      the user. This plotinfo structure will be passed to the panel editor
;*      When it is first called for the cluster_peace.
;*      "panelEditor" must be set to the name of the panel editor routine.
;*
;* INPUTS:       
;*      event           event value of papco main window. This is
;*                      only used if there are plot sub_types, 
;*                      for example see papcoadd_crres_plots
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      addpanel_cluster_peace
;***************************************************************************
pro addpanel_cluster_peace, event

common get_error, get_err_no, get_err_msg
  
; The case statement here needs an entry for every submenu type you
; added in  the first procedure in this file (addplottype_cluster_peace).
; For each submenu entry, you will need to specify the panelEditor to use.  
  
; The FIRST time you use this module you will have to configure it,
; i.e. set the data paths etc. Once you have done this PAPCO will
; write a cluster_peace.config file into your papco_user_XX/papco_modules_defaults
; directory. 
; So here we check if this cluster_peace.config file exists, and if not,
; we disallow the execution of any other option apart from "configure
; cluster_peace". In this way the user is forced to configure the module
; before using it the first time!
  
panelKind='cluster_peace'
panelKind=strlowcase(panelKind)
  
r_module_config, panelKind, config_data, msg
if (get_err_no ne 0) and (event.value ne 1) then begin
    message,'You need to configure the module first', /cont
    papco_module_configure,panelKind
    return
endif  
   
CASE event.value of
    1: BEGIN
        papco_module_configure, panelKind
    end
    2: BEGIN
        panelEditor=panelkind+'_panel'
        defaults=papco_getPlotInfoStruct() ;returns a basic plotinfo structure
        defaults.typeVector=[0,0,0,0]      ;set some tags to desired defaults
        defaults.channel=0            
        defaults.ioptions(6:9) = 1 ;slider values
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults     
    end
    else: begin
      message,'Nothing defined for this submenu entry', /cont
      return
    end  
endcase
      
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO plottable_cluster_peace, plottable
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate plottable with / without orbit.
;*      PAPCO provides "set time by orbit" feature for CRRES and POLAR
;*      so far. Included for compatibility with older CRRES modules
;*      which ONLY use orbit as input to their read/plot routines
;*      (plotting over orbit boundaries is not enabled for CRRES)
;* 
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "plottable_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_cluster_peace.
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      plottable        a boolean 0 if plottable only by orbit
;*                                 1 if plottable by time also.
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;******************************************************************************
pro plottable_cluster_peace, plottable

plottable=1     ; 1 -> plotable without orbit info, by time 
                ; 0 -> plotable only by orbit number not by time 
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO canget_cluster_peace, canget
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate that cluster_peace support the OUTPUT
;*      functionality. 
;*      
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "canget_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_cluster_peace.
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      canget         a boolean 0 if this feature is not available
;*                               1 if this feature is available
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      canget_cluster_peace, canget
;******************************************************************************
pro canget_cluster_peace, canget

canget=  1      ; 1 -> plot routine can return just data to file
                ; 0 -> feature disabled
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO descriptor_cluster_peace, plotInfo, descriptStr
;*
;* DESCRIPTION:  
;*      Constructs the string used to label plots in the panel window.
;*      The plotinfo structure passed in here is the panel's plotinfo
;*      as returned by the panel editor for this cluster_peace. You can use
;*      the information in that structure to construct some informative
;*      label for the panel which then appears in the Panel Compose list.
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "descriptor_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_cluster_peace.
;*
;* INPUTS:       
;*      plotInfo        structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*      descriptStr     a string containing the label
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      descriptor_cluster_peace, plotInfo, descriptStr
;******************************************************************************
pro descriptor_cluster_peace, plotInfo, descriptStr
  

control = *plotinfo.USR_PTR1
descriptStr=descriptStr+control.data_src+' '+control.cdfvar_name
   
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO draw_cluster_peace, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:  
;*      This procedure performs the actual data read call and the plot call
;*      for this plottype. The user need to pass to his plot routine all the
;*      parameters needed, typically these parameters are stored in the 
;*      currplotinfo structure or constructed from them. The currplotinfo
;*      structure tags normally used for passing information from the panel
;*      editor to the plot routine are:
;*          type_vector - a four element array for choosing the type of data
;*                        (eg. elec or ion, diff or integ., pitch angle, 
;*                             or sector, channel ....)
;*          swittch      - a three element vector for specific plot appearance
;*                        (eg. smoothing/averaging, interpolating ...)
;*          filename    - a filename
;*      
;*      These tags have grown out of traditional usage and can be used for
;*      anything the user wants to use them for. There are plenty variables
;*      for most applications: Adding a new tag to the plotinfo structure
;*      is not user-definable but need to be done at the papco core level.
;* 
;*      The panelVector MUST be passed to your plotroutine as it is used
;*      to set the panel position.
;*      The _EXTRA=extra_PlotInfo should be passed if you intend to make use
;*      of papco functionality such as overplotting, linestyle choice and
;*      color bar choice.
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "draw_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_cluster_peace.
;*
;* INPUTS:       
;*      panelVector    position of the plot (see papco_conventions.text, 6)
;*      currPlotInfo   structure containing all data for this plot.
;*                     (structure papco_PLOTINFO, see papco_variables.text) 
;*
;* OUTPUTS: 
;*      get_data_call  a string containing the data call. Used by other
;*                     routines that need to know how to get the data
;*                     in a panel, e.g. to draw spectra, distribution functions
;*      IsRead         a boolean which is set when the the data is read the
;*                     first time. Useful if a given data-read puts data
;*                     into commons which can be plotted in many ways.
;*                     When set, data does not have to be read again.
;   slice_type:   Selects which slices are supported and for which slice
;                 routines have been written.
;                 This is an integer logical with 16 swittches. Currently
;                 there are 5 papco slices. You may extend this by
;                 further USER slices up to a total of 16 slices.
;                     0 = disable all slices
;                     1 = papco Zoom                 (2^0)
;                     2 = papco Vert Slice           (2^1)
;                     4 = papco Access level Zero    (2^2)
;                     8 = papco Write Paneldata      (2^3)
;                    16 = papco Hair Cursor          (2^4)
;                    32 = papco Horiz Slice          (2^5)  
;                    64 = papco multiple Slice       (2^6)
;                   128 = USER slice A or not used   (2^7)
;                   256 = USER slice B or not used   (2^8)
;                    "     "     "   "  "  "    "      "
;                 32768 = USER slice Z or not used  (2^15)
;                        
;   You can support more than one type of slice by arithmetically adding the
;   options, eg slice_type=1+4  support Zoom and Level Zero
;*
;* KEYWORDS:
;*      OUTPUT        if set then plot routine should output data to file,
;*                    as well as to screen.
;*
;* CALLING SEQUENCE:
;*      draw_cluster_peace, panelVector, currPlotInfo, orbitNo, $
;*                      get_data_call, slice_type, IsRead, NODATA=NODATA
;******************************************************************************
pro draw_cluster_peace, panelVector, currPlotInfo, orbitNo, $
                    get_data_call, slice_type, IsRead, $
                    OUTPUT=OUTPUT

COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
    
control = *currplotinfo.USR_PTR1
get_data_call=''   ; data read call used by slices

; as papco dynamically allocates slice values for the user defined
; slices, one needs to be able to find out this assignment! Use the
; following function to find out the slice values for any slices you
; might have added for your module, so that you know which values to enable!
  
slice_assigned_value=papco_slice_value('USER Defined Slice A')
  
; set up which mouse functions to allow
slice_type=1+2+16+32

IF NOT control.reload THEN IsRead = 0 ;reload/adopt option
IF NOT IsRead THEN BEGIN          ; check if data has already been read

  IF control.data_src ne 'j_par_approx' then begin
    r_cluster_peace, currPlotInfo     ; read data
    ; check the read for success.
    IF papco_Draw_CheckResult(currPlotInfo.panelKind, $
                              panelVector, orbitNr, $
                              currPlotInfo.typeVector, $
                              currPlotInfo.channel)       THEN IsRead=1 $
    ELSE IsRead=0
  ENDIF else begin
     IsRead=1
  endelse


ENDIF

IF IsRead THEN BEGIN
   IF control.pl_style eq 1 THEN $ 
     p_cluster_peace_line, panelVector, currPlotInfo, OUTPUT=OUTPUT, $
                          _EXTRA=extra_PlotInfo $
 ELSE $
     p_cluster_peace_spec, panelVector, currPlotInfo, OUTPUT=OUTPUT, $
                          _EXTRA=extra_PlotInfo 
ENDIF

; Note: The structure extra_PlotInfo passed to the plot routine contains the
;       following tags: 
;                  overPlot               - overplot swittch
;                  plots_AtThisPosition   - no..c of overplots here
;                  subtable               - index of papco colortable 
;                  PSYM                   - linestyle keyword for plot
;                  COLOR                  - linecolor keyword for plot
;               
;       They are set by papco and your plot routine can use them if you
;       want to support that functionality.

END
