;******************************************************************************
;* file p_cluster_peace_line.pro
;*
;* this file is a template for a plot routine which can be used by papco.
;* it includes all the periphery needed, the user simply has to add in
;* the actual plot statement for his/her kind of data.
;*
;* This is a working example for a pre-defined example data array.
;******************************************************************************
;******************************************************************************
;* PROCEDURE:     
;*      p_cluster_peace_line, panel, type, OUTPUT=OUTPUT, $
;*           OVERPLOT=OVERPLOT,$
;*           PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           SUBTABLE=SUBTABLE, $
;*           _EXTRA=extra_par
;* 
;* DESCRIPTION:  
;*	This procedure plots data of type data_type for inclusion in papco.  
;*      Data must have been read and placed into common blocks before this
;*      routine is called. Behavior is controlled by the vector panel
;*	which controls positioning of the plot (see papco_conventions.text
;*      in $papco). In general, the following plot conventions are used:
;*              - if the panel is at the bottom plot time axis plus any
;*                additional axis (ie ephemeris) needed.
;*              - if panel is at the top also plot a title
;*              - a descriptor for panels is plotted to the right of each
;*                panel, rotated by 90 deg if there is a papco_colorbar.
;*              - panels all have common time
;*              - y-scaling (or z-scaling for color plots) is either
;*              - automatic or manualy set using common yscale or zscale   
;*
;* INPUTS:       
;*      panel   three element integer vector. Controls positioning of the plot
;*              (see papco_conventions.text in $papco)
;*      type    optional parameter for options. Normally is a four element
;*              integer vector. This is normally equivalent to the field
;*              typeVector of the papco structure papco_PLOTINFO which is set
;*              by the panel editor. Additional fields that can be used if
;*              needed are papco_plotinfo.ioptions (20 element vector) and 
;*              papco_PLOTINFO.channel (integer). If your plot routine needs
;*              more input fields than these you have to extend the definition
;*              of the structure papco_PLOTINFO
;*              (procedure papco_getPlotInfoStruct in $papco/papco.pro). Try to
;*              avoid this!
;*              
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      OUTPUT  if set call the papco routine that outputs plot data
;*              to a file.
;*    OVERPLOT  if you support this you can alter the appearance of your
;*              plot if it is an overplot to an existing panel. Standard is
;*              to plot data, no axis, using the y-scaling of the first plot
;*              and to shift the labeling on the left down one line. Useful
;*              to plot model data together with real data, ie mag. field.
;*              see p_crres_mag for an example.
;*    PLOTS_ATTHISPOSITION  used to control the left side labeling for more
;*              than one overplot at the same position.
;*      _EXTRA  the plot structure containing some keyword for calls to
;*              plot. Used to customize color and line style.   
;* 
;* CALLING SEQUENCE:
;*       p_cluster_peace_line, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;*
;* MODIFICATION HISTORY:       
;*     written December 1995, Reiner Friedel, at Goddard
;*     added OUTPUT support, July 1998, , Reiner Friedel
;******************************************************************************
pro p_cluster_peace_line, panel, plotinfo, OUTPUT=OUTPUT, $
                      OVERPLOT=OVERPLOT, $
                      PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION, $
                      SUBTABLE=SUBTABLE, $
                      _EXTRA=extra_par

 ; The following common blocks are needed:
COMMON mjdt, mjdt_start, mjdt_end               ;time limit in mjdt
COMMON yscale, yscl                             ;man/auto yscaling
COMMON shift_label, down                        ;for x-axis label shifting
COMMON coordinateSystems, plotted_x, plotted_y  ;info on coords
COMMON papco_color_names
COMMON PLOT_COMPOSER, widgetData
;retrieve the control structure for this module.
; One of the common blocks should contain the plot data as returned by the
; data read procedure r_cluster_peace. 
COMMON cluster_peace_data, input_data
  
panelset,panel			;sets the panel position viewport


;DO FOR J_par_approx 

control = *plotinfo.USR_PTR1
sc_id=control.sc_id
old_control=control

   if control.data_src eq 'j_par_approx' then begin
             orig_data_src=control.data_src
             ;LOAD IN full HEEA
             control.data_src='full_HEEA'
             cdf_path=control.cdf_file
             test=strsplit(cdf_path,/extract,'/')
             test(6)='full_HEEA'
             cdf_path=strjoin(test,'/') 
             control.cdf_file='/'+cdf_path
             control.cdf_dir=0 
             *plotinfo.USR_PTR1=control
;             help, control,/st
             r_cluster_peace,plotinfo
             input_data_HEEA=input_data
             input_data=0
             print,'DONE HEEA'
                               ;LOAD IN full LEEA
             control.data_src='full_LEEA'
             cdf_path=control.cdf_file
             test=strsplit(cdf_path,/extract,'/')
             test(6)='full_LEEA'
             test1=strsplit(test(7),/extract,'_')
             test1(1)='LSPAD'
             test2=strjoin(test1,'_')
             test(7)=test2
             cdf_path=strjoin(test,'/') 
             control.cdf_file='/'+cdf_path
             control.cdf_dir=1
             test=control.cdfvar_name 
             test2=strpos(test,'HEEA')
             strput,test,'LEEA',test2
             control.cdfvar_name=test
             test_old=test
             *plotinfo.USR_PTR1=control 
 ;            help, control,/st
             r_cluster_peace,plotinfo
             input_data_LEEA=input_data
             input_data=0
             control.data_src=orig_data_src
      ;      control.cdf_file=
             control.cdf_dir=6
             control.cdfvar_name=test_old
             peace_control=control
             *plotinfo.USR_PTR1=control 
             COMMON papco_cdf_data, input_data_cdf

; ----------------------------------------------------------read in
; efw data
COMMON papco_cdf, papco_cdf_control

             time = mjdt_start
       FOR i = mjdt_start.mjd, mjdt_end.mjd DO BEGIN
           time.mjd = i & time.t = 0
           if (mjdt_end.mjd eq time.mjd) AND (mjdt_end.t eq 0) THEN break
                      convert_t90_to_date, time, year,day_oy, hour, minute, second,$
                         month, cmonth, day_om, /mjdt
                        date = string(year,day_oy, format='(i4.4,i3.3)')
                        year = string(year, format='(i4.4)')
       endfor

        efw_date = string(year,month,day_om, format='(i4.4,i2.2,i2.2)')
        sc_id_str=string(sc_id+1)
        sc_id_str=strcompress(sc_id_str,/REMOVE_ALL)
        sc_id_str1='c'+sc_id_str
        efw_file_name='/n/radbelt/dlnk/cdf/cluster_efw/'+year+'/'+sc_id_str1+'_pp_efw_'+efw_date+'_v02.cdf'
        papco_cdf_control.cdf_file=efw_file_name
        papco_cdf_control.cdf_type='cluster_efw'
        papco_cdf_control.cdfvar_name='U_probe_sc__C'+sc_id_str+'_PP_EFW'
        *plotinfo.USR_PTR1=papco_cdf_control 
         r_papco_cdf,plotinfo
         control=peace_control
        *plotinfo.USR_PTR1=control 
        input_data_efw=input_data_cdf
    ;----------------------------------------------------------------
   ;fgm data for Andy Wright study
stop
        papco_cdf_control.cdfvar_name='B_xyz_gse__C'+sc_id_str+'_PP_FGM'
        papco_cdf_control.cdf_type='cluster_fgm'
        papco_cdf_control.cdf_file='/n/radbelt/dlnk/cdf/cluster_fgm/'+year+'/'+sc_id_str1+'_pp_fgm_'+efw_date+'_v01.cdf'
        *plotinfo.USR_PTR1=papco_cdf_control 
        r_papco_cdf,plotinfo
 
        control=peace_control
        *plotinfo.USR_PTR1=control 
        input_data_fgm=input_data_cdf
  ;-----------------
        print,'ALL DATA READ IN'
   ;set up data arrays
       fgm_data=input_data_fgm.(0).DAT
       fgm_epoch=input_data_fgm.(1).DAT
       efw_pot=input_data_efw.(0).dat
       efw_epoch=input_data_efw.(1).dat
   
       PEACE_nodata=input_data_HEEA.(5).FILLVAL
       fgm_nodata=input_data_fgm.(0).FILLVAL
       efw_nodata=input_data_efw.(0).FILLVAL



       HEEA_EPOCH=input_data_HEEA.EPOCH.dat
       LEEA_EPOCH=input_data_LEEA.EPOCH.dat
       n_LEEA=n_elements(LEEA_EPOCH)
       n_HEEA=n_elements(HEEA_EPOCH)
       PEACE_epoch=HEEA_epoch
  
   if n_LEEA ne n_HEEA then begin
       print, '----------------------HEEA LEEA EPOCH MISMATCH-------------------------'
       print, 'write PEACE to smallest epoch'

;HEEA -> LEEA offset by 2 seconds due to spacecraft spin
;take minimum time series and set this as PEACE time.
; check heea and leea times for this time series are lt 4 secs
; difference

       hlelements=([n_leea,n_heea])
       min_peace=min(hlelements,c)
       LEEA_SPIN_ZONES=dblarr(13,93,hlelements(c))
       HEEA_SPIN_ZONES=dblarr(13,93,hlelements(c))
       test_start=heea_epoch(0)-leea_epoch(0)
       if test_start gt 4000 then print, 'START TIME ERROR'

       idx_time_gap=where(leea_epoch(0:hlelements(c)-1)-heea_epoch(0:hlelements(c)-1) lt 4000,n_n)
          PEACE_epoch=leea_epoch(idx_time_gap)
       LEEA_SPIN_ZONES=dblarr(13,93,n_n)
       HEEA_SPIN_ZONES=dblarr(13,93,n_n)

             for ii=0,12 do begin
              for jj=0,92 do begin
                LEEA_SPIN_ZONES(ii,jj,idx_time_gap)=input_data_leea.(3+ii).dat(jj,idx_time_gap)
                HEEA_SPIN_ZONES(ii,jj,idx_time_gap)=input_data_heea.(3+ii).dat(jj,idx_time_gap)
              endfor
             endfor
          n_PEACE=n_n
      endif

           fgm_mag=sqrt(fgm_data(0,*)^2 +fgm_data(1,*)^2+fgm_data(2,*)^2)


           interp_fgm_mag=papco_interpol(fgm_mag,fgm_epoch,PEACE_epoch,nodata=fgm_nodata)
           interp_efw_pot=papco_interpol(efw_pot,efw_epoch,PEACE_epoch,nodata=efw_nodata)

;---------------------------change efw and add correction frmo
;infinity (+1 as Chris Owen does)
interp_efw_pot=-interp_efw_pot +1
;----------------------------------------------------------------------------------
;-****************************************---DO nV calc----*********************

;--------------------------------------------time loop


                angle_table=[[0,7.5],[7.5,22.5],[22.5,37.5],[37.5,52.5],[52.5,67.5],[67.5,82.5],[82.5,97.5],$
                  [97.5,112.5],[112.5,127.5],[127.5,142.5],[142.5,157.5],[157.5,172.5],[172.5,180]]
             angle_table=(2*!PI/360.0)*angle_table
             e_mass=9.1094e-31;kg
             e_charge=1.6e-19;C,   1eV = 1.6e-19 J
          LEEA_E_TABLE_upper=input_data_LEEA.(0).dat + input_data_LEEA.(2).dat 
          LEEA_E_TABLE_lower=input_data_LEEA.(0).dat - input_data_LEEA.(1).dat 
          HEEA_E_TABLE_upper=input_data_HEEA.(0).dat + input_data_HEEA.(2).dat 
          HEEA_E_TABLE_lower=input_data_HEEA.(0).dat - input_data_HEEA.(1).dat 
         sum_polar=dblarr(13)
         BIGF=2*!PI
good_data=dblarr(n_PEACE)
good_data(*)=1
idx_efw=where(-(interp_efw_pot-1) eq efw_nodata,c)
idx_fgm_mag=where(interp_fgm_mag eq fgm_nodata,cc)
if c gt 0 then good_data(idx_efw)=0
if cc gt 0 then good_data(idx_fgm)=0
idx_good=where(good_data eq 1)
interp_efw_pot=interp_efw_pot(idx_good)
interp_fgm_mag=interp_fgm_mag(idx_good)
LEEA_SPIN_ZONES=LEEA_SPIN_ZONES(*,*,idx_good)
HEEA_SPIN_ZONES=HEEA_SPIN_ZONES(*,*,idx_good)

n_peace=n_elements(LEEA_SPIN_ZONES(0,0,*))
         nV=dblarr(n_PEACE)
         
FOR j=0,n_PEACE-1 do begin; looptime steps


    FOR i=0,12 DO BEGIN ;LOOP POLAR angle
       ;CALC useable section of energy spectrum wrt sc potential
       ;RELEVANT PEACE DATA ARRAY 
       idx_leea=where(LEEA_SPIN_ZONES(i,*,j) ne PEACE_nodata)
       idx_heea=where(HEEA_SPIN_ZONES(i,*,j) ne PEACE_nodata)
       min_leea=LEEA_E_TABLE_upper(idx_LEEA(0));index min good leea
       min_heea=HEEA_E_TABLE_upper(idx_HEEA(0));index min good heea
         ;  make index of valid data from leea range
       idx_leea_range=where(LEEA_E_TABLE_upper(idx_leea) lt HEEA_E_TABLE_lower(idx_HEEA(0)))
         ;make new energy table of combined LEEA and HEEA energy tables
       new_energy_table=[[LEEA_E_TABLE_lower(idx_leea_range),HEEA_E_TABLE_lower(idx_HEEA)],$
       [LEEA_E_TABLE_upper(idx_leea_range),HEEA_E_TABLE_upper(idx_HEEA)]]
       peace_1=LEEA_SPIN_ZONES(i,(idx_leea(idx_leea_range)),j)
       peace_2=HEEA_SPIN_ZONES(i,(idx_heea),j)
       new_PEACE=[peace_1(*),peace_2(*)]
       ;------------------correct with respect to SC potential
       sc_potential=interp_efw_pot(j)
       idx_sc_potential=where(new_energy_table(*,0) gt sc_potential)
       pot_corr_energy_table=new_energy_table(idx_sc_potential,*)-sc_potential
       veloc=sqrt((2*pot_corr_energy_table*e_charge/e_mass));m/s
       new_peace=new_peace(idx_sc_potential)
       n_energy=n_elements(new_peace)
       M=dblarr(N_ENERGY)
       BIGTHETA=((sin(angle_table(1,i))^2)-(sin(angle_table(0,i))^2))/2
       ;------------- do energies    
       FOR k=0,N_ENERGY-1 DO BEGIN ;loop energy (=velocity)
         BIGV=((veloc(k,1)^4)-(veloc(k,0)^4))/4
         M(k)=new_PEACE(k)*BIGV*BIGTHETA*BIGF
       ENDFOR
     sum_polar(i)=total(M)
    ENDFOR

  nv(j)=total(sum_polar)

ENDFOR
nvq=nv*e_charge
EPOCH={dat:PEACE_EPOCH}
sclmin=min(nvq)
sclmax=max(nvq)
control.cdfvar_name='j_para_approx'
data={dat:nvq,FILLVAL:PEACE_nodata,LABLAXIS:'AMPS',UNITS:'amps',SCALEMIN:sclmin,SCALEMAX:sclmax}
input_data={EPOCH:EPOCH,j_para_approx:data}
control.data_src=orig_data_src


;-------------------------------
 
  ENDIF


colors = [red, blue, dark_green]

smooth = control.smooth
var_names = tag_names(input_data)
;time is in CDF Epoch. Need to convert PAPCO start/end to that EPOCH.
pos = strpos(tag_names(input_data), 'EPOCH')
idx = where(pos NE -1)
epoch_time = input_data.(idx(0)).dat

;get data array
cdfvar_name = strupcase(control.cdfvar_name)

cdfvar_name_sh=strmid(cdfvar_name,0,4)
pos = strpos(tag_names(input_data),cdfvar_name_sh)
idx = where(pos NE -1)

data = input_data.(idx(0)).dat

;get dimension of data
data_info = size(data, /struct)

convert_t90_to_Date, mjdt_start, year,doy,hr,min,sec,mon,cmon,dom, /mjdt 
CDF_EPOCH, epoch_1, Year, mon, dom, hr, min, sec, /COMPUTE_EPOCH
convert_t90_to_Date, mjdt_end, year,doy,hr,min,sec,mon,cmon,dom, /mjdt 
CDF_EPOCH, epoch_2, Year, mon, dom, hr, min, sec, /COMPUTE_EPOCH

; restrict data in time  
index=where((epoch_time GE epoch_1) AND (epoch_time LE epoch_2 ),c)
if c ne 0 then BEGIN
    IF data_info.N_DIMENSIONS EQ 1 THEN data = data(index) ELSE $
      data = data(*, index) 
    epoch_time = epoch_time(index) 
ENDIF ELSE GOTO, noplot
xut1=0  &  xut2=epoch_2-epoch_1  & time=epoch_time-epoch_1

nodata = input_data.(idx(0)).FILLVAL
uytitle = input_data.(idx(0)).LABLAXIS+' ('+input_data.(idx(0)).UNITS+')'
ndat = n_elements(epoch_time)

 CASE strupcase(control.data_src) OF
 'HEEA_BETA':BEGIN
       message,  'Assembling HEEA BETA data...', /cont
       data=fltarr(ndat,1,4)
       pos = strpos(var_names, 'CL') & idx = where(pos NE -1, required_data)
        FOR j = 0, ndat-1 DO $
          FOR i=0, required_data-1 DO $
            data(j,*,i) = (input_data.(idx(i)).dat(j))
          t_pll=data(*,0,0)
          t_perp1=data(*,0,1)
          t_perp2=data(*,0,2)
          density=data(*,0,3)
          get_cluster_mag,control,mag_FGM,time,SC_ID=SC_ID
          mag_bt=mag_FGM(*,3)
          papco_CLUSTER_BETA_CALC,t_pll,t_perp1,t_perp2,density,mag_bt,P_BETA
          utitle=control.data_src+'!C'+' PEACE'+'!C'+'CLUSTER '+string(sc_id+1) 
          uytitle='PLASMA BETA'
          ymat=P_BETA
          data=P_BETA
        IF smooth GE 2 THEN BEGIN
            zmat = smooth(ymat, smooth) 
            sm_str = '!CSmooth: '+varprt(smooth)
        ENDIF ELSE BEGIN
            zmat = ymat
            sm_str = ''
        ENDELSE 
           yst = plotinfo.ZSCALEMIN & yen=plotinfo.ZSCALEMAX
           uztit=''
    END

  'LEEA_BETA':BEGIN
       message,  'Assembling LEEA BETA data...', /cont
       data=fltarr(ndat,1,4)
        pos = strpos(var_names, 'CL') & idx = where(pos NE -1, required_data)
        FOR j = 0, ndat-1 DO $
          FOR i=0, required_data-1 DO $
            data(j,*,i) = (input_data.(idx(i)).dat(j))
            t_pll=data(*,0,0)
            t_perp1=data(*,0,1)
            t_perp2=data(*,0,2)
            density=data(*,0,3)
            get_cluster_mag,control,mag_FGM,time,SC_ID=SC_ID
            mag_bt=mag_FGM(*,3)
            papco_CLUSTER_BETA_CALC,t_pll,t_perp1,t_perp2,density,mag_bt,P_BETA
            utitle=control.data_src+'!C'+' PEACE'+'!C'+'CLUSTER '+string(sc_id+1)
            uytitle='PLASMA BETA'
            ymat=P_BETA
            data=P_BETA
        IF smooth GE 2 THEN BEGIN
            zmat = smooth(ymat, smooth) 
            sm_str = '!CSmooth: '+varprt(smooth)
        ENDIF ELSE BEGIN
            zmat = ymat
            sm_str = ''
        ENDELSE 
            yst = plotinfo.ZSCALEMIN & yen=plotinfo.ZSCALEMAX
            uztit=''
    END
    else: begin

            utitle = 'papco cdf!C'+'!C'+cdfvar_name
            yst = input_data.(idx(0)).SCALEMIN(0)
            yen = input_data.(idx(0)).SCALEMAX(0)

           ;data=data/1000000.0
           ;uytitle='#/cm^3'
    ;*****************************************************************
end
endcase

;set y min max using data values
plotinfo.YSCALEMIN=min(data)
plotinfo.YSCALEMAX=max(data)

yst=min(data)
yen=max(data)
if plotinfo.yscalemin eq 0 then yscl(panel(0),3)=0; plotinfo.ylinlog = 0



;******************************************************************

; the variables used above have the following meaning:
; 	uytitle : the y-axis label
;	utitle  : the right-of plot label defining the data
;
; yscl of common block yscale is an array of dimensions (*,4) and contains info
; on the yscaling to be used. The first dimension identifies the panel, and the
; next dimension has three entries:  
;         yscl(*,0)  is  0 for "use automatic scaling", 1 for "use manual"
;         yscl(*,1)  is then ymin (or zmin)
;         yscl(*,2)  is then ymax (or zmax)
;         yscl(*,3)  is 0 for "linear" and 1 for "log"  scale
; when scaling is set to automatic, the automatic y-limits are loaded in.  

if (yscl(panel(0),0) eq 1) then begin
    yst=yscl(panel(0),1)  &  yen=yscl(panel(0),2)
endif else begin
    yscl(panel(0),1) = yst & yscl(panel(0),2) = yen
endelse
  
; use auto y-labeling routine to get "good" y-lables. This sets the
; global IDL graphics system variables !Y.MINOR, !Y.TICKV, !Y.TICKS -
; so if you want to use this feature, avoid setting these or their
; corresponding keywords in your plot.

papco_y_label, yst, yen, log=yscl(panel(0),3)

extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen],  $
               ylog:yscl(panel(0),3), xtickformat:'noticks'}
   
; add keyword structure set here with the one passed in
extra_plotPar=create_struct(extra_plotPar, extra_par)
   
; use papco routine to draw time axis. This checks for bottom plot
; and uses the user's xtickformat if it is something other than
; 'noticks'.
; If you use this rotuine, make sure your data plot routine uses
; xstyle=5 and ystyle=5 (inhibit axis) so that you don't clobber the
; axes drawn by papco.  
; "down" sets the axis labeling level. 
down=0
papco_draw_time_axis, panel, OVERPLOT=OVERPLOT, _extra=extra_plotPar    
  
; You might have to add your own xtickformat for time axis
; labeling. If you stick to the papco convention of always having your plot 
; time array having consecutive seconds from midnight of the start day, then 
; you can use the pre-defined xtickformat functions defined in ticks.pro in
; papco_Lib/axis_label.
; You can at this point also define a custom ytickformat, or leave it out for
; IDL default plot behaviour.

; now do the actual data plot, data only, no axis
;case of single line plot
IF data_info.N_DIMENSIONS EQ 1 THEN BEGIN

    papco_gap_plot, time, data, nodata, $
              xstyle=5, ystyle=5, _extra=extra_plotPar

ENDIF ELSE BEGIN     
stop
    coords = plotinfo.ioptions(1) & set = bytarr(3)
    FOR i = 0, 2 DO IF (coords and 2ll^i) eq 2ll^i THEN set(i)=1 else set(i)=0
    idx2 = where(set EQ 1, n_ch) 
    IF n_ch EQ 0 THEN GOTO, noplot
    in_label = input_data.(idx(0)).LABL_PTR_1(idx2)
    for i = 0, n_ch-1 DO BEGIN
        yray = data(idx2(i), *)
        IF n_ch NE 1 then extra_plotPar.color = colors(i)
        papco_gap_plot, time, yray, nodata, $
              xstyle=5, ystyle=5, _extra=extra_plotPar
    ENDFOR 
    ; plot channel info inside of panel.
    papco_in_side_label, panel, in_label, NCOL = colors, _extra=extra_plotPar
 
ENDELSE

; plot y-axis label at left of plot. Use scalable routine!  

;left_side_label, panel, uytitle,/rot90

; store the coordinate information into common block for slices
plotted_x = !x  &  plotted_y = !y

; plot info right of the panel. If you want overplots to have their own labels
; you need to add position-control for this label using the keyword
; PLOTS_ATTHISPOSITION

if not keyword_set(overplot) then begin
    right_side_label,panel,utitle,_extra=extra_Par
endif else begin
    for i=0, PLOTS_ATTHISPOSITION-1 do utitle='!C'+utitle
    right_side_label,panel,utitle,_extra=extra_Par
endelse
   
; check if data needs to be output to file. Use the optional keywords
; to add more information to the data file
;      DESCRIPTION   a string or string array describing the data
;      TIME_LABEL    a string decribing the x-axis format
;      CHANNELS      an (ch,2) array giving the channel start/end
;      Y_LABEL       a string with the y-axis label
;      Z_LABEL       a string with the z-axis label
;      RS_LABEL      a string with the righ-side label of the plot

control=old_control
*plotinfo.USR_PTR1=control

  if KEYWORD_SET(OUTPUT) then begin
    print,'% p_cluster_peace_line: Writing plot data out to file'
    description='cluster_peace template sample data - single energy channel line'
    time_label='Seconds since start of day'
    ;channels=yarr
    y_label=uytitle
    ;z_label=uztit
    rs_label=utitle
    papco_write_data, time, yray, $
                      DESCRIPTION=description, TIME_LABEL=time_label, $
                      Y_LABEL=y_label, $
                      RS_LABEL=RS_LABEL
  endif  

return
stop
noplot: 
message,'No data to plot',/cont
plotted_x = !x  &  plotted_y = !y  

end 
