;**********************************************************;
;*PROCEDURE:
;*        PRO papco_CLUSTER_BETA_CALC
;*
;*DESCRIPTION:
;*        routine to calculate beta given Temp parallel, and 2 perp
;*        components + density.
;*INPUTS
;*        Tparallel +2 perp components in Kelvin,density in #/m^3
;*        and magnetic magnitude in  nT
;*OUTPUTS plasma beta values
;*
;**********************************************************

pro papco_CLUSTER_BETA_CALC,t_pll,t_perp1,t_perp2,density,B_MAG,P_BETA

pi=3.1416;pi value
k=1.38*1e-23;Boltzmann constant
mu=4*pi*1e-7;permeability of vacuum
size_data=n_elements(t_pll)

;MAKE TEMPERATURE TENSOR
temperature_tensor=fltarr(3,3,size_data)
temperature_tensor(0,0,*)=t_perp1
temperature_tensor(1,1,*)=t_perp2
temperature_tensor(2,2,*)=t_pll
stop
;CALCULATE SCALAR TEMP
B_MAG=B_MAG*1e-9
SCALAR_TEMP=fltarr(size_data)
 for i=0,size_data-1 do  SCALAR_TEMP(i)=(TRACE(temperature_tensor(*,*,i)))/3.0

;CALCULATE SCALAR PRESSURE

SCALAR_PRESSURE=2*density*SCALAR_TEMP*k
P_BETA=(2*mu*SCALAR_PRESSURE)/((B_MAG^2))
end
