;******************************************************************************
;*  NAME:        r_cluster_peace
;*
;*  DESCRIPTION: Routine to read cluster_peace files. Adheres to
;*               papco conventions: Error common block
;*                                  Uses MJDT time
;*                                  papco read philosophy
;*
;*  INPUT:       none (uses common block time from papco)
;*
;*  OUTPUT:      none (places data into common blocks)
;*
;*  KEYWORDS:    VERBOSE  -  enables print comments, save/restore comments
;*
;*  DATE:        June 1996
;*
;*  AUTHOR:       R. Friedel
;*x
;******************************************************************************
pro r_cluster_peace, plotinfo, VERBOSE=VERBOSE

COMMON cluster_peace_data, input_data
COMMON mjdt, mjdt_start, mjdt_end
COMMON get_error, get_err_no, get_err_msg
common cluster_peace

get_err_no=0  &  get_err_msg='cluster_peace read succesfully'
   
; check env. variable pointing to data directory
if not (papco_check_data_env('CLUSTER_PEACE_DATA', PATH=path)) then return
   
; check VERBOSE keyword and set
if keyword_set(VERBOSE) then verbose=VERBOSE else verbose=0     

verbose = 1  
;retrieve the control structure for this module.
control = *plotinfo.USR_PTR1
control.data_src=strcompress(control.data_src,/remove_all)
*plotinfo.USR_PTR1=control

; clear data arrays for reuse
input_data=0    

;make list of files to be read for time period

file = control.cdf_file
cdf_type = strcompress(control.data_src,/remove_all)

sat_id = 'C'+varprt(control.sc_id+1)
papco_sepdir, file, path, fln, ext
;get position of date string in file
test = byte(fln) ; make ASCII codes of file string. '0'->'9' = 48->57
idx = where((test GE 48) AND (test LE 57))
test(*) = 0 & test(idx) = 1
FOR i = 0, n_elements(test)-2 DO IF test(i+1) GT 0 THEN $
  test(i+1) = test(i+1)+test(i)
idx = where(test EQ 8) & p = idx(0)-7
;get position of year string in path
test = byte(path) ; make ASCII codes of file string. '0'->'9' = 48->57
idx = where((test GE 48) AND (test LE 57), cp)

IF cp NE 0 THEN begin
    test(*) = 0 & test(idx) = 1
    FOR i = 0, n_elements(test)-2 DO IF test(i+1) GT 0 THEN $
      test(i+1) = test(i+1)+test(i)
    idx = where(test EQ 4) & py = idx(0)-3
ENDIF 
    peace_units= control.cdf_type
    

   CASE peace_units of
  
   0:Begin
    peace_units_str='CNTS'
     end
   1:Begin
    peace_units_str='DNF'
     end
   2:Begin
    peace_units_str='DEF'
   end
   3:Begin
    peace_units_str='s3m6'
   end
   endcase

control.peace_unts=peace_units_str

if control.cdf_dir le 1 then fln=fln+'_'+peace_units_str;at units strto file name for SPINPAD data
;-----------------------------------------------------------------


reread_PEACE:
files = strarr(mjdt_end.mjd-mjdt_start.mjd+1)
time = mjdt_start

;peace cdf's have yyyyddd
FOR i = mjdt_start.mjd, mjdt_end.mjd DO BEGIN
    time.mjd = i & time.t = 0
    if (mjdt_end.mjd eq time.mjd) AND (mjdt_end.t eq 0) THEN break
    convert_t90_to_date, time, year, day_oy, hour, minute, second,$
                         month, cmonth, day_om, /mjdt
    date = string(year,day_oy, format='(i4.4,i3.3)')
    year = string(year, format='(i4.4)')

    ;substitute year in path, filename if needed
    this_path = path
    IF cp NE 0 THEN strput, this_path, year, py

 this_file = fln
    strput, this_file, date, p
    this_file = strmid(this_file, 0, p+7)
if control.cdf_dir le 1 then  res = findfile(this_path+this_file+'*'+peace_units_str+'.cdf', count = n)
if control.cdf_dir gt 1 then  res = findfile(this_path+this_file+'*'+'.cdf', count = n)

    IF n NE 0 THEN this_file = res(0) ELSE this_file = ''
    files(i-mjdt_start.mjd) = this_file

    print, files(i-mjdt_start.mjd)
ENDFOR

print,files
;test for file exist, remove from list if not exist
FOR i = 0, n_elements(files) -1 DO BEGIN
    res = findfile(files(i), count = n) 
    IF n EQ 0 THEN files(i) = ''
ENDFOR

idx = where(files NE '', n)
IF n EQ 0 THEN BEGIN
    msg = 'No '+cdf_type+' cdf files found for timeperiod'
    message, msg, /cont
    get_err_no = 1 & get_err_msg = msg
;    return
message, '!!!!!!!!!!! Try to create cdf from SDDAS exportIDFS !!!!!!!!!!!', /cont
ENDIF


;put cdf read in here
;****************************************************************************************
;* using SDDAS exportIDFS command to export PEACE cdf's
;* exportIDFS expects following format, where exportfile is a .exp
;file created by Matt TAylor in SDDAS, which sets up particular PEACE
;data products for export. Here we only have a 13 zone DNF export for
;HEEA and LEEA. exportfile below should be layout filename without
;extension.
;* -BTime and -ETime are beginning and end times respectively,
;!!!!!!!!!!!!!!!!!!have set time to read entire day!!!
;* time format YYY/DDD:HH:MM:SS.msc
;* exportIDFS -FName <exportfile> -Btime <starttime>  -Etime <endtime>
;* 
;****************************************************************************************
IF n EQ 0 THEN Begin
SDDAS_ST_TIME = string(year,day_oy, format='(i4.4,i4.4)') 
SDDAS_CHK_TIME = string(year,day_oy, format='(i4.4,i3.3)') 
strput, SDDAS_ST_TIME, '/', 4
SDDAS_END_TIME = SDDAS_ST_TIME+':23:59:59:9999'
SDDAS_ST_TIME = SDDAS_ST_TIME+':00:00:00:0000'


papco_sddas_exp_path ='/n/radbelt/dlnk/cluster/peace/SDDAS_output/EXPORT_UTIL/'


 if control.cdf_dir le 1 then begin
  sddas_exp_file=cdf_type
  CASE peace_units of 

    0:begin;  peace units= cnts
  papco_sddas_exp_path=papco_sddas_exp_path+'cnts/'
      end
    1:begin;  peace units= diff number flux
  papco_sddas_exp_path=papco_sddas_exp_path+'dnf/'
      end
    2:begin;   peace units= diff energy flux
  papco_sddas_exp_path=papco_sddas_exp_path+'def/'
     end
    3:begin; peace units = s3m6
  papco_sddas_exp_path=papco_sddas_exp_path+'s3m6/'
      end
    else:begin

      end
   ENDCASE
  endif else begin
     papco_sddas_exp_path=papco_sddas_exp_path+'BETA_CALC/'
  if cdf_type eq 'HEEA_BETA' then sddas_exp_file='H1H2'
  if cdf_type eq 'LEEA_BETA' then sddas_exp_file='L1L2'
 endelse

exp_filename = papco_sddas_exp_path+sddas_exp_file+'_'+sat_id
print,exp_filename
print,  SDDAS_ST_TIME, SDDAS_END_TIME

spawn, 'unset noclobber'

spawn, papco_sddas_exp_path+'exportIDFS -FName '+exp_filename+' -BTime '+SDDAS_ST_TIME+' -ETime '+SDDAS_END_TIME
spawn,'pwd'
spawn, 'set noclobber'


;build check string

IF cdf_type EQ 'full_HEEA' THEN begin
check_string = 'CLUSTER-'+strmid(sat_id,1)+'_HSPAD_'+SDDAS_CHK_TIME+'000000_V1.cdf'
new_cdf_name=  'CLUSTER-'+strmid(sat_id,1)+'_HSPAD_'+SDDAS_CHK_TIME+'000000_V1_'+peace_units_str+'.cdf'
ENDIF
IF cdf_type EQ 'full_LEEA' THEN begin
check_string = 'CLUSTER-'+strmid(sat_id,1)+'_LSPAD_'+SDDAS_CHK_TIME+'000000_V1.cdf' 
new_cdf_name=  'CLUSTER-'+strmid(sat_id,1)+'_LSPAD_'+SDDAS_CHK_TIME+'000000_V1_'+peace_units_str+'.cdf'
ENDIF
IF cdf_type EQ 'HEEA_BETA' THEN begin
check_string = 'CLUSTER-'+strmid(sat_id,1)+'_H1H2_'+SDDAS_CHK_TIME+'000000_V1.cdf'
new_cdf_name=check_string
ENDIF
IF cdf_type EQ 'LEEA_BETA' THEN begin
check_string = 'CLUSTER-'+strmid(sat_id,1)+'_L1L2_'+SDDAS_CHK_TIME+'000000_V1.cdf' 
new_cdf_name=check_string
ENDIF


;*************redo file check below,which isnt finding H1H2  cdfs

check_string = check_string
check_existence = findfile(check_string, count = cnt)

  IF cnt EQ 0 THEN begin
  msg = 'No '+cdf_type+' cdf files exist/available from PEACE DATABASE'
  message, msg, /cont
  return
  ENDIF

  if cnt ne 0 then begin

    if cdf_type eq 'full_HEEA' then begin
     spawn, 'unset noclobber'
     spawn, 'mv '+check_string+ ' /n/radbelt/dlnk/cluster/peace/SDDAS_output/full_HEEA/'+new_cdf_name 
     spawn, 'set noclobber'
    endif
    if cdf_type eq 'full_LEEA' then begin
     spawn, 'unset noclobber'
     spawn, 'mv '+check_string+ ' /n/radbelt/dlnk/cluster/peace/SDDAS_output/full_LEEA/'+new_cdf_name
     spawn, 'set noclobber'
    endif  
   
    if cdf_type eq 'HEEA_BETA' then begin
     spawn, 'unset noclobber'
     spawn, 'mv '+check_string+ ' /n/radbelt/dlnk/cluster/peace/SDDAS_output/HEEA_BETA/'+new_cdf_name 
     spawn, 'set noclobber'
    endif
    if cdf_type eq 'LEEA_BETA' then begin
     spawn, 'unset noclobber'
     spawn, 'mv '+check_string+ ' /n/radbelt/dlnk/cluster/peace/SDDAS_output/LEEA_BETA/'+new_cdf_name
     spawn, 'set noclobber'
    endif  


;******************************
files = strarr(mjdt_end.mjd-mjdt_start.mjd+1)
time = mjdt_start

;peace cdf's have yyyyddd
FOR i = mjdt_start.mjd, mjdt_end.mjd DO BEGIN
    time.mjd = i & time.t = 0
    if (mjdt_end.mjd eq time.mjd) AND (mjdt_end.t eq 0) THEN break
    convert_t90_to_date, time, year, day_oy, hour, minute, second,$
                         month, cmonth, day_om, /mjdt
    date = string(year,day_oy, format='(i4.4,i3.3)')
    year = string(year, format='(i4.4)')
    ;substitute year in path, filename if needed
    this_path = path
    IF cp NE 0 THEN strput, this_path, year, py
    this_file = fln
    strput, this_file, date, p
    this_file = strmid(this_file, 0, p+7)

 res = findfile(this_path+this_file+'*'+peace_units_str+'.cdf', count = n)


    IF n NE 0 THEN this_file = res(0) ELSE this_file = ''
    files(i-mjdt_start.mjd) = this_file

    print, files(i-mjdt_start.mjd)
ENDFOR

print,files


;test for file exist, remove from list if not exist
FOR i = 0, n_elements(files) -1 DO BEGIN
    res = findfile(files(i), count = n) 
    IF n EQ 0 THEN files(i) = ''
ENDFOR

idx = where(files NE '', n)
IF n EQ 0 THEN BEGIN
    msg = 'No '+cdf_type+' cdf files found for timeperiod'
    message, msg, /cont
    get_err_no = 1 & get_err_msg = msg
;    return
message, '!!!!!!!!!!! SDDAS export failed', /cont
ENDIF


;******************************


 endif


ENDIF

files = files(idx)
FOR i = 0, n-1 DO BEGIN

    r_cluster_peace_onefile, files(i), plotinfo, VERBOSE=VERBOSE
                                ;need to "concatonate" the data. Not
                                ;easy, so don't read over fiel
                                ;boundaries yet!

ENDFOR

END 

;******************************************************************************
;*  NAME:        r_plot_type_onefile, fln, plotinfo
;*
;*  DESCRIPTION: reads one file of type plot_file. Assumes data has been
;*               stored in IDL saveset using structures input_header and
;*               input_data
;*
;*  INPUT:       fln  - string of filename
;*
;*  OUTPUT:      none (places data into common blocks)
;*
;*  DATE:        October 2002
;*
;*  AUTOR:       R. Friedel
;******************************************************************************
PRO r_cluster_peace_onefile, fln, plotinfo, VERBOSE=VERBOSE
  
COMMON cluster_peace_data, input_data
COMMON get_error, get_err_no, get_err_msg

;idl savset path   
get_err_no=0  &  get_err_msg='cluster_peace onefile read succesfully'
   
if not (papco_check_data_env('CLUSTER_PEACE_SAVESETS', PATH=path)) then return

; clear data arrays for reuse
input_data=0    
papco_sepdir, fln, dir, file, ext
save_file = path+file+'.idl'

on_ioerror, read_original
restore,save_file, VERBOSE=VERBOSE
dealloc_lun,/quiet   ;frees logical units used by save/restore
message,'read '+save_file, /cont
return

read_original:       ;if the .idl file is not found, try to read the original
r_cluster_peace_onefile_original, fln, plotinfo, VERBOSE=VERBOSE
  
END   


;******************************************************************************
;*  NAME:        r_plot_type_onefile_original, fln, plotinfo
;*
;*  DESCRIPTION: reads one file of cluster peace original - cdf file
;                from SDDAS. Saves data in idl saveset.
;*
;*  INPUT:       fln  - string of filename
;*
;*  OUTPUT:      none (places data into common blocks)
;*
;*  DATE:        October 2002
;*
;*  AUTOR:       R. Friedel
;******************************************************************************
PRO r_cluster_peace_onefile_original, fln, plotinfo, VERBOSE=VERBOSE
  
COMMON cluster_peace_data, input_data
COMMON get_error, get_err_no, get_err_msg


;retrieve the control structure for this module.
control = *plotinfo.USR_PTR1
get_err_no=0  &  get_err_msg='cluster_peace onefile read succesfully'
   
; check env. variable pointing to data directory
if not (papco_check_data_env('CLUSTER_PEACE_SAVESETS', PATH=sav_path)) $
  then return
if not (papco_check_data_env('CLUSTER_PEACE_DATA', PATH=path)) then return

sat_id =varprt(control.sc_id+1)

control.data_src=strcompress(control.data_src,/remove_all)
*plotinfo.USR_PTR1=control
cdf_type = control.data_src

;now make list of variables to read, depending on data choices!
CASE cdf_type OF
    'full_HEEA':BEGIN

        ;here read all PA data or all quality data
        cdfvar_name = control.cdfvar_name
        pos = strpos(cdfvar_name, 'HEEA PA')

        IF pos NE -1 THEN BEGIN ;make list of PA variables
            cdf_var_list = strarr(13)
            FOR i = 0, 12 DO cdf_var_list(i) = varprt(i+1)+'_C'+sat_id+$
              ' HEEA PA '+varprt(i*15)+'deg'
        ENDIF ELSE BEGIN
            msg = 'cdf variable '+cdfvar_name+' not supported yet'
            message,  msg, /cont
            get_err_no = 1  &  get_err_msg = msg
            return
        ENDELSE 

    END     
    'full_LEEA':BEGIN
        cdfvar_name = control.cdfvar_name
        pos = strpos(cdfvar_name, 'LEEA PA')
        IF pos NE -1 THEN BEGIN ;make list of PA variables
            cdf_var_list = strarr(13)
            FOR i = 0, 12 DO cdf_var_list(i) = varprt(i+1)+'_C'+sat_id+$
              ' LEEA PA '+varprt(i*15)+'deg'
        ENDIF ELSE BEGIN
            msg = 'cdf variable '+cdfvar_name+' not supported yet'
            message,  msg, /cont
            get_err_no = 1  &  get_err_msg = msg
            return
        ENDELSE 
    END     

    'HEEA_BETA':BEGIN
        cdf_var_list=['1_CL-'+sat_id+' T para','2_CL-'+sat_id+' T perp x','3_CL-'+sat_id+' T perp y','4_CL-'+sat_id+' Density']
    END

    'LEEA_BETA':BEGIN
      cdf_var_list=['1_CL-'+sat_id+' T para','2_CL-'+sat_id+' T perp x','3_CL-'+sat_id+' T perp y','4_CL-'+sat_id+' Density']
  END   
     'TOP_MOM':BEGIN
      cdf_var_list=['1_TOP TotCnts','2_TOP Density','3_TOP N<Vx>','4_TOP N<Vy>','5_TOP N<Vz>','6_TOP N<Pxx>','7_TOP N<Pyy>','8_TOP N<Pzz>','9_TOP N<Pxy>','10_TOP N<Pxz>','11_TOP N<Pyz>']

     END
     'HEEA_OLAP_MOM':BEGIN
     cdf_var_list=['1_HEEA TotCnts','2_HEEA Density','3_HEEA N<Vx>','4_HEEA N<Vy>','5_HEEA N<Vz>','6_HEEA N<Pxx>','7_HEEA N<Pyy>','8_HEEA N<Pzz>','9_HEEA N<Pxy>','10_HEEA N<Pxz>','11_HEEA N<Pyz>']
     
      END

    ELSE:BEGIN
        msg = 'cdf type '+cdf_type+' not supported yet'
        message,  msg, /cont
        get_err_no = 2  &  get_err_msg = msg
        return
    END 
ENDCASE

;also need to read variable containing channel info
cdf_channel_info = ['Center_Scan', 'Band_Low_Scan', 'Band_High_Scan']



;use CDAWLIB routine to read all the data from the cdf file!
cdfvar_names = [cdf_channel_info, cdf_var_list]
if control.cdf_dir gt 1 then cdfvar_names=[cdf_var_list]
cdf_var_struct = read_mycdf(cdfvar_names, fln)
input_data = temporary(cdf_var_struct)
;now store data in idl saveset, compressed
papco_sepdir, fln(0), dir, file, ext
save_file = sav_path+file+'.idl'

save, filename=save_file, input_data, /COMPRESS, VERBOSE=VERBOSE

END
