;******************************************************************************
;* FUNCTION:     
;*      FUNCTION  cluster_peace_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;* 
;* DESCRIPTION:  
;*	Open an editor widget for a panel, using the methods defined in the 
;*	file $papco_XX/}}papco_panel.pro .
;*	When the user presses the 'Done'- or the 'Cancel'-Button, the values 
;*	changed by the event-methods of papco_panel.pro are returned.
;*	The returned value is a structure containing those values and a flag,
;*	'canceled', which the caller may read out to check, whether the 
;*	window was closed using the 'Cancel' or the 'Done'-Button.
;*
;* INPUTS:       
;*      aPlotInfo       a structure of the papco_plotinfo-type
;*                      this structure is edited in the panel editor window.
;* KEYWORDS:
;*      GROUP           a WIDGET_BASE
;*	                when specified, this is used as GROUP_LEADER
;*      ACTION          a string
;*	                when specified, the 'Done'-Button is labeled with it
;*		        if not specified, the 'Done'-Button is labeled 'Done'
;*
;* OUTPUT:	 
;*      a default-structure of type papco_panel_editor_return. Though this
;*      type is nowhere defined, it is a virtually existing data-type. 
;*      All the functions in $papco_XX/papco.pro that edit plots or add new
;*      ones, expect the opened editor-windows to return a structure containing
;*      at least some fields. Typically this structure contains fields
;*      used by the papco_panel widgets, and some fields "inherited"
;*      from aplotinfo but modified by the user.
;*
;* CALLING SEQUENCE:
;*      newPlotData=papco_PANEL_TEMPLATE(plotInfo, ACTION=, GROUP=)
;******************************************************************************
FUNCTION  cluster_peace_panel, PlotInfo, GROUP=group, ACTION=ACTION

COMMON cluster_peace_panel_data, widgetData
;COMMON cluster_peace2, svnames, file, dirs
COMMON cluster_peace ;see cluster_peace_commons.pro for contents

;--- if GROUP is not specified, the group-leader will be the desktop
IF NOT KEYWORD_SET(GROUP) THEN GROUP=0
;--- set the label for the action-button
IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

;--- the routines used by papco_panel.pro define tags for a structure. Those
;    tags will be stored in the structure 'additionalWData'. When you realize 
;    the window, you have to add your own window-specific data to that  
;    structure and afterwards assign it to widgetData.
additionalWData={canceled:1}



;***NEW PAPCO 10.5*** 
;All the user's widget info is now stored in a structure,
;and the only thing stored in the plotinfostruct is the pointer to
;that structure. This allows unlimited freedom in variables for the
;module. The structure papco_cdf_control is defined in papco_cdf_commons.pro

;test if the plotinfo pointer tag points to an 'INT' (means not
;assigned to a structure). If so, load in the control structure.
r = size(*plotinfo.USR_PTR1, /ST)
IF r.TYPE_NAME EQ 'INT' THEN plotinfo.USR_PTR1 = ptr_new(cluster_peace_control)
control = *plotinfo.USR_PTR1
;control now contains the user defiend control structure for this module.



;--- create the base-window ---------------------------------------------------
;    since this can be a large widget, make a left and right side.
title = PlotInfo.panelKind + ', ' + papco_module_version('cluster_peace')
panel_base=papco_WIDGET_BASE(title=title, row=1, $
                               GROUP_LEADER=group, /MODAL)
panel_left=widget_base(panel_base,column=1)
panel_right=widget_base(panel_base,column=1)

;--- All papco_panel_add routines are papco panel widgets that can be included
;    in the panel editor or not. They provide functionality that papco 
;    supports. They dynamically extend the panel editors widget structure, and
;    all the events they generate are supported by papco_panel_event, 
;    transparent to the user. 

;--- the first part of the window will consist of the widget that -------------
;    controls the height of that panel. This is needed for all panel editors.
widgets=papco_panel_AddHeightWidgets(panel_left, PlotInfo)
additionalWData=create_struct(widgets, additionalWData)
 
;
;---  <<<<<<<<<<  insert your widgets below here!  >>>>>>>>>
;

;--- list choices of PEACE data ----------------------------------------------
peace_cdfdir = ['full HEEA', 'full LEEA','HEEA_BETA', 'LEEA_BETA','TOP_MOM','HEEA_OLAP_MOM']
cdfdir_base = CW_BGROUP(panel_left,peace_cdfdir,COLUMN=4, /EXCLUSIVE, /FRAME, $
                        UVALUE='spb_cdfdir', $
                        LABEL_LEFT = 'Data Product:', $
                        SET_VALUE=control.cdf_type ) 
;----choose units-----------------------------------------------------------
peace_units = ['cnts', 'DNF', 'DEF']
units_base = CW_BGROUP(panel_left,peace_units,COLUMN=4, /EXCLUSIVE, /FRAME, $
                    UVALUE='spb_units',$
                    LABEL_LEFT='Data Units:',$
                    SET_VALUE=control.units )

;--- reload options -----------------------------------------------------------
data_behavior=widget_base(panel_left, ROW=1)  
reload_names=['Reload', 'Adopt']
reload_base=CW_BGROUP(data_behavior, reload_names, /FRAME, ROW=1, /EXCLUSIVE, $
                      LABEL_LEFT='Data Input :', UVALUE='spb_reload', $
                      SET_VALUE=control.reload)

;--- depending on what is cdf directory is chosen, display the variables ------
cdfvar_lbl = WIDGET_LABEL(panel_left, $
                          VALUE = 'Variable name - variable type - decription')
cdfvar_list = WIDGET_LIST(panel_left, $
                          ysize = 40, xsize = 88, UVALUE = 'll_cdfvar', $
                          value = strarr(30))
widget_control, cdfvar_list, set_list_select = control.var_list

;--- allow choices for spacecraft ---------------------------------------------
data_type_base = WIDGET_BASE(panel_left, /FRAME, COLUMN = 1)
sc_id_base=CW_BGROUP(data_type_base, sc_names, COLUMN=4, /EXCLUSIVE, $
                     UVALUE='spb_sc_id', LABEL_LEFT = 'Spacecraft   :', $
                     SET_VALUE=control.sc_id ) 

;--- Data type choice --------------------------------------------------------
data_base = CW_BGROUP(data_type_base, data_names, COLUMN = 2, /EXCLUSIVE, $
                      LABEL_LEFT='Type of Data :', $
                      UVALUE='spb_data', $
                      SET_VALUE=control.pl_type)

;--- add choices for plot types -----------------------------------------------
choices_base = WIDGET_BASE(data_type_base, ROW = 1)
plot_names = ['Spectrum',  'Line']
plot_base = papco_CW_BGROUP(choices_base, plot_names, $ 
                        ROW=1, /EXCLUSIVE, $
                        LABEL_LEFT='Plot type    :', BUTTON_IDS = plot_ids, $
                        UVALUE='spb_plot', $
                        SET_VALUE=control.pl_style) 
;--- smoothing of data --------------------------------------------------------
smooth_base=CW_FIELD(choices_base, ROW=1, /INTEGER, /RETURN_EVENTS, $
                     TITLE = 'Smooth :', XSIZE = 3, $
                     UVALUE= 'ef_smooth', VALUE=control.smooth)

;--- select for pitch - energy, pitch angle ----------------------------------
pitch_base = WIDGET_BASE(panel_left, ROW = 1, /base_align_center, /FRAME)

pa_base = WIDGET_BASE(pitch_base, COLUMN = 1)
pa_label = WIDGET_LABEL(pa_base, /Align_center, XSIZE=150, VALUE = '-')
sl_pa =WIDGET_SLIDER(pa_base, XSIZE=200, /SUPPRESS_VALUE, $
		       /DRAG, TITLE='pitch angle bin 1', $
		       VALUE=control.pa_bin1 < 13 > 1, $
                       UVALUE='sl_pa', MINIMUM=1, MAXIMUM=13)

ek_base = WIDGET_BASE(pitch_base, COLUMN = 1)
ek_label = WIDGET_LABEL(ek_base, /Align_center, XSIZE=200, VALUE = '-')
sl_ek =WIDGET_SLIDER(ek_base, XSIZE=340, /SUPPRESS_VALUE, $
		       /DRAG, TITLE='energy channel 1', $
		       VALUE=control.EK_CH1 < 93 > 1, $
                       UVALUE='sl_ek', MINIMUM=1, MAXIMUM=93)

pitch_base2 = WIDGET_BASE(panel_left, ROW = 1, /base_align_center, /FRAME)

pa_base2 = WIDGET_BASE(pitch_base2, COLUMN = 1)
pa_label2 = WIDGET_LABEL(pa_base2, /Align_center, XSIZE=150, VALUE = '-')
sl_pa2 =WIDGET_SLIDER(pa_base2, XSIZE=200, /SUPPRESS_VALUE, $
		       /DRAG, TITLE='pitch angle bin 2', $
		       VALUE=control.pa_bin2 < 13 > 1, $
                       UVALUE='sl_pa2', MINIMUM=1, MAXIMUM=13)

ek_base2 = WIDGET_BASE(pitch_base2, COLUMN = 1)
ek_label2 = WIDGET_LABEL(ek_base2, /Align_center, XSIZE=200, VALUE = '-')
sl_ek2 =WIDGET_SLIDER(ek_base2, XSIZE=340, /SUPPRESS_VALUE, $
		      /DRAG, TITLE='energy channel 2', $
		      VALUE=control.EK_CH2 < 93 > 1, $
                      UVALUE='sl_ek2', MINIMUM=1, MAXIMUM=93)
;
;---  <<<<<<<<<<  insert your widgets above here!  >>>>>>>>>
;

;--- some panels might need to read/input to text files (event, text ----------
;    module). So a generic papco widget is supplied for this. 
;widgets=papco_panel_AddFile_Widgets(panel_left, PlotInfo)
;additionalWData=create_struct(widgets, additionalWData)   
;--- add the papco panel widget for specifying own plot description label -----
widgets=papco_panel_AddDescr_Widgets(panel_right, PlotInfo, /VERTICAL)
additionalWData=create_struct(widgets, additionalWData)
;--- add the papco panel widget for choosing the color bar for color plots ----
widgets=papco_panel_Addcolorbar_Widgets(panel_left, PlotInfo)
additionalWData=create_struct(widgets, additionalWData)
;--- add the  papco panel widget for choosing the plot-style for line plots ---
widgets=papco_panel_add_PlotStyleButtons(panel_left, PlotInfo, 0)
additionalWData=create_struct(widgets, additionalWData)
;--- add the papco panel widget for choosing the y-axis-ranges ----------------
widgets=papco_panel_AddYScale_Widgets(panel_right, PlotInfo,/VERTICAL)
additionalWData=create_struct(widgets, additionalWData)
;--- add the papco panel widgets for choosing the z-axis-ranges ---------------
widgets=papco_panel_AddZScale_Widgets(panel_right, PlotInfo,/VERTICAL)
additionalWData=create_struct(widgets, additionalWData)
   
;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window. This is needed for all panel editors. If you want to 
;    make use of the configure feature, then add the keyword CONFIG
widgets=papco_panel_AddActionButtons(panel_right, Action, PlotInfo, $
                                     /CONFIG, /VERTICAL)
additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You always
;    need to specify the help-file, and your structure must contain the
;    'additionalWData'. You should create the helpfile in the papco_interface
;    directory of your module (template is in the cluster_peace example module)
;    Also add the ID's of your widgets so that you can perform widget_control
;    actions in the events routine or in a refresh routine if needed.
thisWidgetsData={helpfile:'cluster_peace_panel.help', $
                 base:panel_base, $
                 smooth_base:smooth_base, $
                 sl_pa:sl_pa, pa_label:pa_label, $
                 sl_ek:sl_ek, ek_label:ek_label, $
                 sl_pa2:sl_pa2, pa_label2:pa_label2, $
                 sl_ek2:sl_ek2, ek_label2:ek_label2, $
                 data_base:data_base, $
                 plot_base:plot_base, $
                 plot_ids:plot_ids, $
                 cdfvar_list:cdfvar_list, $
                 soptions:PlotInfo.soptions, $
                 units_base:units_base,$
                 ioptions:PlotInfo.ioptions, $
                 typevector:PlotInfo.typevector}

; add control struct, papco_panel structs
widgetData=papco_PANEL_CreateWidgetData(control, thisWidgetsData)
widgetData=papco_panel_CreateWidgetData(thisWidgetsData, additionalWData)

;--- realize the window -------------------------------------------------------
cluster_peace_refresh, /ALL
papco_Panel_Realize, panel_base, widgetData
papco_xmanager, 'cluster_peace_panel', panel_base


;now return data. Since all the widget's info in in a control structure,
;only load it's pointer into USR_PTR1 and return that.

;control is part of the widgetData structure. Extract it
struct_assign, widgetData, *plotinfo.USR_PTR1

;work out if there has been a change in the control structure
plotinfo.modified = plotinfo.modified + $
                    papco_compare_struct(control, *plotinfo.USR_PTR1)

returnData={USR_PTR1:plotinfo.USR_PTR1, $
            MODIFIED:plotinfo.modified }
additionalRData=papco_panel_ReturnData(widgetData)
return, create_struct(ReturnData, additionalRData)

return, create_struct(ReturnData, additionalRData)
   
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO cluster_peace_refresh
;* 
;* DESCRIPTION:  
;*      refresh rotuine for cluster_peace_panel, called by event handler
;*
;* INPUTS:       
;*      none
;*                  
;* KEYWORDS:
;*      
;* 
;* CALLING SEQUENCE:
;*      called by XMANAGER
;******************************************************************************
PRO cluster_peace_refresh, ALL = ALL, VARLIST = VARLIST, $
                           DATATYPE = DATATYPE, SLIDERS = SLIDERS

COMMON cluster_peace_panel_data, widgetData
COMMON cluster_peace2, svnames, file, dirs
COMMON cluster_peace

IF keyword_set(ALL) THEN BEGIN
    VARLIST = 1 & DATATYPE = 1 & SLIDERS = 1
ENDIF

IF keyword_set(VARLIST) THEN BEGIN
    r = papco_check_data_env('CLUSTER_PEACE_DATA', PATH=path)
    cdf_type = strsubst(peace_cdfdir(widgetData.typevector(0)), ' ', '_')
    cdf_dir = path+cdf_type
    widgetData.soptions(1) = cdf_type
    peace_units=cluster_peace_control.units
    
    mask = '*CLUSTER-'+varprt(widgetData.ioptions(0)+1)+'*'

 CASE peace_units of
  
   0:Begin
    mask_units='CNTS'
     end
   1:Begin
    mask_units='DNF'
     end
   2:Begin
    mask_units='DEF'
     end
   endcase

    ;pick a file to enquire. **Files could be in subdirs by year!**
    res = findfile(cdf_dir+'/'+mask+'.cdf', count = n)
stop
    IF n EQ 0 THEN BEGIN
        years = findfile(cdf_dir, count = n)
        IF n EQ 0 THEN BEGIN
            res = messagebox(['Cannot find any cdf files'], ['cancel'])
            file = ''
            svnames = ''
        ENDIF
        n = 0
        FOR i = 0, n_elements(years)-1 DO BEGIN
            res = findfile(cdf_dir+'/'+years(i)+'/'+mask+'.cdf', count = n)
            IF n NE 0 THEN break
        ENDFOR 
        IF n EQ 0 THEN BEGIN
            res = messagebox(['Cannot find any cdf files'], ['cancel'])
            file = ''
            svnames = ''
        ENDIF
        file = res(0)   
    ENDIF ELSE BEGIN
        file = res(0)
    ENDELSE 

    widgetData.soptions(2) = file


    IF file NE '' THEN pick_myVARIABLES, file,svnames ,  /NOWIDGET
    widget_control, widgetData.cdfvar_list, set_value = svnames
    widget_control, widgetData.cdfvar_list, $
      set_list_select = widgetData.typevector(1)
    cdfvar = svnames(widgetData.typevector(1))
    widgetData.soptions(0) = widgetData.soptions(1) +', '+cdfvar
    pos = strpos(cdfvar, ' data ')
    cdfvar_name = strtrim(strmid(cdfvar, 0, pos), 2)       
    widgetData.soptions(3) = cdfvar_name 
ENDIF

IF keyword_set(DATATYPE) THEN BEGIN
    wid_ids = [widgetData.sl_pa, widgetData.sl_ek, $
               widgetData.sl_pa2, widgetData.sl_ek2]
    CASE WidgetData.ioptions(5) OF 
        0:BEGIN ;Spin Averaged Spectra
            set_plot = [1, 0] & set_sens = [0, 0, 0, 0]
            widgetData.ylinlog = 1
        END 
        1:BEGIN ;All Pitch Angles @ one Energy
            set_plot = [1, 0] & set_sens = [0, 1, 0, 0]
            widgetData.ylinlog = 0
        END 
        2:BEGIN ;All Energies @ one Pitch Angle
            set_plot = [1, 0] & set_sens = [1, 0, 0, 0]
            widgetData.ylinlog = 1
        END 
        3:BEGIN ;All Pitch Angles for an Energy Range
            set_plot = [1, 0] & set_sens = [0, 1, 0, 1]
            widgetData.ylinlog = 0
        END 
        4:BEGIN ;All Energies for a Pitch Angle Range
            set_plot = [1, 0] & set_sens = [1, 0, 1, 0]
            widgetData.ylinlog = 1
        END 
        5:BEGIN ;Pitch Angle Range @ an Energy Range (line plot)
            set_plot = [0, 1] & set_sens = [1, 1, 1, 1]
            widgetData.ylinlog = 1
        END 
    ENDCASE
    FOR i = 0,1 DO BEGIN
        widget_control, widgetData.plot_ids(i), sensitive = set_plot(i)
        widget_control, widgetData.plot_base, set_value = set_plot(i)
    ENDFOR 
    FOR i = 0,3 DO BEGIN
        widget_control, wid_ids(i), sensitive = set_sens(i)
    ENDFOR 
    papco_panel_refresh, widgetData, /YSCALE
ENDIF

IF keyword_set(SLIDERS) THEN BEGIN
    pa =  (widgetData.ioptions(6)-1) > 1
    ek =  (widgetData.ioptions(7)-1) > 1
    pa2 = (widgetData.ioptions(8)-1) > 1
    ek2 = (widgetData.ioptions(9)-1) > 1
    k = widgetData.typevector(0)
    eka = ek_arr(ek, k*2+0) & ekb = ek_arr(ek, k*2+1)

    ch_str=varprt(eka) + '-' + varprt(ekb) + ' eV'
    widget_control, widgetdata.ek_label, set_value = ch_str
    eka = ek_arr(ek2, k*2+0) & ekb = ek_arr(ek2, k*2+1)
    ch_str=varprt(eka) + '-' + varprt(ekb) + ' eV'
    widget_control, widgetdata.ek_label2, set_value = ch_str
    ;get pitch angle ranges
    pa_rng = papco_pitch_bin(15)
    ch_str=varprt(pa_rng(pa, 0)) + '-' + varprt(pa_rng(pa, 1)) + ' deg'
    widget_control, widgetdata.pa_label, set_value = ch_str
    ch_str=varprt(pa_rng(pa2, 0)) + '-' + varprt(pa_rng(pa2, 1)) + ' deg'
    widget_control, widgetdata.pa_label2, set_value = ch_str
ENDIF
    

  IF widgetData.typevector(0) gt 1 then begin
       ; widgetData.ioptions(2)=0 
                  
      ; if widgetData.typevector(0) gt 3 then widgetData.ioptions(2)=1;set as line plot
        wid_ids = [widgetData.sl_pa, widgetData.sl_ek, $
               widgetData.sl_pa2, widgetData.sl_ek2,widgetData.data_base,widgetData.units_base]
        set_sens = [0, 0, 0, 0,0,0]
        set_plot = [0, 1]

        FOR i = 0,1 DO BEGIN
           widget_control, widgetData.plot_ids(i), sensitive = 0
           widget_control, widgetData.plot_base, set_value = set_plot(i)

        ENDFOR 
        FOR i = 0,5 DO BEGIN
            widget_control, wid_ids(i), sensitive = set_sens(i)

        ENDFOR 
     endif else begin
         wid_ids = [widgetData.sl_pa, widgetData.sl_ek, $
               widgetData.sl_pa2, widgetData.sl_ek2,widgetData.data_base,widgetData.units_base]
    widget_control,widgetData.units_base , sensitive = 1
    widget_control,widgetData.data_base , sensitive = 1
 set_sens = [1, 1, 1, 1,1,1]
        set_plot = [1, 0]

        FOR i = 0,1 DO BEGIN
           widget_control, widgetData.plot_ids(i), sensitive = 0
           widget_control, widgetData.plot_base, set_value = set_plot(i)

        ENDFOR 
        FOR i = 0,5 DO BEGIN
            widget_control, wid_ids(i), sensitive = set_sens(i)

        ENDFOR 
; widgetData.ylinlog = 1
    endelse

widgetdata.ioptions(2)=set_plot(1)


END


;******************************************************************************
;* PROCEDURE:     
;*      PRO cluster_peace_panel_event, event
;* 
;* DESCRIPTION:  
;*      This processes events from the XMANAGER.
;*      As this example does not extend the basic functionality of plot-
;*      editors, it directly calls the default-handler, papco_PANEL_Event
;*
;* INPUTS:       
;*      event            an XManager event
;*                  
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by XMANAGER
;******************************************************************************
PRO cluster_peace_panel_event, event
  
COMMON cluster_peace_panel_data, widgetData
COMMON cluster_peace2, svnames, file, dirs

WIDGET_CONTROL,GET_UVALUE=uval, event.id

CASE uval OF
    
    'spb_cdfdir':BEGIN
        widgetData.typevector(0) = event.value
        cluster_peace_refresh, /VARLIST, /SLIDERS
    END
    'spb_units':BEGIN
        widgetData.ioptions(13)=event.value
cluster_peace_refresh, /VARLIST, /SLIDERS
    END

    'spb_reload' : widgetData.ioptions(11)=event.value

    'll_cdfvar':BEGIN
        cdfvar = svnames(event.index)
        widgetData.typevector(1) = event.index
        widgetData.soptions(0) = widgetData.soptions(1) +', '+cdfvar
        pos = strpos(cdfvar, ' data ')
        IF pos NE -1 THEN BEGIN
           cdfvar_name = strtrim(strmid(cdfvar, 0, pos), 2)       
           widgetData.soptions(3) = cdfvar_name 
           IF event.clicks EQ 2 THEN BEGIN ;double clicked
                  cdf_var_struct = read_mycdf(cdfvar_name, file)
                  help, cdf_var_struct.(0), /st, output = str_list
                  result = messagebox(str_list(1:n_elements(str_list)-1), $
                     ['Cancel'], GROUP_LEADER=widgetData.base, $
                     TITLE = 'Contents of '+cdfvar_name(0))
           ENDIF 
       ENDIF 
    END
  
    'spb_sc_id' : BEGIN
        widgetData.ioptions(0)=event.value
        cluster_peace_refresh, /VARLIST
    END

    'spb_data': BEGIN
        WidgetData.ioptions(5) = event.value
        cluster_peace_refresh, /DATATYPE
    END     

    'spb_plot': BEGIN
        WidgetData.ioptions(2) = event.value
    END     

    'sl_pa': BEGIN
        widgetData.ioptions(6)=event.value
        cluster_peace_refresh, /SLIDERS
    END     
    'sl_ek': BEGIN
        widgetData.ioptions(7)=event.value
        cluster_peace_refresh, /SLIDERS
    END     

    'sl_pa2':BEGIN
         widgetData.ioptions(8)=event.value
        cluster_peace_refresh, /SLIDERS
    END     

    'sl_ek2': BEGIN
        widgetData.ioptions(9)=event.value
        cluster_peace_refresh, /SLIDERS
    END 

    'ef_smooth': widgetData.ioptions(10)=event.value

    ELSE: BEGIN
        widget_control, widgetData.smooth_base,  get_value = smooth
        widgetData.ioptions(10)=smooth
        widgetData=papco_panel_Event(event, widgetData)
    END 

ENDCASE

    
END
