;------------------------------------------------------------------------------
; File: IIMS_PITCH_TEST.PRO Test of IIMS Pitch Angle Routines
; Revision 09/20/02       	J L Roeder
;------------------------------------------------------------------------------
pro iims_pitch_test

;	Setup anonymous data spec structure
data_spec = { $
	date: '07-21-2002', $
	ut_range: [0L, 86400000L], $
	spacecraft: 3L, $
	ion_species: [0], $
	components: [0, 1, 2], $
	average_time: 60., $
	energy_filter: [40.,60.], $
	polar_angle_filter: [0.,180], $
	spin_angle_filter: [0., 360.], $
	pitch_angle_filter: [0.,180.], $
	time_units: 0L $
}

sci_cm, 'i3dd', data_spec, err

scnumb = data_spec.spacecraft
ut_range = data_spec.ut_range
channel = data_spec.ion_species
eng_range = data_spec.energy_filter
pol_ang_range = data_spec.polar_angle_filter
spin_ang_range = data_spec.spin_angle_filter
pang_range = data_spec.pitch_angle_filter

if err(0) eq '' then i3dd_chan1, scnumb, ut_range, channel, eng_range, pol_ang_range, $
	spin_ang_range, pang_range, times, polang, engs, spinang, polindex, engindex, $
	spinindex, cnts, pang, err

;	Detector fields of view in rectangular spacecraft coordinates
if err(0) eq '' then iims_fov, polindex, spinindex, fov

;       RAPID IIMS field-of-view direction unit vectors in s/c coordinates
;	Date from data spec string
year = fix( strmid( data_spec.date, 6, 4))
month = fix( strmid( data_spec.date, 0, 2))
day = fix( strmid( data_spec.date, 3, 2))

;	Auxiliary filename from date
claux_filename, year, month, day, claux_filename

;	Read auxilliary file
if err(0) eq '' then claux_rd, claux_filename, err

;	Extract spin axis GSE lat and lon angles for this spacecraft
aux_channels = indgen( 2) + 4 + 2 * scnumb
if err(0) eq '' then claux_chan, ut_range, aux_channels, auxtimes, aux, err

;	Spherical coordinates of unit vectors is (lon, lat, rad)
spin_sph = fltarr( n_elements( auxtimes), 3)
spin_sph(0, 0) = aux(*, 1)
spin_sph(0, 1) = aux(*, 0)
spin_sph(0, 2) = replicate( 1., n_elements( auxtimes))
spin_sph = transpose( spin_sph)

;	Convert spin axis angles to rectangular unit vectors
spin_xyz = cv_coord( from_sphere = spin_sph, /TO_RECT, /DEGREES)

;	Magnetic field file name from data and spacecraft number
fgm_filename, year, month, day, scnumb, fgm_filename

;	Read magnetic field from prime parameter file
fgm_rd, scnumb, fgm_filename, err

;	Extract magnetic field unit vectors for time range
fgm_channels = [0, 1, 2]
normalize = 1
fgm_chan, scnumb, ut_range, fgm_channels, normalize, btimes, bmag, err

;	Linearly interpolate spin axis unit vectors to magnetic field times in hours
atims = auxtimes / 3.6e6
btims = btimes / 3.6e6
spin_xyzt = transpose( spin_xyz)
spin_xyz1 = fltarr( n_elements( btimes), 3)
spin_xyz1( 0, 0) = interpol( spin_xyzt( *, 0), atims, btims)
spin_xyz1( 0, 1) = interpol( spin_xyzt( *, 1), atims, btims)
spin_xyz1( 0, 2) = interpol( spin_xyzt( *, 2), atims, btims)
spin_xyz1t = transpose( spin_xyz1)

;	Interpolated spin axis angles as (longitude, latitude, radius)
spin_sph1 = cv_coord( FROM_RECT = spin_xyz1t, /TO_SPHERE, /DEGREES)
spin_sph1t = transpose( spin_sph1)

;	Spin axis polar angles from latitudes in radians
theta_rot = (90. - spin_sph1t( *, 1)) * !dtor

;	Rotation angles in radians
phi_rot = spin_sph1t(*, 0) * !dtor

;	GSE y projection of x sc axis must be zero gives third angle in radians
psi_rot = atan( tan( phi_rot * !dtor) / cos( theta_rot * !dtor))

;	Rotate magnetic field to non-spinning spacecraft coordinates
rot_vect, phi_rot, theta_rot, psi_rot, bmag, bmag_sc

;	Linearly interpolate magnetic vectors in spacecraft coordinates to particle times in hours
times_hrs = times / 3.6e6
times_hrs=reform(times_hrs,n_elements(times_hrs))
bmag_sc1 = fltarr( n_elements( times_hrs), 3)
bmag_sc1( 0, 0) = interpol( bmag_sc( *, 0), btims, times_hrs)
bmag_sc1( 0, 1) = interpol( bmag_sc( *, 1), btims, times_hrs)
bmag_sc1( 0, 2) = interpol( bmag_sc( *, 2), btims, times_hrs)

;	Pitch angle from negative of scaler product of mag vector and fov
pang = acos( bmag_sc1( *, 0) * fov( *, 0) + bmag_sc1( *, 1) * fov( *, 1) + $
	bmag_sc1( *, 2) * fov( *, 2)) / !dtor

nt = n_elements( pang) / (12L * 16L)
times = reform( times, 12, 16, nt)
pang = reform( pang, 12, 16, nt)
cnts = reform( cnts, 12, 16, nt)
fov = reform( fov, 12, 16, nt, 3 )
bmag_sc1 = reform( bmag_sc1, 12, 16, nt, 3)
tt = reform( times( 0, 0, *))

ii = 643
print, 'plt_ang_angi, pang(*,*,ii), cnts(*, *, ii), "WIN"&format_time,tt(ii),"hh:mm:ss", lab&print,lab'

stop, 'end of iims_pitch_test'

end
