;------------------------------------------------------------------------------
; File:    ROT_VECT.PRO   Rotates 3-d vectors by specified angles
; Revision 08/24/01       J L Roeder
;------------------------------------------------------------------------------
PRO rot_vect, phi, theta, psi, vect_in, vect_out

;	Rotates array of vectors through three specified angles
;	Ref. Classical Mechnics, Goldstein, pp. 146-147, Addison-Wesley, 1958.

; Inputs:
;	phi, theta, psi 	Angles in radians
;	vect_in			Unrotated vectors, dimensioned (nvect, 3)

; Outputs:
;	vect_out		Rotated vectors, dimensioned (nvect, 3)

cps = cos( psi)
sps = sin( psi)

cph = cos( phi)
sph = sin( phi)

cth = cos( theta)
sth = sin( theta)

vect_out = vect_in
vect_out( 0, 0) = (cps * cph - cth * sph * sps) * vect_in( *, 0) $
	  		- (sps * cph + cth * sph * cps) * vect_in( *, 1) $
	  		+ (sth * sph) * vect_in( *, 2)

vect_out( 0, 1) =  (cps * sph + cth * cph * sps) * vect_in( *, 0) $
	  		- (sps * sph - cth * cph * cps) * vect_in( *, 1) $
	  		- (sth * cph) * vect_in( *, 2)

vect_out( 0, 2) = (sth * sps) * vect_in( *, 0) + (sth * cps) * vect_in( *, 1) $
	  		+ cth * vect_in( *, 2)

END 
