;short program to copy all of the selected data for one day from deat
;to source, preserving the directory structures.
PRO c_cluster_rapid, date, PROC = PROC,  ORIG = ORIG, ALL = ALL

root = '/n/radbelt/dlnk/'
find_param = "-follow -name '*"+date+"*' -print"

dest = '/win/data/'

cd, root, current = old_dir

spawn, 'find cluster/rapid/pitch '+find_param, result
files = result
spawn, 'find cluster/rapid/ifdata '+find_param, result
files = [files, result]
spawn, 'find cluster/rapid/science/savesets '+find_param, result
files = [files, result]

FOR i = 0, n_elements(files)-1 DO BEGIN

    papco_sepdir, files(i), dir, fln, ext

    ;see if destination dir exisits, create if necessary
    IF NOT papco_finddir(dest+dir) THEN BEGIN
        ;make sure all directories in tree exisit, create if needed
        subdirs = strsplit(dest+dir, '/', /extract)
        test_dir = ''
        FOR j = 0, n_elements(subdirs)-1 DO BEGIN
            test_dir = test_dir+'/'+subdirs(j)
            IF NOT papco_finddir(test_dir) THEN BEGIN
                message, 'Creating '+test_dir, /cont
                spawn, 'mkdir '+test_dir
            ENDIF     
        ENDFOR  
    ENDIF
    ;now copy files
    print, 'cp '+root+files(i)+' '+dest+dir+fln+ext
    spawn, 'cp '+root+files(i)+' '+dest+dir+fln+ext

ENDFOR 

END 
