PRO cluster_rapid_sc_intercal, startday, endday

;startday='8/11/2002 11:00:00'
;endday='8/11/2002 22:00:00'
;add in L values too

COMMON cluster_eph_data, input_header, input_data
COMMON cluster_rapid_slice_1, time, zmat, data, yarr, utitle, uytitle, uztit

COMMON mjdt, mjdt_start, mjdt_end
COMMON get_error, get_err_no, get_err_msg

papco, /set_only

result = convert_timeToSeconds(startday, /t90, /mjdt)
t1 = result.value
result = convert_timeToSeconds(endday, /t90, /mjdt)
t2 = result.value
mjdt_start = t1 & mjdt_end = mjdt_start

FOR j = t1.mjd, t2.mjd DO BEGIN

    mjdt_start.mjd = j
    mjdt_end.mjd = j+1

    ;read data and extract one day of 1440 values, one per minute
;read ineph data    
    r_cluster_eph

    ;set the begin end end times. CLUSTER cdf time is in cdf epoch. 
    convert_t90_to_date, mjdt_start, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt
    cdf_epoch,xut1,yr,mo,day_om,hr,min,sec,0.0,/COMPUTE_EPOCH
    convert_t90_to_date, mjdt_end, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt
    cdf_epoch,xut2,yr,mo,day_om,hr,min,sec,0.0,/COMPUTE_EPOCH

;set up dummy plotinfo and add in required parameters
 result=papco_getplotinfostruct()    
;add required plot parameters
plotinfo=result
control.data_src=2;data source = RALIF
control.product=2;data type IES_ESPCT
control.ek=1;energy_CHANNEL
control.units=0;units
control.sc_id=0;sc_id
control.make=1
panelvector=[0,1,1]
orbitno=0
OUTPUT=2
currplotinfo=plotinfo
draw_cluster_rapid, panelVector, currPlotInfo, orbitNo, $
                        get_data_call, slice_type, IsRead, $
                        OUTPUT=2
stop
;draw_cluster_rapid,0,plotinfo,0
;p_cluster_rapid_spec, [-99, 0, 0], plotInfo, OUTPUT=2

    ;restrict data to actual time range requested 
    index=where((input_data.epoch ge xut1) and (input_data.epoch lt xut2),cc)
    if cc ne 0 then data=input_data(index)
    ndat=n_elements(data)


    tags=tag_names(data)
    pos=strpos(tags,'L_VALUE')
    idx =where(pos ne -1,c)

;setup loop to create array of time when L is between particular
;values
;loops for each spacecraft
LMAX=6.5
LMIN=5.5

;for i=0,3 do begin
LVALUES=data.idx(0)
index1=where((LVALUES GE LMIN) and(LVALUES LE LMAX))
;endfor



    stop



ENDFOR


END
