;******************************************************************************
;* FILE:	 
;*    cmdl_batch_rapid_ccr_plots
;* 
;* DESCRIPTION:  
;*    runs papco in command line mode.
;*    this batch file makes all the CCR summary plots for CLUSTER RAPID
;*
;*    Keywords are a subset of those for cluster_rapid_m_batch
;*   
;*    Filename template can contain the following placeholders:
;*        $       will be replaced by the current product name if defined
;*	  %	  will be replaced by the plot's orbit number
;*	  <	  will be replaced by the plot's starttime
;*	  >	  will be replaced by the plot's endtime
;*        &       will be replaced by the plot's start date only
;*        #       will be replaced by the batch running number
;*
;* MODIFICATION HISTORY:       
;*    written January 2001, R.Friedel
;******************************************************************************
pro cmdl_batch_rapid_ccr_plots, VERBOSE = VERBOSE, $
                                CCR_TYPE = CCR_TYPE, RESTRICT = RESTRICT, $
                                SC_ID = SC_ID, SOURCE = SOURCE, DEST = DEST, $
                                PROB_FORCE = PROB_FORCE,  $
                                FROM = FROM,  BEFORE = BEFORE
papco, /set_only
common cluster_rapid

if keyword_set(PROB_FORCE) then force=PROB_FORCE else force=0
if keyword_set(FROM) then from=FROM else from=0
if keyword_set(BEFORE) then before=BEFORE else before=0
if keyword_set(SC_ID) then sc_id=varprt(SC_ID) else sc_id='1'
IF keyword_set(CCR_TYPE) THEN ccr_type = CCR_TYPE ELSE ccr_type = 'Alle' 

print,''
print, '--- Running PAPCO command line mode for CLUSTER RAPID CCR plots ------'
print,''

;make batch file for all times available for the various ccr products.
m_cluster_rapid_batch, batch_times, filename, /verb, /write, $
                       CCR_TYPE = CCR_TYPE, FROM = FROM,  BEFORE = BEFORE, $
                       SC_ID = SC_ID, SOURCE = SOURCE, DEST = DEST, $
                       PROB_FORCE = PROB_FORCE, RESTRICT = RESTRICT

IF batch_times(0) EQ '' THEN GOTO, web_plots

no_make_batch:
product_path = '/u/friedel/mypapco/papco_products/batch_products/'
product ='cluster_rapid_'+ccr_type+'_ccr_summary' 
output  ='/n/projects/cda/cluster/SummaryPlots/ClusterRapid'+ccr_type
templ   ='&_ClusterRapid'+ccr_type      ; set filename template - date

print, '----------------------------------------------------------------------'
print, 'Using batch file: '+filename
print, 'Using papco product: '+product_path+product
print, 'Output dir: '+output
print, 'File template: '+templ
print, '----------------------------------------------------------------------'
wait, 5

papco, $
  DEFAULT_ADJUST_TIME = 0.0, $         ;don't adjust time
  PRODUCT = product_path+product, $
  BATCH = filename, $
  OUTPUTFILEPATH = output, $
  DEFAULT_FILENAME_TMPL=templ, $
  DEFAULT_LAYOUT = 0, $                ; layout portrait
  DEFAULT_FILETYPE = 2, $              ; output in postscript AND png
  DEFAULT_CHARSIZE = 1.4, $
  DEFAULT_PS_MULT = 0.8, $
  DEFAULT_PLOT_SIZE = [100.0, 92.5], $ ; plot size, leave room for eph
  DEFAULT_TRAP = 1, $                  ; yes, trap errors and continue
  DEFAULT_WGET = 0, $                  ; disable wget
  DEFAULT_NUMBERING = 1, $             ; turn of panel numbering
  DEFAULT_XLINES = 2, $                ; allow time + date lines
  VERBOSE = 0, $                       ; inhibit printouts
  DEFAULT_STATES = 1                   ; no papco_state files

print,''
print, '--- End PAPCO command line mode --------------------------------------'
print,''

web_plots:
;make all the required png sizes for the CCR browser 
cluster_rapid_make_web_plots, TYPE = ccr_type, FORCE=1

end
