PRO get_cluster_rapid_ies_pitch, control, p

COMMON mjdt, mjdt_start, mjdt_end
COMMON cluster_rapid_slice
COMMON cluster_rapid_data, input_header, input_data
COMMON get_error, get_err_no, get_err_msg  

control.data_src = 3
new_plotinfo = papco_getplotinfostruct()
new_plotinfo.USR_PTR1 = ptr_new(control)

r_cluster_rapid, new_plotinfo
IF get_err_no NE 0 THEN return

;time is in common block cluster_rapid_slice is the time of the data
;array that needs sorting into pitch angle. - starting at zero,
;i.e. start time subtracted. 

;input_data.time is time in TAI of det/sec pitch info for chosen time
;range. 

;need to make array p [fltarr(16, 9, ndat)] corresponding to same
;times as data.

;make time array of midpoints of spins for data
td = (time[*, 0]+time[*, 1]) / 2.0

;make time array of pitch data starting at 0, i.e. start time subtracted
tai1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
tp = input_data.time-tai1

;now make array of pitch only for actial data times requested! (td)
p = fltarr(16, 9, n_elements(td)) & p[*] = 1e-20

FOR i = 0l, n_elements(td)-1 DO BEGIN
    idx = where(tp EQ td(i), c)
    if c EQ 1 THEN p(*, *, i) = input_data(idx(0)).data
ENDFOR 

END
