;******************************************************************************
;* PROCEDURE:     
;*      p_cluster_rapid_mu, panel, plotinfo, OUTPUT=OUTPUT, $
;*           OVERPLOT=OVERPLOT,$
;*           PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           SUBTABLE=SUBTABLE, _EXTRA=extra_par
;* 
;* DESCRIPTION:  
;*	This procedure plots data of type data_type for inclusion in papco.  
;*      Data must have been read and placed into common blocks before this
;*      routine is called. In general, the following plot conventions are used:
;*      	- if the panel is at the bottom plot time axis plus any
;*                additional axis (ie ephemeris) needed.
;*              - a descriptor for panels is plotted to the right of each
;*                panel, rotated by 90 deg if there is a papco_colorbar
;*              - panels all have common time
;*              - y-scaling (and/or z-scaling for color plots) is either
;*              - automatic or manually set using common yscale or zscale    
;*
;* INPUTS:       
;*	panel	three element integer vector. Controls positioning of the plot
;*              (see papco_conventions.text in $papco)
;*      type    optional parameter for options. Normally is a four element
;*              integer vector. This is normally equivalent to the field
;*              typeVector of the papco structure PAPCD_PLOTINFO which is set
;*              by the panel editor. Additional fields that can be used if
;*              needed are papco_plotinfo.ioptions (20 element vector) and 
;*              PAPCO_PLOTINFO.channel (integer). If your plot routine needs
;*              more input fields than these you have to make use of
;*              an extra common block.
;*              
;* OUTPUTS:   	none
;*
;* KEYWORDS:
;*      OUTPUT  if set call the papco routine that outputs plot data
;*              to a file. If equal to 2, make plot data and return,
;*              do not plot anything! Used by slices;*    OVERPLOT  if you support this you can alter the appearance of your
;*              plot if it is an overplot to an exisiting panel. Standard is
;*              to plot data, no axis, using the y-scaling of the first plot
;*              and to shift the labeling on the left down one line. Useful
;*              to plot model data together with real data, ie mag. field
;*              (see p_crres_mag for an example).
;* PLOTS_ATTHISPOSITION  used to control the left side labeling for more
;*              than one overplot at the same position.
;*      _EXTRA  the plot structure containing some keyword for calls to
;*              plot. Used to customize color and line style.   
;* 
;* CALLING SEQUENCE:
;*       p_cluster_rapid, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;*
;* MODIFICATION HISTORY:       
;*     written april 1996, Reiner Friedel
;*     added OUTPUT support, July 1998, Reiner Friedel
;*modified versionof p_cluster_rapid_4sc by Matt Taylor
;******************************************************************************
pro p_cluster_rapid_mu, panel, PlotInfo, OUTPUT=OUTPUT, $
                      OVERPLOT=OVERPLOT, $
                      PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
                      SUBTABLE=SUBTABLE, _EXTRA=extra_par

; The following common blocks are needed for PAPCO:
  common mjdt, mjdt_start, mjdt_end     ;common time limit in mjdt
  common yscale, yscl			;man/auto yscaling
  common zscale, zscl			;man/auto zscaling
  common shift_label, down              ;common for x-axis label shifting
  common coordinateSystems, plotted_x, plotted_y  
                                        ;info on coords used by mouse
  COMMON papco_color_names
  COMMON get_error, get_err_no, get_err_msg  
  cl_col = [black, red, green, blue]
; One of the common blocks should contain the plot data as returned by the
; data read procedure r_cluster_rapid. 
  common cluster_rapid_data, input_header, input_data
  common cluster_rapid_slice_1, time, zmat, data, yarr, utitle, uytitle, uztit
  common cluster_rapid
  COMMON cluster_rapid_counting_error, RAPID_ERR
 ; COMMON hilmer,  PSD
stop
  sc_id = control.sc_id
  data_source = control.data_src
  data_type = control.product
  plot_type =  control.pl_type
  detector = control.det > 0 < 8
  sector = control.sect
  energy = control.ek-1>0
  units = control.units
  sc4_flag =  control.prod_4sc
  mu_value = control.mu1
  counts_std = plotinfo.ioptions(17)
print,sc4_flag

  units = control.units

  convert_t90_to_date, mjdt_start, yr,doy,hr,min,sec,mo,cmo,dom, /mjdt
  tai_1=UTC2TAI({YEAR:yr, MONTH:mo, DAY:dom, HOUR:hr, MINUTE:min, $
                 SECOND:sec, MILLISECOND:0})
  convert_t90_to_date, mjdt_end, yr,doy,hr,min,sec,mo,cmo,dom, /mjdt
  tai_2=UTC2TAI({YEAR:yr, MONTH:mo, DAY:dom, HOUR:hr, MINUTE:min, $
                 SECOND:sec, MILLISECOND:0})
  xut1=0  &  xut2=tai_2-tai_1  

  RAPID_time = input_data.time
size_rapid_data=size(input_data.data) 
RAPID_DATA=dblarr((size_rapid_data(4)),(size_rapid_data(3)));rapid_data(channel,data)
RAPID_DATA1=input_data.data(0,0,*,*)
RAPID_DATA=transpose(RAPID_DATA1)
  ndat=n_elements(RAPID_time)

  ;select data to plot
  IF_type = IF_names(data_type)
  n_ch = input_header.NBANDS
  n_sec = input_header.NSECTORS
  n_det = input_header.NDETECTORS
  utitle = 'RAPID '+IF_type


if input_header.CH_POSITIONS(0) eq 16 then  input_header.CH_POSITIONS = input_header.CH_POSITIONS* 2.2 + 6.5 ;do energy channel conversion
  if control.smooth ne 0 then begin ;set smoothing
    sm = control.smooth

    utitle=utitle+'!CSmooth '+varprt(sm)
  endif else sm=0

;*************************************************************************************************

;*get fgmdata and create mu values

papco_get_cluster_fgm_data, sc_id, FGM_MAG, epoch_time
IF get_err_no NE 0 THEN GOTO, noplot

  convert_t90_to_date, mjdt_start, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt
  cdf_epoch,epoch_1,yr,mo,day_om,hr,min,sec,0.0,/COMPUTE_EPOCH
  tai_11=UTC2TAI({YEAR:yr, MONTH:mo, DAY:day_om, HOUR:hr, MINUTE:min, $
                SECOND:sec, MILLISECOND:0});

  convert_t90_to_date, mjdt_end, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt
  cdf_epoch,epoch_2,yr,mo,day_om,hr,min,sec,0.0,/COMPUTE_EPOCH
  tai_22=UTC2TAI({YEAR:yr, MONTH:mo, DAY:day_om, HOUR:hr, MINUTE:min, $
                 SECOND:sec, MILLISECOND:0})

time_diff = tai_11-(epoch_1/1000.0)
tai_rapid_time=RAPID_time
RAPID_time = RAPID_time-tai_11


;EPH is in CDF EPOCH time 
tai_cdf=(epoch_time)/1000.0+time_diff
index = where((tai_cdf GE tai_11) AND (tai_cdf LE tai_22), count)
FGM_MAG = FGM_MAG(index)

FGM_MAGNI1 = interpol(FGM_MAG, tai_cdf(index),tai_RAPID_time, /quadratic);fgm data on same time line as RAPID data
FGM_MAGNI2 = interpol(FGM_MAG, tai_cdf(index), tai_RAPID_time);fgm data on same time line as RAPID data
;TWO interpolations are carried out and compared , regions of zero
;data will stand out from different methods , here FGM_MAGNI2 uses
;linear and FGM_MAGN1 uses quadratic.

no_gaps = where(abs(fgm_magni1 - fgm_magni2) LT 1)

fgm_new = RAPID_time
fgm_new(*) = !values.F_NAN
fgm_new = -fgm_new
fgm_new(no_gaps) = fgm_magni1(no_gaps)
;fgm_new = fgm_magni1
FGM_MAGNI = fgm_new
size_bmag = size(FGM_MAGNI)
IF count EQ 0 THEN message, 'no cdf data found' ELSE message,  'cdf data loaded', /continue

IF  control.mu2 EQ 0 THEN BEGIN ; PSD at constant mu opition
  
mu_value = double(control.mu1)
lower_energy = input_header.CH_POSITIONS(0, *)
upper_energy = input_header.CH_POSITIONS(1, *)


;call separate program here


papco_mu_calculation,lower_energy,upper_energy,mu_value,RAPID_DATA,FGM_MAGNI,flux_mu


;-------------------------------------------------------------------
;COUNTING ERROR IN HERE
;-------------------------------------------------------------------
;read in RAPID data in cnts

oldplotinfo = plotinfo
  sc_id = control.sc_id
  sc4_flag =  control.prod_4sc
  smooth = control.smooth

oldplotinfodataunits = control.units
control.units = 0
print,utitle
r_cluster_rapid,plotinfo

p_cluster_rapid_spec, [-99, 0, 0], plotInfo, OUTPUT=2
;data now in cnts
RAPID_data_counts=ZMAT
RAPID_COUNT=RAPID_data_counts

RAPID_DATA_ERROR=RAPID_COUNT
RAPID_count_err=sqrt(ZMAT)
;cycle thru channels to find non sero data
for i =0,5 do begin
index_nonzero_counts=where(ZMAT(*,i) NE 0)
RAPID_DATA_ERROR(index_nonzero_counts,i)=RAPID_count_err(index_nonzero_counts,i)/RAPID_data_counts(index_nonzero_counts,i)
endfor
control.units = oldplotinfodataunits
plotinfo = oldplotinfo
  control.sc_id = sc_id 
  control.prod_4sc = sc4_flag
  control.smooth = smooth
;*----------------------------------------------------------------------------------------------------

RAPID_DATA_ERROR =  RAPID_DATA*RAPID_DATA_ERROR

papco_mu_calculation,lower_energy,upper_energy,mu_value,RAPID_DATA_ERROR,FGM_MAGNI,flux_mu_error

ENDIF
      ; energy channel data from input_header.CH_POSITIONS
;----------------------------------------------------------------
IF control.mu2 EQ 1 THEN BEGIN; this does mu range 

     bottom_channel= input_header.CH_POSITIONS(*,control.det-1,0,0)
        top_channel= input_header.CH_POSITIONS(*,control.ek-1,0,0)

centre_energy=[10^((alog10(bottom_channel(0))+alog10(bottom_channel(1)))/2),10^((alog10(top_channel(0))+alog10(top_channel(1)))/2)]
bottom_channel=centre_energy(0)
top_channel=centre_energy(1)
;-------------------------------------SET UPPER AND LOWER BANDS AS MAX

MU = dblarr(2, size_bmag(1));where i is dimension of array length

 MU(0,*) = bottom_channel/FGM_MAGNI
 MU(1,*) = top_channel/FGM_MAGNI
test_1 = where(MU(0, *) LT mu_value)

    mu_str = strcompress( $
               string(bottom_channel, top_channel, $
                      format = "(f6.1,'-',f6.1,' keV')"), /remove_all)
      utitle='!C!4l!3 range!C'+'  for!C'+mu_str+'!C'+sc_names(sc_id)

endif

  if keyword_set(OUTPUT) then if output eq 2 then return  
  
  papco_Set_SubTable, SUBTABLE          ;sets the papco color table index
  panelset,panel		        ;sets the panel position viewport

;***************************************plottingstuff


      IF  control.mu2 EQ 0 THEN BEGIN

;-------------------------------------
flux_mu1 = flux_mu
smooth_mu_value = control.smooth;equal to number of data points to average over
IF smooth_mu_value GT 2 THEN begin
smooth_data_mu = smooth(flux_mu, smooth_mu_value,/edge_truncate, /NAN)
smooth_data_mu_error = smooth(flux_mu_error, smooth_mu_value, /edge_truncate,  /NAN)
flux_mu = smooth_data_mu
flux_mu_error = smooth_data_mu_error
ENDIF

time_mid = (time(*, 0)+time(*, 1)) /2.0
size_time = size(time)

    if (yscl(panel(0),0) eq 1) then begin 
        yst=yscl(panel(0),1)  &  yen=yscl(panel(0),2)
      endif else BEGIN
        papco_autorange,flux_mu,yst,yen, $
          log=yscl(panel(0),3), exclude=0, nodat=1e-20
        yscl(panel(0),1)=yst  &  yscl(panel(0),2)=yen
      endelse      
      papco_y_label, yst, yen, log=yscl(panel(0),3) 
    
      extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
                     ylog:yscl(panel(0),3), xtickformat:'noticks'}  
      ;add keyword structure set locally and the one passed in
      extra_plotPar=create_struct(extra_plotPar, extra_par)

      down=0
      papco_draw_time_axis, panel, OVERPLOT=OVERPLOT, _extra=extra_plotPar
        extra_plotPar.color = cl_col(0)
extra_plotpar.color =cl_col(1)

 plot, RAPID_time, flux_mu, xstyle=5, ystyle=5, _extra=extra_plotPar

oldextraplotpar = extra_plotpar

extra_plotpar.linestyle = 1
extra_plotpar.color =cl_col(1)+10

plot, RAPID_time, flux_mu-flux_mu_error, xstyle=5, ystyle=5, _extra=extra_plotPar
plot, RAPID_time, flux_mu+flux_mu_error, xstyle=5, ystyle=5, _extra=extra_plotPar

extra_plorPar = oldextraplotpar
  right_side_label,panel,utitle+'!C +/- STD DEV'
 
  uytitle = 'Hilmer PSD s!U3!N km!U-6!N'


      ENDIF


 IF  control.mu2 EQ 1 THEN BEGIN

     if (yscl(panel(0),0) eq 1) then begin 
        yst=yscl(panel(0),1)  &  yen=yscl(panel(0),2)
      endif else BEGIN
        papco_autorange,MU,yst,yen, log=yscl(panel(0),3), exclude=0, nodat=1e-20

        yscl(panel(0),1)=yst  &  yscl(panel(0),2)=yen
      endelse      
      papco_y_label, yst, yen, log=yscl(panel(0),3) 
      extra_plotPar={xrange:[xut1,xut2], yrange:[yst,yen], $
                     ylog:yscl(panel(0),3), xtickformat:'noticks'}  
      ;add keyword structure set locally and the one passed in
      extra_plotPar=create_struct(extra_plotPar, extra_par)

      down=0
      papco_draw_time_axis, panel, OVERPLOT=OVERPLOT, _extra=extra_plotPar
    
;-------------------SMOOTH DATA

smooth_value = control.smooth;equal to number of data points to average over
IF smooth_value GT 2 THEN begin
smooth_mu1 = smooth(MU(0, *), smooth_value,/edge_truncate, /NAN)
smooth_mu2 = smooth(MU(1, *), smooth_value,/edge_truncate, /NAN)

MU(0, *)=smooth_mu1
MU(1, *)=smooth_mu2
endif
;-----------------SMOOTH DATA
      FOR i = 0, 1 DO BEGIN
        idx = where(MU(i, *) NE 0, c)
        extra_plotPar.color = cl_col(i)
        IF c LT 2 THEN GOTO,  out_plot
       plot, RAPID_time(idx), MU(i, idx), xstyle=5, ystyle=5, _extra=extra_plotPar
      ENDFOR

  right_side_label,panel,utitle
      uytitle = '!4l!3 KeV/nT'
  ENDIF


;--------------------------------------------------------------------------------


  out_plot:
; plot y-axis label at left of plot. Use scalable routine!  
  left_side_label,panel,uytitle,/rot90

; store the coordinate information into common block
  plotted_x = !x  &  plotted_y = !y

; check if data needs to be output to file. Use the optional keywords
; to add more information to the data file
;      DESCRIPTION   a string or string array describing the data
;      TIME_LABEL    a string decribing the x-axis format
;      CHANNELS      an (ch,2) array giving the channel start/end
;      Y_LABEL       a string with the y-axis label
;      Z_LABEL       a string with the z-axis label
;      RS_LABEL      a string with the righ-side label of the plot
;      NODATA        contains the no data flag value.
  if KEYWORD_SET(OUTPUT) then begin
    message,'Writing plot data out to file'
    description='cluster_rapid template sample data'
    time_label='Seconds since start of day'
    channels=yarr
    y_label=uytitle
    z_label=uztit
    rs_label=utitle
    nodata=0
    papco_write_data, time, zmat, $
                      DESCRIPTION=description, TIME_LABEL=time_label, $
                      CHANNELS=channels, Y_LABEL=y_label, Z_LABEL=z_label, $
                      RS_LABEL=rs_label, NODATA=nodata
  endif
   
return

noplot:
plotted_x = !x  &  plotted_y = !y
papco_Draw_ErrorPanel, panel, get_err_msg
return

end 


;******************************************************************************
;******************************************************************************
;papco_get_cluster_fgm_data.pro
; gets fgm data
;INPUTS:sc_id
;outputs,mag coords and epoch
;
;****************************************8
PRO papco_get_cluster_fgm_data,  sc_id, mag, mag_epoch

COMMON cluster_rapid_data, header, input_data
COMMON cluster_rapid
COMMON get_error, get_err_no, get_err_msg  
COMMON papco_cdf_data, cdf_data
RAPID_SC =fix(SC_ID+1);

IF rapid_sc lT 5 THEN rapid_sc_str = '4'
IF rapid_sc lT 4 THEN rapid_sc_str = '3'
IF rapid_sc lT 3 THEN rapid_sc_str = '2'
IF rapid_sc lT 2 THEN rapid_sc_str = '1'
stop
RAPID_SC = string(rapid_sc)
plotinfo = papco_getplotinfostruct()
control.mus = $
  'cluster_fgm, B_xyz_gse__C'+RAPID_SC_str+'_PP_FGM          data       FGM DC magnetic field'
control.pa_ctr_3dd = 'cluster_fgm'
control.pa_lbl_3dd = $
  '/n/radbelt/dlnk/cdf/cluster_fgm/2000/c'+RAPID_SC_str+'_pp_fgm_20001101_v01.cdf'
plotinfo.soptions(3) = 'B_xyz_gse__C'+RAPID_SC_str+'_PP_FGM'

r_papco_cdf, plotinfo, /verb

IF get_err_no NE 0 THEN return

tagnames = tag_names(cdf_data)
pos = strpos(tagnames, strupcase(plotinfo.soptions(3))) & idx = where(pos NE -1)
mag_xyz = transpose(cdf_data.(idx(0)).dat)
pos1 = strpos(tagnames, 'EPOCH') &  idx1 = where(pos1 NE -1)
mag_epoch = cdf_data.(idx1(0)).dat
mag = sqrt(mag_xyz(*, 0)^2+mag_xyz(*, 1)^2+mag_xyz(*, 2)^2)

;plotinfo = old_plotinfo

END

