;******************************************************************************
;* PRCEDURE
;*      PRO papco_cluster_rapid_sc_intercal, starttime, endtime,LMIN,LMAX,intercal_arr
;* DESCRIPTION:  
;*      code reads in RAPID IESSPECT spin averaged data in counts for
;*      specified L range (from LMIN,LMAX) to allow interspacecraft
;*      RAPID comparisons.
;*   
;*
;* INPUTS:       
;*      starttime and endtime strings in general papco format
;*      or just '8/01/2002 00:00:00' ie 
;*      mn/dy/year hr:mn:sc 
;*      LMIN and LMAX Lrange values.
;* KEYWORDS:
;*  
;* OUTPUT:	 
;*     intercal_arr, strucutre of 4 sc start end times for each Lrange pass
;*     with 6 averaged (over Lrange) energy channel counts. 
;*
;* MATT TAYLOR feb 2003
;******************************************************************************


PRO papco_cluster_rapid_sc_intercal, starttime, endtime,LMIN,LMAX,LUT_VALUE,intcal_arr,$
                                 HAVE_DATA = HAVE_DATA
;have left these in for testing
starttime='10/01/2002 00:00:00'
endtime='11/01/2002 00:00:00'

;LUT_VALUE=0
;LMIN=5
;LMAX=7.5

lmin=3   &  lmax=10
lstep=0.1
lut=7

timeres=5;
data_spike_ceiling=10000


;**********************

COMMON cluster_eph_data, input_header, input_data
COMMON cluster_rapid_slice_1, time, zmat, data, yarr, utitle, uytitle, uztit
COMMON cluster_rapid
COMMON mjdt, mjdt_start, mjdt_end
COMMON get_error, get_err_no, get_err_msg
;COMMON cluster_rapid_4sc, data4sc_timed
COMMON intercalkeep1, inbound_outbound_info, data4sc_timed,data4sc,cl_lvalues_interp,ch,intcal_matches,tai_start,time_diff,start_orbit,stop_orbit,start_month_year,stop_month_year,data_flag_arr,plotinfo,eph_data,smooth,sc_id,start_apogee,start_start,end_end,data_reset

if keyword_set(HAVE_DATA) then goto, have_data

papco, /set_only
LMIN_VALUE=LMIN
LMAX_VALUE=LMAX
result = convert_timeToSeconds(starttime, /t90, /mjdt)
t1 = result.value

result = convert_timeToSeconds(endtime, /t90, /mjdt)
t2 = result.value
mjdt_start = t1 & mjdt_end = t2

    ;read ineph data    
    r_cluster_eph

  
;********************************   read in start and end timesand find beginning and end of whole
;********************************   orbits within that time  from apogee times;

  ;set the begin end end times. CLUSTER cdf time is in cdf epoch. 
    convert_t90_to_date, mjdt_start, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt
    cdf_epoch,xut1,yr,mo,day_om,hr,min,sec,0.0,/COMPUTE_EPOCH
    tai_start=UTC2TAI({YEAR:yr, MONTH:mo, DAY:day_om, HOUR:hr, MINUTE:min, $
                SECOND:sec, MILLISECOND:0});
    convert_t90_to_date, mjdt_end, yr,day_oy,hr,min,sec,mo,cmo,day_om, /mjdt
    cdf_epoch,xut2,yr,mo,day_om,hr,min,sec,0.0,/COMPUTE_EPOCH
    tai_end=UTC2TAI({YEAR:yr, MONTH:mo, DAY:day_om, HOUR:hr, MINUTE:min, $
                 SECOND:sec, MILLISECOND:0})

time_diff=tai_start-(xut1/1000.0)

   index=where((input_data.epoch ge xut1) and (input_data.epoch lt xut2),cc)
    if cc ne 0 then eph_data=input_data(index)
    ndat=n_elements(eph_data)    
    eph_epoch=eph_data.EPOCH;eph data epoch values
    eph_tai=(eph_epoch/1000.0)+time_diff


orbit_nums=eph_data.(1)
or_no_str=string(orbit_nums)
apogee_region=strpos(or_no_str,'.5')
apogee_region_idx=where(apogee_region ne -1,c)
idx_start_apogee=apogee_region_idx(0)
start_apogee=orbit_nums(idx_start_apogee)

stop_apogee=string(orbit_nums(apogee_region_idx(n_elements(apogee_region_idx)-1)))
stop_apogee=(  string(fix(stop_apogee))+'.5')
idx=strpos(or_no_str,stop_apogee)
idx_stop_apogee=where(idx ne -1)
idx_stop_apogee=idx_stop_apogee(0)

start_orbit=eph_data(idx_start_apogee).(1)
stop_orbit=eph_data(idx_stop_apogee).(1)

eph_data=eph_data(idx_start_apogee:idx_stop_apogee)

;********************************************  now re-write start and end times from start of whole  orbit at apogee

xut1=eph_data(0).(0)
xut2=eph_data(n_elements(eph_data)-1).(0)
cdf_epoch,xut1,yr,mo,day_om,hr,min,sec,/break
start_start=strcompress(string(mo)+'/'+string(day_om)+'/'+string(yr)+string(hr)+':'+string(min)+':'+string(sec))
start_month_year=strcompress(string(mo),/remove_all)+'_'+(string(yr))
 tai_start=UTC2TAI({YEAR:yr, MONTH:mo, DAY:day_om, HOUR:hr, MINUTE:min, $
                SECOND:sec, MILLISECOND:0});
cdf_epoch,xut2,yr,mo,day_om,hr,min,sec,/break
end_end=strcompress(string(mo)+'/'+string(day_om)+'/'+string(yr)+' '+string(hr)+':'+string(min)+':'+string(sec))
stop_month_year=strcompress(string(mo),/remove_all)+'_'+(string(yr))
    tai_end=UTC2TAI({YEAR:yr, MONTH:mo, DAY:day_om, HOUR:hr, MINUTE:min, $
                 SECOND:sec, MILLISECOND:0})

result = convert_timeToSeconds(start_start, /t90, /mjdt)
t1 = result.value
result = convert_timeToSeconds(end_end, /t90, /mjdt)
t2 = result.value
mjdt_start = t1 & mjdt_end = t2

;************************************                 NOW have data for max number
;***********************************************  of whole orbits between selected times.
;
time_diff=tai_start-(xut1/1000.0)
;set up dummy plotinfo and add in required parameters to read in RAPID
;DATA
 result=papco_getplotinfostruct()    
;add required plot parameters
plotinfo=result
control.data_src=2;data source = RALIF
control.product=2;data type IES_ESPCT
control.ek=1;energy_CHANNEL
control.units=0;units
control.sc_id=0;sc_id
control.make=1
plotinfo.xut1=xut1
plotinfo.xut2=xut2
control.make=0;force make data
;control.prod_4sc=1; 4scflag 
panelvector=[0,1,1]
orbitno=0
smooth = control.smooth
OUTPUT=2
currplotinfo=plotinfo
sc_id = control.sc_id
;********************************************read in RAPID data for requested  time

for i=0,3 do begin
 currcontrol.sc_id=i;sc_id
  r_cluster_rapid,currPlotinfo
    ;check if data read O.K.
    IF get_err_no ne 0 THEN BEGIN
      get_err_msg = 'can not read 4 SC data, SC missing'
      GOTO, found_error
    ENDIF
    p_cluster_rapid_spec, [-99, 0, 0], CurrplotInfo, OUTPUT=2
    ;check if any data contained for time period
    IF get_err_no ne 0 THEN BEGIN
      get_err_msg = 'can not read 4 SC data, no common data for time period'
      GOTO, found_error
    ENDIF    
   LUT1=data.LUT
time_time=(time(*,0)+time(*,1))/2.0
dummy = {time:time_time, zmat:zmat,LUT:LUT1}
    IF i EQ 0 THEN $ ;make structure for data from 4 spacecraft
      data4sc = create_struct('cl'+varprt(i+1), dummy) $
    ELSE $ ;add spacecraft to structure
      data4sc = create_struct(data4sc,'cl'+varprt(i+1), dummy)
endfor


;*************************** make predetermined time array of 4seconds steps to make non-broken
;****************************************************timeseries
;***************************************must also make flag  arr to flag data gaps
;
whole_orbit_select_time_diff=tai_end-tai_start

data_time_arr=findgen((whole_orbit_select_time_diff/4))
data_time_arr=4*data_time_arr
data_time_arr=data_time_arr(1:(n_elements(data_time_arr)-1))
data_flag_arr=intarr(n_elements(data_time_arr))

message, 'Folding data onto whole timeseries time ', /cont

data4sc_timed =   {time1:data_time_arr,  $
                   time2:data_time_arr,  $
                   time3:data_time_arr,  $
                   time4:data_time_arr,  $
                   zmat1:fltarr(n_elements(data_time_arr),6), $
                   zmat2:fltarr(n_elements(data_time_arr),6), $
                   zmat3:fltarr(n_elements(data_time_arr),6), $
                   zmat4:fltarr(n_elements(data_time_arr),6), $
                   LUT_1:data_time_arr,   $
                   LUT_2:data_time_arr,   $
                   LUT_3:data_time_arr,   $
                   LUT_4:data_time_arr }
                  
  ;********************************get number of channels in data array
  result = size(data4sc.(sc_id).zmat,  /struct)
  ch =  result.dimensions(1)
   
  FOR i = 0,  3 DO BEGIN ;loop through spacecraft
    
    message, '...doing for Cluster '+varprt(i+1), /cont
    t_center =  data4sc.(i).time
    data4sc_timed.(i+8)=interpol(data4sc.(i).(2),t_center,data_time_arr)
    data4sc_timed.(i)=interpol(data4sc.(i).(0),t_center,data_time_arr)

    ;loop through channels to interpolate
    FOR j = 0, ch-1 DO $
      data4sc_timed.(i+4)(*, j)= $
        interpol(data4sc.(i).zmat(*, j), t_center, data_time_arr)
  ENDFOR 

;********************************************do check on original time to find timeseries breaks
;*********************************************this takes a longtimefor large time periods
;******************************************************************have_data:

  for i=0,3 do begin

print,'time series check sc ',(i+1),'!!!SLOW!!!'
          time_1=data4sc.(i).(0)
          diff=fltarr(n_elements(time_1)-1)
    for j=1.0,(n_elements(data4sc.(i).(0))-1) do begin
       diff(j-1)=data4sc.(i).(0)(j)-data4sc.(i).(0)(j-1) 
    endfor
         test=where(diff gt timeres,c)
print,c
    if c gt 0 then begin
      for k=0,(n_elements(test)-1) do  begin
          idx = where(data4sc_timed.(i) gt data4sc.(i).(0)(test(k)) and data4sc_timed.(i) lt data4sc.(i).(0)(test(k)+1),cnt)

       if cnt gt 0 then data_flag_arr(idx)=1
          no_data_flag=where(data_flag_arr eq 1,cc)
          data4sc_timed.(i+4)(no_data_flag,*)=-99
      endfor
    endif
print,'-------done'
endfor
data_reset=data4sc_timed

have_data:

;********************************************ALL DATAREADING FINISHED HERE
data4sc_timed=data_reset
 found_error:
  control.sc_id = sc_id 
  control.smooth = smooth
;***********************************now have RAPID data for required time period


RAPID_tai_time=data4sc_timed.TIME1+tai_start

eph_data=input_data    
eph_epoch=eph_data.EPOCH;eph data epoch values
eph_tai=(eph_epoch/1000.0)+time_diff

;*********************************************find L_values in cluster_eph
    tags=tag_names(eph_data)
    pos=strpos(tags,'L_VALUE')
    idx =where(pos ne -1,c)

;*****************************setup loop which creates interpolated eph L values for each s/c
;**************************************************interpolated to RAPID data time

;***************8loops for each spacecraft

size_T=size(data4sc_timed.TIME1)
size_L=size(eph_data.(idx(0)))
CL_LVALUES=dblarr(4,size_L(1))
CL_LVALUES_INTERP=dblarr(4,size_T(1))

orbit_numbers=size_T
orbit_numbers=interpol(eph_data.(1),eph_tai,RAPID_tai_time)
 flags=bytarr(size_L(1))

 for i=0,3 do begin
    CL_LVALUES(i,*)=eph_data.(idx(i)) 
    idx1=where (CL_LVALUES(i,*) eq -1, c)
    if c gt 0 then  flags(idx1)=1
    new_flags=interpol(flags,eph_tai,RAPID_tai_time)
    idx2 =where(new_flags gt 0,cc)
    CL_LVALUES_INTERP(i,*)=interpol(CL_LVALUES(i,*),eph_tai,RAPID_tai_time)
    if cc gt 0 then  CL_LVALUES_INTERP(i,idx2) = -1
 endfor

;**********************************************8sort out data into inbound and outbound passes 
;************************************************do single orbit analysis for min value of L
  CL_ORBIT_VALUES=fltarr(size_T(1))
  CL_ORBIT_VALUES=interpol(eph_data.(1),eph_tai,RAPID_tai_time)
orbits=fix(cl_orbit_values(n_elements(cl_orbit_values)-1))-fix(cl_orbit_values(0))

;***************************************find positions of apogee's thruout orbit number values
apogee_pos=fltarr(orbits+1)
min_l=fltarr(4,orbits)
min_l_pos=fltarr(4,orbits)
apogee_pos(0)=0
apogee_pos(orbits)=(n_elements(CL_ORBIT_VALUES)-1)

 for i=1,orbits-1 do begin
  test_apogee=strpos(string(CL_ORBIT_VALUES),string(start_apogee+i))
  test_apogee_real=where(test_apogee ne -1,c)
  apogee_pos(i)=test_apogee_real(0)
 endfor

 for j=0,3 do begin
  for i=1,orbits do begin
    test=(CL_LVALUES_INTERP(j,(apogee_pos(i-1)):(apogee_pos(i))))
    test_1=where(test ne -1,counts1)
     min_l(j,i-1)=min(test(test_1),min_pos) 
    min_l_pos(j,i-1)=apogee_pos(i-1)+test_1(min_pos)
  endfor
 endfor

;************************************************set up inbound - outbound selection

dummy_channels={in_pass:fltarr(6),out_pass:fltarr(6)}
dummy_lut={LUT_IN:fltarr(1),LUT_OUT:fltarr(1)}
dummy_11={IN_PASS:fltarr(2),OUT_PASS:fltarr(2),tai_in_pass:fltarr(2),tai_out_pass:fltarr(2),MIN_L:fltarr(1),av_ch:dummy_channels,av_ch_err:dummy_channels,LUT:dummy_lut}
dummy_22={CL1:dummy_11,CL2:dummy_11,CL3:dummy_11,CL4:dummy_11}
inbound_outbound_info=replicate(dummy_22,orbits)

;----------------------------------------------------------------------------------------------------------
for i=0,3 do begin

for j=0,(orbits-1) do begin

inbound_outbound_info(j).(i).IN_PASS(0)=apogee_pos(j)
inbound_outbound_info(j).(i).OUT_PASS(1)=apogee_pos(j+1)
inbound_outbound_info(j).(i).IN_PASS(1)=min_l_pos(i,j)
inbound_outbound_info(j).(i).OUT_PASS(0)=min_l_pos(i,j)
inbound_outbound_info(j).(i).MIN_L=min_l(i,j)
endfor

endfor

L_start_in=fltarr(4,orbits)
L_stop_in=fltarr(4,orbits)
L_index_mark_in=0
L_index_mark_out=0
new_inbound_outbound_info=inbound_outbound_info


 for k=0,orbits-1 do begin

  for j=0,3 do begin

   start_in=inbound_outbound_info(k).(j).IN_PASS(0) ;start index for inbound pass
   stop_in=inbound_outbound_info(k).(j).IN_PASS(1) ;end index for inboundpass

   INPASS=CL_LVALUES_INTERP(j,start_in:stop_in)  ;range of L values for given start:stop for inbound
   L_index_in = where ((INPASS GE LMIN) and (INPASS LE LMAX),cc)

   ;******************************************************************assume no breaks in index,ie continuous data
   ;*****************************************************************re-write inpass start stops in terms of L range
   inbound_outbound_info(k).(j).IN_PASS(0)=start_in+(L_index_in(0))
   inbound_outbound_info(k).(j).IN_PASS(1)=start_in+(L_index_in(n_elements(L_index_in)-1))
   inbound_outbound_info(k).(j).tai_in_pass(0)=RAPID_TAI_TIME(inbound_outbound_info(k).(j).IN_PASS(0))
   inbound_outbound_info(k).(j).tai_in_pass(1)=RAPID_TAI_TIME(inbound_outbound_info(k).(j).IN_PASS(1))
   start_out=inbound_outbound_info(k).(j).OUT_PASS(0) ;start index for inbound pass
   stop_out=inbound_outbound_info(k).(j).OUT_PASS(1) ;end index for inboundpass
   OUTPASS=CL_LVALUES_INTERP(j,start_out:stop_out);range of L values for given start:stop
   L_index_out = where ((OUTPASS GE LMIN) and (OUTPASS LE LMAX),cc)
   inbound_outbound_info(k).(j).OUT_PASS(0)=start_out+(L_index_out(0))
   inbound_outbound_info(k).(j).OUT_PASS(1)=start_out+(L_index_out(n_elements(L_index_out)-1))
   inbound_outbound_info(k).(j).tai_out_pass(0)=RAPID_TAI_TIME(inbound_outbound_info(k).(j).OUT_PASS(0))
   inbound_outbound_info(k).(j).tai_out_pass(1)=RAPID_TAI_TIME(inbound_outbound_info(k).(j).OUT_PASS(1))
 
  endfor
endfor
;**------------------------****---------------------------****----------------------------------**

dmy1={pass:0, in_out:0, lrange:fltarr(2),av_counts:fltarr(4,6)}
found=0

for pass=0,n_elements(inbound_outbound_info)-1 do begin
for in_out =0,1 do begin

lrange=[lmin,lmin+lstep]


while lrange(1) le lmax do begin
   c=fltarr(4,ch)
  for sc=0,3 do begin
   for channel=0,ch-1 do begin
      ir=inbound_outbound_info(pass).(sc).(in_out)

      idx=where(((CL_LVALUES_INTERP(sc,ir(0):ir(1)) ge lrange(0)) and (CL_LVALUES_INTERP(sc,ir(0):ir(1)) le lrange(1))) and (data4sc_timed.(sc+8)(ir(0):ir(1)) eq lut), count)

      if count ne 0 then begin
    
          dummy=data4sc_timed.(sc+4)(ir(0):ir(1),channel)
          cnts=dummy(idx)
          ;***************************************************************** check bad data!
          flags_data=fltarr(n_elements(cnts))
          idx_zero=where(cnts eq 0,ccc)
          idx_time_gap=where(cnts eq -99,chount)
          idx_spike=where(cnts ge data_spike_ceiling,cccc)
        if ccc gt 0 then flags_data(idx_zero)=1; index zero data and write to flag_data
        if cccc gt 0 then flags_data(idx_spike)=1;index  spike data and write to flag_data
        if chount gt 0 then flags_data(idx_time_gap)=1;index nodata points (=-99)and write to flag_data
        idx_good_data=where(flags_data eq 0,ccccc); write non- spike,-zero and -no-data index
        if ccccc gt 0 then cnts=cnts(idx_good_data)
        if ccccc eq 0 then cnts =0
        c(sc,channel)=total(cnts)/count
       endif
 
  endfor
  endfor
   idx=where(c eq 0,count)

   if count eq 0 then begin
;       print,'pass ',varprt(pass),' in/out ',varprt(in_out), ', match for lut ', varprt(lut), ', L range: ',lrange
;       print, c  
       dmy1.pass=pass
       dmy1.in_out=in_out
       dmy1.lrange=lrange
       dmy1.av_counts=c
       if found eq 0 then intcal_matches=[dmy1] else intcal_matches=[intcal_matches,dmy1]
       found=found+1
   endif
   lrange=lrange+lstep
endwhile

endfor
endfor


;********************************************************write final struture info. add start stop times,lstep, lrange and lut
;*****************************************************************************values
;to intcal_matches

st_orbit_and_time={start_orbit:start_orbit,start_time:start_start} 
stp_orbit_and_time={stop_orbit:stop_orbit,stop_time:end_end}
L_RANGE=[LMIN,LMAX]
dummy11={L_step:lstep,lrange:L_RANGE,LUT_VALUE:lut,start_time:starttime,stop_time:endtime,start_orbit_and_time:st_orbit_and_time,stop_orbit_and_time:stp_orbit_and_time,orbits:orbits}

intercal_info={intcal_matches:intcal_matches,file_data:dummy11}

stop
;save,intercal_info,FILENAME='intercal_data.dat'

stop
;call plotting pro
;cluster_rapid_sc_intercal_plot,intercal_info

stop
END












;**************************************************************************************************************************
;* PROCEDURE         
;*      PRO papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_values
;*                                                                     
;*
;* DESCRIPTION:  carry out an interspacecraft comparison for each IES energy.
;*
;*
;*do fitting for each energy channel for 6 sc combinations, gives 36
;*best fit lines.  
;*
;*
;*OUTPUT: fit_values, [2,sc_combinations,energy_channel,(inbound,outbound)] array
;*containing slope and intercept of
;*bestfit values
;*                                                           
;*
;*   !p.position = 0
;*   !P.REGION = 0
;*   !p.multi = [0, 3, 3, 0, 0]
;*   !X.margin = [6, 6]
;* 
;*  !Y.margin = [5, 5]
;*   !Y.ticks=0 & !X.ticks=0 
;*
;*
;***************************************************************************************************************************

pro papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_values

;***********************;***********************************************
;***********************************************
intcal_matches=new_intercal_info.intcal_matches

dummy11={fit_slope:0.0d,fit_intercept:0.0d,fit_chisq:0.0d,fit_conf68:dblarr(2),fit_conf95:dblarr(2),fit_conf99:dblarr(2)}
dummy22={ch1:dummy11, ch2:dummy11,ch3:dummy11,ch4:dummy11,ch5:dummy11,ch6:dummy11}
fit_values_arr={sc1_sc2:dummy22,sc1_sc3:dummy22,sc1_sc4:dummy22,sc2_sc3:dummy22,sc2_sc4:dummy22,sc3_sc4:dummy22}

sc_1_data=intcal_matches.av_counts(0,*,*)
sc_1_data_err=sqrt(sc_1_data)

sc_2_data=intcal_matches.av_counts(1,*,*)
sc_2_data_err=sqrt(sc_2_data)

sc_3_data=intcal_matches.av_counts(2,*,*)
sc_3_data_err=sqrt(sc_3_data)

sc_4_data=intcal_matches.av_counts(3,*,*)
sc_4_data_err=sqrt(sc_4_data)

ch=n_elements(intcal_matches(0).AV_COUNTS(0,*)) 
titstr=''
;guess_slope=1
;errorpercent=.06




for i=0,(ch-1) do begin


;-----------------------------sc1sc2
;-----------------------------------
;************************************
gen_fit_release,x=sc_1_data(0,i,*),sigma_x=sc_1_data_err(0,i,*),y=sc_2_data(0,i,*),sigma_y=sc_2_data_err(0,i,*),n_iterations=n_iterations, $
                     titstr=titstr, $ 
                     nparms=nparms, $ 
                     guess_slope=guess_slope,$   
                     errorpercent=errorpercent, $ 
                     slope=slope, intercept=intercept, $ 
                     chisq=chisq, rchisq=rchisq, $ 
                     s2=s2, $ 
                     c68=c68, c95=c95, c99=c99,$
                     ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
                     force_kappa_search=force_kappa_search,$
                     ks_range_degrees= ks_range_deg, $
                     renormalize=renormalize, $
                     verbose=verbose,$ 
                     kappa_picture=kappa_picture,$
                     print=print,$ 
                     itime=itime,$ 
                     kappa_data=kappa_data,$
                     status=status, $
                     info = info

fit_values_arr.sc1_sc2.(i).fit_slope=slope
fit_values_arr.sc1_sc2.(i).fit_intercept=intercept
fit_values_arr.sc1_sc2.(i).fit_chisq=chisq
fit_values_arr.sc1_sc2.(i).fit_conf68=c68
fit_values_arr.sc1_sc2.(i).fit_conf95=c95
fit_values_arr.sc1_sc2.(i).fit_conf99=c99

;***********************************


;-----------------------------sc1sc3
;-----------------------------------
;************************************
gen_fit_release,x=sc_1_data(0,i,*),sigma_x=sc_1_data_err(0,i,*),y=sc_3_data(0,i,*),sigma_y=sc_3_data_err(0,i,*),n_iterations=n_iterations, $
                     titstr=titstr, $ 
                     nparms=nparms, $ 
                     guess_slope=guess_slope,$   
                     errorpercent=errorpercent, $ 
                     slope=slope, intercept=intercept, $ 
                     chisq=chisq, rchisq=rchisq, $ 
                     s2=s2, $ 
                     c68=c68, c95=c95, c99=c99,$
                     ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
                     force_kappa_search=force_kappa_search,$
                     ks_range_degrees= ks_range_deg, $
                     renormalize=renormalize, $
                     verbose=verbose,$ 
                     kappa_picture=kappa_picture,$
                     print=print,$ 
                     itime=itime,$ 
                     kappa_data=kappa_data,$
                     status=status, $
                     info = info

fit_values_arr.sc1_sc3.(i).fit_slope=slope
fit_values_arr.sc1_sc3.(i).fit_intercept=intercept
fit_values_arr.sc1_sc3.(i).fit_chisq=chisq
fit_values_arr.sc1_sc3.(i).fit_conf68=c68
fit_values_arr.sc1_sc3.(i).fit_conf95=c95
fit_values_arr.sc1_sc3.(i).fit_conf99=c99

;***********************************


;-----------------------------sc1sc4
;-----------------------------------
;************************************
gen_fit_release,x=sc_1_data(0,i,*),sigma_x=sc_1_data_err(0,i,*),y=sc_4_data(0,i,*),sigma_y=sc_4_data_err(0,i,*),n_iterations=n_iterations, $
                     titstr=titstr, $ 
                     nparms=nparms, $ 
                     guess_slope=guess_slope,$   
                     errorpercent=errorpercent, $ 
                     slope=slope, intercept=intercept, $ 
                     chisq=chisq, rchisq=rchisq, $ 
                     s2=s2, $ 
                     c68=c68, c95=c95, c99=c99,$
                     ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
                     force_kappa_search=force_kappa_search,$
                     ks_range_degrees= ks_range_deg, $
                     renormalize=renormalize, $
                     verbose=verbose,$ 
                     kappa_picture=kappa_picture,$
                     print=print,$ 
                     itime=itime,$ 
                     kappa_data=kappa_data,$
                     status=status, $
                     info = info

fit_values_arr.sc1_sc4.(i).fit_slope=slope
fit_values_arr.sc1_sc4.(i).fit_intercept=intercept
fit_values_arr.sc1_sc4.(i).fit_chisq=chisq
fit_values_arr.sc1_sc4.(i).fit_conf68=c68
fit_values_arr.sc1_sc4.(i).fit_conf95=c95
fit_values_arr.sc1_sc4.(i).fit_conf99=c99

;***********************************


;-----------------------------sc2sc4
;-----------------------------------
;************************************
gen_fit_release,x=sc_2_data(0,i,*),sigma_x=sc_2_data_err(0,i,*),y=sc_4_data(0,i,*),sigma_y=sc_4_data_err(0,i,*),n_iterations=n_iterations, $
                     titstr=titstr, $ 
                     nparms=nparms, $ 
                     guess_slope=guess_slope,$   
                     errorpercent=errorpercent, $ 
                     slope=slope, intercept=intercept, $ 
                     chisq=chisq, rchisq=rchisq, $ 
                     s2=s2, $ 
                     c68=c68, c95=c95, c99=c99,$
                     ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
                     force_kappa_search=force_kappa_search,$
                     ks_range_degrees= ks_range_deg, $
                     renormalize=renormalize, $
                     verbose=verbose,$ 
                     kappa_picture=kappa_picture,$
                     print=print,$ 
                     itime=itime,$ 
                     kappa_data=kappa_data,$
                     status=status, $
                     info = info

fit_values_arr.sc2_sc4.(i).fit_slope=slope
fit_values_arr.sc2_sc4.(i).fit_intercept=intercept
fit_values_arr.sc2_sc4.(i).fit_chisq=chisq
fit_values_arr.sc2_sc4.(i).fit_conf68=c68
fit_values_arr.sc2_sc4.(i).fit_conf95=c95
fit_values_arr.sc2_sc4.(i).fit_conf99=c99
;***********************************

;-----------------------------sc2sc3
;-----------------------------------
;************************************
gen_fit_release,x=sc_2_data(0,i,*),sigma_x=sc_2_data_err(0,i,*),y=sc_3_data(0,i,*),sigma_y=sc_3_data_err(0,i,*),n_iterations=n_iterations, $
                     titstr=titstr, $ 
                     nparms=nparms, $ 
                     guess_slope=guess_slope,$   
                     errorpercent=errorpercent, $ 
                     slope=slope, intercept=intercept, $ 
                     chisq=chisq, rchisq=rchisq, $ 
                     s2=s2, $ 
                     c68=c68, c95=c95, c99=c99,$
                     ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
                     force_kappa_search=force_kappa_search,$
                     ks_range_degrees= ks_range_deg, $
                     renormalize=renormalize, $
                     verbose=verbose,$ 
                     kappa_picture=kappa_picture,$
                     print=print,$ 
                     itime=itime,$ 
                     kappa_data=kappa_data,$
                     status=status, $
                     info = info

fit_values_arr.sc2_sc3.(i).fit_slope=slope
fit_values_arr.sc2_sc3.(i).fit_intercept=intercept
fit_values_arr.sc2_sc3.(i).fit_chisq=chisq
fit_values_arr.sc2_sc3.(i).fit_conf68=c68
fit_values_arr.sc2_sc3.(i).fit_conf95=c95
fit_values_arr.sc2_sc3.(i).fit_conf99=c99
;**********************************

;-----------------------------sc3sc4
;-----------------------------------
;************************************
gen_fit_release,x=sc_3_data(0,i,*),sigma_x=sc_3_data_err(0,i,*),y=sc_4_data(0,i,*),sigma_y=sc_4_data_err(0,i,*),n_iterations=n_iterations, $
                     titstr=titstr, $ 
                     nparms=nparms, $ 
                     guess_slope=guess_slope,$   
                     errorpercent=errorpercent, $ 
                     slope=slope, intercept=intercept, $ 
                     chisq=chisq, rchisq=rchisq, $ 
                     s2=s2, $ 
                     c68=c68, c95=c95, c99=c99,$
                     ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
                     force_kappa_search=force_kappa_search,$
                     ks_range_degrees= ks_range_deg, $
                     renormalize=renormalize, $
                     verbose=verbose,$ 
                     kappa_picture=kappa_picture,$
                     print=print,$ 
                     itime=itime,$ 
                     kappa_data=kappa_data,$
                     status=status, $
                     info = info
sc3_sc4_slope=slope
sc3_sc4_intercept=intercept

fit_values_arr.sc3_sc4.(i).fit_chisq=chisq
fit_values_arr.sc3_sc4.(i).fit_slope=slope
fit_values_arr.sc3_sc4.(i).fit_intercept=intercept
fit_values_arr.sc3_sc4.(i).fit_conf68=c68
fit_values_arr.sc3_sc4.(i).fit_conf95=c95
fit_values_arr.sc3_sc4.(i).fit_conf99=c99
;***********************************
endfor
fit_values=fit_values_arr
;now have fit_valuesfor six sc combinations

;***************************************************************************************

END





;*************************************************************************************
;* PROCEDURE
;*      PRO papco_cluster_rapid_sc_intercal_plot,intcal_matches,LMIN,LMAX,LUT
;* DESCRIPTION:  
;*      code reads in cleaned data from
;*       papco_cluster_rapid_sc_intercal.pro and plots spacecraft vs
;*       spacecraft comparisons. energy channels are colour coded
;*     
;* INPUTS:       
;*      intcal_matches, clean, no data spike or zero count data structure
;*      LMIN and LMAX Lrange values.
;*      LUT= RAPID integration mode
;*  
;* KEYWORDS:
;*  
;* OUTPUT:	 
;*    6 sc vs sc plots 
;****************************************************************************

;pro cluster_rapid_sc_intercal_plot,intcal_matches,LMIN,LMAX,LUT

;common papco_color_names

;COMMON cluster_eph_data, input_header, input_data
;COMMON cluster_rapid_slice_1, time, zmat, data, yarr, utitle, uytitle, uztit
;COMMON cluster_rapid
;COMMON mjdt, mjdt_start, mjdt_end
;COMMON get_error, get_err_no, get_err_msg
;;COMMON cluster_rapid_4sc, data4sc_timed

;papco,/set_only

;*************plotting sections
;ascertain max counts for scaling
;max_counts=dblarr(4)
;for i=0,3 do  begin
;counts=intcal_matches.(0).AV_COUNTS(i,*,*)
;max_counts(i)=max(max(counts))
;endfor
;max_counts=max(max_counts)
;if max_counts gt 100000 then begin
; print, 'high counts'
;max_counts=3000
;endif
;xrange=[0,max_counts]
;yrange=xrange
;LMIN=intcal_matches.FILE_DATA.LRANGE(0)
;LMAX=intcal_matches.FILE_DATA.LRANGE(1)
;LUT=intcal_matches.FILE_DATA.LUT_VALUE;


;LMIN=strcompress(string(LMIN))
;LMAX=strcompress(string(LMAX))
;LUT=strcompress(string(LUT))


;size_arr=size(intercal_arr)
;range=(size_arr(1))-1
;ch=5
;***************************************************************************************************************************
;window,0,title='CLUSTER 1 - CLUSTER 2 RAPID counts comparison, L range = '+LMIN+' - '+LMAX+',LUT ='+LUT
; for i=0,ch do begin
; plot,intcal_matches.(0).AV_COUNTS(0,i),intcal_matches.(0).AV_COUNTS(1,i),psym=4,xrange=xrange,yrange=yrange,xtitle='sc1',ytitle='sc2',color=(black+i) 
; endfor
; plots,xrange,yrange


;window,1,title='CLUSTER 1 - CLUSTER 3 RAPID counts comparison, L range = '+LMIN+' - '+LMAX+',LUT ='+LUT
;for i=0,ch do begin
; plot,intcal_matches.(0).AV_COUNTS(0,i),intcal_matches.(0).AV_COUNTS(2,i),psym=4,xrange=xrange,yrange=yrange,xtitle='sc1',ytitle='sc2',color=(black+i) 
;endfor
;plots,xrange,yrange

;window,2,title='CLUSTER 1 - CLUSTER 4 RAPID counts comparison, L range = '+LMIN+' - ' +LMAX+',LUT ='+LUT
;for i=0,ch do begin
;; plot,intcal_matches.(0).AV_COUNTS(0,i),intcal_matches.(0).AV_COUNTS(3,i),psym=4,xrange=xrange,yrange=yrange,xtitle='sc1',ytitle='sc2',color=(black+i) 

;endfor
;plots,xrange,yrange


;window,3,title='CLUSTER 2 - CLUSTER 3 RAPID counts comparison, L range = '+LMIN+' - ' +LMAX+',LUT ='+LUT
;for i=0,ch do begin
; plot,intcal_matches.(0).AV_COUNTS(1,i),intcal_matches.(0).AV_COUNTS(2,i),psym=4,xrange=xrange,yrange=yrange,xtitle='sc1',ytitle='sc2',color=(black+i) 
;endfor
;plots,xrange,yrange


;window,4,title='CLUSTER 2 - CLUSTER 4 RAPID counts comparison, L range = '+LMIN+' - ' +LMAX+',LUT ='+LUT
;for i=0,ch do begin
; plot,intcal_matches.(0).AV_COUNTS(1,i),intcal_matches.(0).AV_COUNTS(3,i),psym=4,xrange=xrange,yrange=yrange,xtitle='sc1',ytitle='sc2',color=(black+i) 
;endfor
;plots,xrange,yrange


;window,5,title='CLUSTER 3 - CLUSTER 4 RAPID counts comparison, L range = '+LMIN+' - ' +LMAX+',LUT ='+LUT
;for i=0,ch do begin

; plot,intcal_matches.(0).AV_COUNTS(2,i),intcal_matches.(0).AV_COUNTS(3,i),psym=4,xrange=xrange,yrange=yrange,xtitle='sc1',ytitle='sc2',color=(black+i) ;

;endfor
;plots,xrange,yrange



;***************************************************************************************************************************

;stop
;END




















;*******************************************************
;***********************************************************
;STUFF CUT FROMINTERCAL PRO 

;---------------------------------------------------------------------------------------------------
;test to see if s/c for each pass are in same integration mode (LUT);
;taken out due to previous analysis
;**********************8
;test_str=strarr(2,4,orbits)
;for j=0,3 do begin
; for i=0,(orbits-1) do begin
;   LUT_check_in=data4sc_timed.(j+5)((inbound_outbound_info(i).(j).IN_PASS(0)):(inbound_outbound_info(i).(j).IN_PASS(1)))   
;   LUT_check_out=data4sc_timed.(j+5)((inbound_outbound_info(i).(j).OUT_PASS(0)):(inbound_outbound_info(i).(j).OUT_PASS(1)))  
;print,LUT_check_in(0)
;print,LUT_check_out(0)
;   test_str(0,j,i)=string(LUT_check_in(0))
;   test_str(1,j,i)=string(LUT_check_out(0))
;   result_in=strcmp(LUT_check_in,test_str(0,j,i),c)
;   result_out=strcmp(LUT_check_out,test_str(1,j,i),cc)
;   result_1=where(result_in ne 1,c)
;   result_2=where(result_out ne 1,cc)
;if c ne 0 then begin
;      print,'!!!!!!!!!!!!!!!!!!!IN BOUND LUT change!!!!!!!!!!!!!!CL',j
;      inbound_outbound_info(i).(j).LUT.LUT_IN=  -1;LUT CHANGE
;  endif
;if cc ne 0 then begin
;      print,'!!!!!!!!!!!!!!!!!!!OUT BOUND LUT change!!!!!!!!!!!!!!CL',j
;      inbound_outbound_info(i).(j).LUT.LUT_OUT= -1;LUT CHANGE
;  endif
;if c eq 0 then begin
;      inbound_outbound_info(i).(j).LUT.LUT_IN= test_str(0,j,i)
;  endif
;if cc eq 0 then begin
;      inbound_outbound_info(i).(j).LUT.LUT_OUT= test_str(1,j,i)
;  endif
;endfor
;endfor
;;;;;;;;;DIFFERENT LUT VALUES FOR DIFFERENT ORBITS or passes not handled....
;;maybe index most frequently occuring LUT?
;;

;**************************************************************************************************************************
;***************************************************************strip zeros and spikes
;* need to get rid of zero data values
;* also need to handle data spikes so....
;* Search for 0 values in av_ch sub array
;* also search for 'data spikes', set abitrary ceiling over which one
;* expects data spikes to be above 
;spike_ceiling=20000
;set up structure to hold flags of zeros and data spike values
;
;   for i=0,(orbits-1) do begin
;        for j=0,3 do begin
;             for k=0,(ch-1) do begin
;               data_pass_in=data4sc_timed.(1+j)( inbound_outbound_info(i).(j).(0)(0): inbound_outbound_info(i).(j).(0)(1),k)
;               data_pass_out=data4sc_timed.(1+j)( inbound_outbound_info(i).(j).(1)(0): inbound_outbound_info(i).(j).(1)(1),k)
;               flags_in=fltarr(n_elements(data_pass_in))
;               flags_out=fltarr(n_elements(data_pass_out))
;               test_non_zero_in=where(data_pass_in eq 0,c)
;               test_data_spike_in=where(data_pass_in gt spike_ceiling,cc)
;               test_non_zero_out=where(data_pass_out eq 0,ccc)
;               test_data_spike_out=where(data_pass_out gt spike_ceiling,cccc)
;                if c ne 0 then flags_in(test_non_zero_in)=1
;                if cc ne 0 then flags_in(test_data_spike_in)=1
;                if ccc ne 0 then flags_out(test_non_zero_out)=1
;                if cccc ne 0 then flags_out(test_data_spike_out)=1
;                idx_in=where(flags_in eq 0)
;                idx_out=where(flags_out eq 0)
;                inbound_outbound_info(i).(j).AV_CH.IN_PASS(k)=mean(data_pass_in(idx_in))
;                inbound_outbound_info(i).(j).AV_CH.OUT_PASS(k)=mean(data_pass_in(idx_out))
;                inbound_outbound_info(i).(j).AV_CH_ERR.IN_PASS(k)=mean(sqrt(data_pass_in(idx_in)))
;                inbound_outbound_info(i).(j).AV_CH_ERR.OUT_PASS(k)=mean(sqrt(data_pass_in(idx_out)))
;             endfor
;       endfor
;   endfor
;*************************************************************************************************************************
;index most commonly occuring LUT value or chosen LUT value******************
;have takenthis out due to L range analysis carried out previously  
; if LUT_VALUE eq 0 then begin
;   LUT_check=fltarr(4,2,orbits)
;  for j=0,3 do begin
;    LUT_check(j,0,*)=inbound_outbound_info.(j).LUT.LUT_IN
;    LUT_check(j,1,*)=inbound_outbound_info.(j).LUT.LUT_OUT
;  endfor
;   mode_LUT=HISTOGRAM(LUT_check,MIN=0,OMIN=O_MIN,OMAX=O_MAX)
;   mode_LUT_VALUE=max(mode_LUT,max_subs)
;   LUT_VALUE=max_subs+O_MIN
; endif
;     LUT_INDEX=fltarr(orbits);
;   for j=0,3 do begin
;       LUT_check_inbound=where(inbound_outbound_info.(j).LUT.LUT_IN ne LUT_VALUE,c)
;        if c ne 0 then LUT_INDEX(LUT_check_inbound)=1
;          LUT_check_outbound=where(inbound_outbound_info.(j).LUT.LUT_OUT ne LUT_VALUE,cc)
;        if cc ne 0 then LUT_INDEX(LUT_check_outbound)=1
;   endfor
;lut_idx=where(LUT_index ne 1,countz)
;new_inbound_outbound_info=inbound_outbound_info(lut_idx)
;******************************************************************************************************************8
