;*program to carry out timing analysis on RAPID data
;matt TAylor 30 jan 2003
; USes write panel data to obtain 4 sc times.
; to use, use intercal or timing 4sc options and then use slice
; options write panel data.
; then simple write time in hr:mn:sc format and put in an array:

;boundarytime=[12:10:00,12:13:03,12:11:02,12:09:55]
;then simply compile this program and type TIMING_4sc_calc, boundarytime
;*******************************************************
;normal and vel will appear at command line and can be obtained from
;plot by clicking right most icona nd clickking on normal vector
;diplayed on 3dplot
;
;******************************************************************************************************************************************88
;********************************************************************************
;********************************************************************************
;***              timing calculATION                                          ***
;***            MATT TAYLOR    JAN  2003 LANL                                 ***
;***    Using Harvey method, least squared calculation  of                    ***
;***             interspacecraft timing                                       ***
;***                                                                          ***
;********************************************************************************

PRO papco_cluster_timing,boundtime, sc_pos_rel_sc1
;COMMON gradiometer_calc
common cluster_rapid_data, input_header, input_data
COMMON RAPID_timing_correl, timing_stamps, actual_bnd_times
common cluster_rapid_4sc, data4sc_timed
common cluster_rapid_slice_1, time, zmat, data, yarr, utitle, uytitle, uztit
common cluster_rapid
common cluster_eph_data, eph_header, eph_data
common mjdt, mjdt_start, mjdt_end     ;common time limit in mjdt
COMMON sc_positions, sc_positions

r_cluster_eph


;get TAI of papco start time of plot
convert_t90_to_date, mjdt_start, yr,doy,hr,min,sec,mo,cmo,dom, /mjdt

tai_1=UTC2TAI({YEAR:yr, MONTH:mo, DAY:dom, HOUR:hr, MINUTE:min,   SECOND:sec, MILLISECOND:0})



;boundtime = ['11:10:12', '11:10:30', '11:11:00', '11:12:01']
sc_time = strarr(4, 3)
bound_hour = intarr(4)
bound_min = intarr(4)
bound_sec = intarr(4)
boundary = intarr(4)
tai_bound = dblarr(4)
FOR i = 0, 3 DO BEGIN
sc_time(i, *) = strsplit(boundtime(i), ':', /extract)
bound_hour(i) =fix(sc_time(i, 0))
bound_min(i) = fix(sc_time(i, 1))
bound_sec(i) = fix(sc_time(i, 2))
tai_bound(i)=UTC2TAI({YEAR:yr, MONTH:mo, DAY:dom, HOUR:bound_hour(i),MINUTE:bound_min(i), SECOND:bound_sec(i), MILLISECOND:0})

endfor
;tai_bound is time in tai of ==boundary crossings


;get CDF epoch of papco start time of plot
CDF_EPOCH,epoch_1, yr, mo, dom, hr, min, sec, 0, /COMPUTE_EPOCH

convert_t90_to_date, mjdt_end, yr,doy,hr,min,sec,mo,cmo,dom, /mjdt
tai_2=UTC2TAI({YEAR:yr, MONTH:mo, DAY:dom, HOUR:hr, MINUTE:min, $
                 SECOND:sec, MILLISECOND:0})

;cdf epoch is in milliseconds since 01 Jan 00:00:00.000
offset = tai_1-(epoch_1/1000.0);offset between start time of plot and epoch time

;4sc time is in TAI

;data4sc_timed.time = data4sc_timed.time+tai_1
;tai_4sc = (data4sc_timed.time(*, 0)+data4sc_timed.time(*, 1)) /2.0

;EPH is in CDF EPOCH time 
tai_eph=(eph_data.EPOCH)/1000.0+offset

;print, tai2utc(tai_4sc(0), /ecs)
;print, tai2utc(tai_eph(0), /ecs)
;reduce eph time to papco start end

;must test if start end times are greater than eph resolution ie 5
;minutes, here we test if diff is greater than 6 minutes
tai_diff = tai_2-tai_1
IF tai_diff LT 360 THEN BEGIN
tai_old_1 = tai_1
tai_old_2 = tai_2
tai_1_MOD = tai_1-180
tai_2_MOD = tai_2+180
tai_1 = tai_1_MOD
tai_2 = tai_2_MOD
end

index = where((tai_eph GE tai_1) AND (tai_eph LE tai_2), count)
IF count EQ 0 THEN message, 'no eph data found' ELSE message,  'eph data loaded', /continue

;*do set interpolation of eph, identify time steps, then interpolate
;to 1 or 4 sec resolution
;* then take boundary times and get indexes for four times 
;* read out 4 sc positions at times.
;* bob
;****here i am assuming eph data is 5 min resolution
;* only output boundary times, not entire time series to save time
;***************this bit makes sure time window for eph data is at
;least 30 minutes (if eph res is five minutes

index_size = size(index)
interp_index_1 = index(0)
interp_index_2 = index(index_size(1)-1)
interp_window_extend = 2

IF count LE 5 then BEGIN
interp_index_1 =index(0)-interp_window_extend
interp_index_2 =index(index_size(1)-1)+interp_window_extend
ENDIF
interp_window_extend = (interp_index_2-interp_index_1 +1)
new_index = intarr(interp_window_extend)
interp_index = interp_index_1
i = 0
WHILE (interp_index LE interp_index_2) DO begin
new_index(i) = interp_index
interp_index = interp_index+1
i = i+1
END
;******************************************************
;* *****************now to interpolate eph data to 1 second resolution
;* eph data at 5 min res. 5 minute = 300 seconds
size_new_index = size(new_index)
size_new_index = size_new_index(1)
new_interp_index_size = 300*(size_new_index-1)+1
eph_data_4sc = eph_data(new_index)
new_tai_eph = tai_eph(new_index)

ref_sc_pos = eph_data_4sc.sc_r_xyz_gse
delta_sc1 = eph_data_4sc.sc_dr1_xyz_gse
delta_sc2 = eph_data_4sc.sc_dr2_xyz_gse
delta_sc3 = eph_data_4sc.sc_dr3_xyz_gse
delta_sc4 = eph_data_4sc.sc_dr4_xyz_gse

sc1_pos = ref_sc_pos + delta_sc1
sc2_pos = ref_sc_pos + delta_sc2
sc3_pos = ref_sc_pos + delta_sc3
sc4_pos = ref_sc_pos + delta_sc4

size_arr = new_interp_index_size
sc1_ipos =dblarr(3, size_arr)
sc2_ipos =dblarr(3, size_arr)
sc3_ipos =dblarr(3, size_arr)
sc4_ipos =dblarr(3, size_arr)
sci_tai = dblarr(size_arr)
;interpolate spacecraft position on to same res as time (ie 4 seconds)

sci_tai     = INTERPOL(new_tai_eph,      size_arr, /spline)
sc1_ipos(0, *)= INTERPOL(sc1_pos(0, *), size_arr, /spline)
sc1_ipos(1, *)= INTERPOL(sc1_pos(1, *), size_arr, /spline)
sc1_ipos(2, *)= INTERPOL(sc1_pos(2, *), size_arr, /spline)

sc2_ipos(0, *)= INTERPOL(sc2_pos(0, *), size_arr, /spline)
sc2_ipos(1, *)= INTERPOL(sc2_pos(1, *), size_arr, /spline)
sc2_ipos(2, *)= INTERPOL(sc2_pos(2, *), size_arr, /spline)

sc3_ipos(0, *)= INTERPOL(sc3_pos(0, *), size_arr, /spline)
sc3_ipos(1, *)= INTERPOL(sc3_pos(1, *), size_arr, /spline)
sc3_ipos(2, *)= INTERPOL(sc3_pos(2, *), size_arr, /spline)

sc4_ipos(0, *)= INTERPOL(sc4_pos(0, *), size_arr, /spline)
sc4_ipos(1, *)= INTERPOL(sc4_pos(1, *), size_arr, /spline)
sc4_ipos(2, *)= INTERPOL(sc4_pos(2, *), size_arr, /spline)

interp_all_sc_pos =dblarr(4, 3, size_arr)

interp_all_sc_pos(0, *, *) = sc1_ipos
interp_all_sc_pos(1, *, *) = sc2_ipos
interp_all_sc_pos(2, *, *) = sc3_ipos
interp_all_sc_pos(3, *, *) = sc4_ipos

;tai_bound
tai_bound_utc =  tai2utc(tai_bound, /stime,/truncate) 
sci_tai_utc =  tai2utc(sci_tai, /stime,/truncate)
boundary_index = intarr(4)
r1_b_pos = dblarr(3, 4)
r2_b_pos = dblarr(3, 4)
r3_b_pos = dblarr(3, 4)
r4_b_pos = dblarr(3, 4)

FOR i = 0, 3 DO BEGIN
boundary_index(i) = where(tai_bound_utc(i) EQ sci_tai_utc, count);gives index for each boundary
r1_b_pos(*, i) = sc1_ipos(*, boundary_index(i))
r2_b_pos(*, i) = sc2_ipos(*, boundary_index(i))
r3_b_pos(*, i) = sc3_ipos(*, boundary_index(i))
r4_b_pos(*, i) = sc4_ipos(*, boundary_index(i))
ENDFOR

;*change boundary times into whole seconds
boundarytimes = fix(tai_bound)
mesotime = fix((boundarytimes(0)+boundarytimes(1)+boundarytimes(2)+boundarytimes(3))/4.0)


;* do two methods of timing as check, use simple method and least

;squares from HARVEY
;have indexes of boundary crossings at each spacecraft,
;:now calculate volumetric tensor
r1 = r1_b_pos
r2 = r2_b_pos
r3 = r3_b_pos
r4 = r4_b_pos

mesocentre = (r1+r2+r3+r4)/4.0
mesocentrecross = total(mesocentre, 2)/4.0

;**********************************************************************************
;*                                                                                *
;*                        Simple Timing Method                                    *
;*                   Using notation from Harvey                                   *
;********************************************************************************
;calculate relative distances between boundary crossing positions
;reference sc is arbitrary here we use sc 1
yes = 1
no = 0
r12=r2(*,1)-r1(*,0)
r13=r3(*,2)-r1(*,0)
r14=r4(*,3)-r1(*,0)
;relative boundary crossing times
t12=boundarytimes(1)-boundarytimes(0)
t13=boundarytimes(2)-boundarytimes(0)
t14=boundarytimes(3)-boundarytimes(0)
D=[[r12],[r13],[r14]]
T=[[t12],[t13],[t14]]
;m=n/V; where n is boudnary normal and V is boundary speed
invD=INVERT(D)
m=invD##T

mod_m=m(0)^2 +m(1)^2+m(2)^2
mod_m=sqrt(mod_m)
boundary_vel = 1/MOD_m
boundary_normal=m/mod_m


;**********************************************************************************
;*                       LEASTSQUARES boundary CALCULATION                        *
;*                                                                                *
;**********************************************************************************
;use least squares analysis technique from HARVEY 1998


; for four spacecraft analysis need to caluclate Volumetric tensor, a
; mathematical description of the dimensions of the tetrahedron

rr = dblarr(3, 4)
R = dblarr(3,3)
RA = dblarr(4,1)
invR = R
r_meso_check =dblarr (4, 3, size_arr)

rr(*, 0) = r1(*, 0)-mesocentrecross
rr(*, 1) = r2(*, 1)-mesocentrecross
rr(*, 2) = r3(*, 2)-mesocentrecross
rr(*, 3) = r4(*, 3)-mesocentrecross



N = 4.0;number of spacecraft
j = 0
k = 0
alpha = 0
message,  'CALCULATING VOLUMETRIC TENSOR FOR SELECTED TIME PERIOD', /continue
WHILE (j LE 2) DO begin
 WHILE (k LE 2) DO begin
  WHILE (alpha LE N-1) DO begin
  RA(alpha) = rr(j, alpha)*rr(k,alpha)
  alpha = alpha+1
  endwhile
 alpha = 0;
message, '.', /continue
;sumRrows = total(RA, 2);add  components up for each time step
R(j, k) = (1/N)*total(RA)
k = k+1
endwhile
k = 0
j = j+1
ENDWHILE
size_R = size(R)
nn = size_R(3)-1
FOR i = 0,nn, 1 DO begin

invR = invert(R)
ENDFOR
message,  'done', /continue
message, 'now do timing analysis', /continue






;*******************************************************************************
;*                     LEAST SQUARES BOUNDARY ANALYSIS                         *
;*                                                                             *
;*                                                                             *
;*******************************************************************************

rel_T = dblarr(4, 4)
mm = dblarr( 3, 1)
tt = boundarytimes
sum1 =  dblarr(4, 4)
sum2 = dblarr(4)
summer = dblarr(4)
FOR alpha = 0, N-1 DO begin
  FOR beta = 0,  N-1 DO begin
     rel_T(alpha, beta) = tt(alpha)-tt(beta)
 ENDFOR
ENDFOR


l = 0
k = 0
alpha = 0
beta = 0

WHILE (l LE 2) DO BEGIN
   WHILE (k LE 2) DO BEGIN
      WHILE (alpha LE N-1) DO BEGIN
          WHILE (beta LE N-1) DO begin
          sum1(alpha, beta) = rel_T(alpha, beta)*(rr(k, alpha)-rr(k, beta))
          beta = beta+1
          ENDWHILE
      alpha = alpha+1
      beta = 0
      ENDWHILE
   summer(k) = total(total(sum1))
   sum2(k) = (summer(k))#(invR(l, k))
   k = k+1
   alpha = 0
   ENDWHILE
mm(l) = (1/(2*N^2))*total(total(sum2))
print, '.'
l = l+1
k = 0
ENDWHILE

modm =sqrt( mm(0)^2 +mm(1)^2 + mm(2)^2)
normal = mm/modm
velocity =  normal/modm
VMAG = sqrt(velocity(0)^2 + velocity(1)^2 + velocity(2)^2)

            



;*****************************************************************************

;                                  CHRIS OWEN METHOD
;*****************************************************************************

r_1 = r1(*,0)
r_2 = r2(*,1)
r_3 = r3(*,2)
r_4 = r4(*,3)

mv12 = (r_2-r_1)/t12
mv13 = (r_3-r_1)/t13
mv14 = (r_4-r_1)/t14
mbighat = crossp((mv12-mv13), (mv12-mv14))
mnhat = mbighat/sqrt(total(mbighat^2))
mbvel2=transpose(mnhat)#mv12;
mbvel3=transpose(mnhat)#mv13;
mbvel4=transpose(mnhat)#mv14;

christimenormal=mnhat;
christimevel=[mbvel2, mbvel3, mbvel4];


;****************************************************************************



test_1_n = abs(total(boundary_normal-normal)/3);simple versus leastsquares
test_1_v =  boundary_vel -VMAG;

test_2_n = abs(total(boundary_normal-christimenormal)/3);;simple versus owen
test_2_v =  abs(total(boundary_vel - christimevel)/3)

test_3_n = abs(total(normal-christimenormal)/3);leastsquares versus owen
test_3_v = abs(total(VMAG-christimevel)/3)

IF test_1_n LE 10e-5 THEN message,  'check one OK', /continue
IF test_1_v LE 10e-5 THEN message,  'check two OK', /continue
IF test_2_n LE 10e-5 THEN message,  'check three OK', /continue
IF test_2_v LE 10e-5 THEN message,  'check four OK', /continue
IF test_3_v LE 10e-5 THEN message,  'check five OK', /continue
IF test_3_n LE 10e-5 THEN message,  'check six OK', /continue
print,  'NORMAL'
print, normal
print,  'Velocity'
print, VMAG


sc_pos_rel_sc1 = dblarr(3, 10)
sc_pos_rel_sc1(*, 0) = r1(*, 0)
sc_pos_rel_sc1(*, 1) = r2(*, 0)
sc_pos_rel_sc1(*, 2) = r3(*, 0)
sc_pos_rel_sc1(*, 3) = r4(*, 0)
sc_pos_rel_sc1(*, 4:7) = mesocentre
sc_pos_rel_sc1(*, 8) = normal
sc_pos_rel_sc1(*, 9) = VMAG
;print,  sc_pos_rel_sc1
sc_positions = sc_pos_rel_sc1
papco_cluster_tetrahedron_plot, boundtime

END

;**************************************************************
;* timing calculation requires boundary times, use cross correlation
;* method to derive time lags and the relevant times required.
;* 
;* create 4 windows around selected boundary time
;* assume secleted boundary times are in terms of indexes wrt
;*data4sc_timed data

;PRO RAPID_timing_correl, timing_indexes,  actual_times
;common cluster_rapid_4sc, data4sc_timed

;correl_windowsize = 10; this is spind periods so *4 seconds

;* fft and cross corelation here

;*calulate lags times here
;* return actual_times
  

;******************************************************************************
;*****************************************************************************
PRO PAPCO_cluster_timing_correlation
;TO BE DONE
END


;*****************************************************************************
;*****************************************************************************
;*                                tetrahedronplot                            *
;*                                                                           *
;*                                                                           *
;*****************************************************************************
;*****************************************************************************

PRO papco_cluster_tetrahedron_plot, boundtime
COMMON sc_positions, sc_positions
re = 6400
normal = sc_positions(*, 8)
VMAG = sc_positions(0, 9)
mesocentre = sc_positions(*, 4:7)/6400
r1 = sc_positions(*, 0)/RE
r2 = sc_positions(*, 1)/RE
r3 = sc_positions(*, 2)/RE
r4 = sc_positions(*, 3)/RE

tet_scale=01
clus_xrange=[[(mesocentre(0,0)-tet_scale)],[(mesocentre(0,0)+tet_scale)]]
clus_yrange=[[(mesocentre(1,0)-tet_scale)],[(mesocentre(1,0)+tet_scale)]]
clus_zrange=[[(mesocentre(2,0)-tet_scale)],[(mesocentre(2,0)+tet_scale)]]
plot_normal = [[mesocentre(0, 0)+normal(0)],[mesocentre(1, 0)+normal(1)],[mesocentre(2, 0)+normal(2)]]

symbolsize=0.05
symbolsize3=0.35
symbolthick=4
CL1sym = OBJ_NEW('IDLgrSymbol', COLOR=[0,0,0],6,size=[symbolsize-0.004,symbolsize-0.004,symbolsize-0.004],thick=symbolthick)
CL2sym = OBJ_NEW('IDLgrSymbol', COLOR=[255,0,0],4,size=[symbolsize,symbolsize,symbolsize],thick=symbolthick)
CL3sym = OBJ_NEW('IDLgrSymbol', COLOR=[0,255,0],3,size=[symbolsize3,symbolsize3,symbolsize3],thick=symbolthick)
CL4sym = OBJ_NEW('IDLgrSymbol', COLOR=[0,0,255],5,size=[symbolsize,symbolsize,symbolsize],thick=symbolthick)
VMAG = string(VMAG)
normal = string(normal)
;PLOT3D_box, [r1(0,0),r2(0,0)], [r1(1,0),r2(1,0)], [r1(2,0),r2(2,0)]
;pro CLUSTER_3dplot
; .r ../IDLSTUFF/clusterplot3d

name_normal = 'V=' +VMAG+'n= '+normal(0)+normal(1)+normal(2)
normal_v = 'V = '+VMAG+' km/s'
cl3time = strmid(boundtime(2),0,5) 
plot_TITLE = '1=Blk,2=Rd,3=Gr,4=Blu '


;xplot3d,[r1(0,0),r2(0,0),r3(0,0),r4(0,0),r1(0,0),r3(0,0),r2(0,0),r4(0,0)],[r1(1,0),r2(1,0),r3(1,0),r4(1,0),r1(1,0),r3(1,0),r2(1,0),r4(1,0)],[r1(2,0),r2(2,0),r3(2,0),r4(2,0),r1(2,0),r3(2,0),r2(2,0),r4(2,0)]

papco_xplot3d, [r1(0,0),r2(0,0),r3(0,0),r4(0,0),r1(0,0),r3(0,0),r2(0,0),r4(0,0)], [r1(1,0),r2(1,0),r3(1,0),r4(1,0),r1(1,0),r3(1,0),r2(1,0),r4(1,0)], [r1(2,0),r2(2,0),r3(2,0),r4(2,0),r1(2,0),r3(2,0),r2(2,0),r4(2,0)],cl3time, SYMBOL= [CL1sym,CL2sym,CL3sym,CL4sym,CL1sym,CL3sym,CL2sym,CL4sym],TITLE = [plot_TITLE], XRANGE=[clus_xrange(0),clus_xrange(1)],YRANGE=[clus_yrange(0),clus_yrange(1)],ZRANGE=[clus_zrange(0),clus_zrange(1)], XTITLE = normal_v, YTITLE = 'Y GSE', ztitle = 'Z GSE'


papco_xplot3d, [mesocentre(0,0), plot_normal(0)],[mesocentre(1, 0), plot_normal(1)], [mesocentre(2,0), plot_normal(2)],cl3time, THICK = 3, XRANGE=[clus_xrange(0),clus_xrange(1)],YRANGE=[clus_yrange(0),clus_yrange(1)],ZRANGE=[clus_zrange(0),clus_zrange(1)], NAME = name_normal, /overplot

;xplot3d, [r1(0,0),r2(0,0),r3(0,0),r4(0,0),r1(0,0),r3(0,0),r2(0,0),r4(0,0)], [r1(1,0),r2(1,0),r3(1,0),r4(1,0),r1(1,0),r3(1,0),r2(1,0),r4(1,0)], [r1(2,0),r2(2,0),r3(2,0),r4(2,0),r1(2,0),r3(2,0),r2(2,0),r4(2,0)]


END
