;*******************************************************************************
FUNCTION papco_spec_area, x

COMMON channels, f1, f2, e1, e2 ;fluxes and energy ranges for channels
r = f1/f2 - (exp(e1(1)*x) - exp(e1(0)*x) ) / (exp(e2(1)*x) - exp(e2(0)*x))
return, r
END

;*******************************************************************************
;returns area under exponen between two energies given a,b for
;F(x) = a * exp(b*x)
FUNCTION papco_spec_rng, a, b, e
return, a/b * ( exp(b*e(1)) - exp(b*e(0)) )
END 

;*******************************************************************************
; Function to interpolate spectrum. Assumes an exponetial spectrum shape.
; Inputs: two energy ranges and their associated counts
;         required output energy range 
; Returns interpolated counts for required energy range
;
FUNCTION papco_exp_interpol, f1, f2, e1, e2, en

COMMON get_error, get_err_no, get_err_msg  

;for F(x) = a * exp(b*x), first find b - root of function spec_area
b = papco_FX_ROOT(x, 'papco_spec_area')

;check for convergence on root finding
IF get_err_no NE 0 THEN return, -99.0

;once we have b, can find a in F(x) = a * exp(b*x)
a = f1*b / ( exp(b*ek1(1)) - exp(b*ek1(0)) )

fn = spec_rng(a, b, en)

return, fn

END
