
;*********************************************************************************
;* do range indexing for L values
;* 
;*
;*
;*
;*
;*********************************************************************************

pro papco_rapid_sc_intercal_lrange_selectnplot, intercal_info,LMIN,LMAX,new_intercal_info,DO_PLOT=DO_PLOT


common papco_color_names

COMMON cluster_eph_data, input_header, input_data
COMMON cluster_rapid_slice_1, time, zmat, data, yarr, utitle, uytitle, uztit
 COMMON cluster_rapid
COMMON mjdt, mjdt_start, mjdt_end
COMMON get_error, get_err_no, get_err_msg

papco,/set_only

L_RANGE_start=intercal_info.intcal_matches.LRANGE(0)
L_RANGE_stop=intercal_info.intcal_matches.LRANGE(1)
idx=where( (L_RANGE_start gt LMIN) and (L_RANGE_stop lt LMAX),c)

if c eq 0 then print,'out of Lrange'

  if c ne 0 then begin
     pass=intercal_info.INTCAL_MATCHES(idx).PASS
     in_out=intercal_info.INTCAL_MATCHES(idx).in_out
     LRANGE=intercal_info.INTCAL_MATCHES(idx).LRANGE
     AV_COUNTS=intercal_info.INTCAL_MATCHES(idx).AV_COUNTS
     intcal_matches={PASS:pass,IN_OUT:in_out,LRANGE:LRANGE,AV_COUNTS:AV_COUNTS }
     new_intercal_info={intcal_matches:intcal_matches,FILE_DATA:intercal_info.FILE_DATA}
  endif

  LMIN=strcompress(string(LMIN))
  LMAX=strcompress(string(LMAX))
  LUT=intercal_info.FILE_DATA.LUT_VALUE
  LUT=strcompress(string(LUT))

papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez

new_intercal_info={new_intercal_info:new_intercal_info,fit_values:fit_valuez}
if keyword_set(DO_PLOT) then begin
;*************plotting sections
;ascertain max counts for scaling
max_counts=dblarr(4)
  for i=0,3 do  begin
    counts=intercal_info.intcal_matches.AV_COUNTS(i,*)
    max_counts(i)=max(max(counts))
  endfor

max_counts=max(max_counts)
  if max_counts gt 100000 then begin
    print, 'high counts'
    max_counts=3000
  endif
xrange=[0,max_counts]
yrange=xrange


yrange_fit=dblarr(6,6,2)
  for i=0,5 do begin 
     yrange_fit(i,i,0)=new_intercal_info.FIT_VALUES.(i).(i).(0)
  endfor
;LUT=intercal_info.FILE_DATA.LUT_VALUE
counts=new_intercal_info.new_intercal_info.intcal_matches.AV_COUNTS

ch=5
 
;EXPECT scpair to go in order:
;sc1_sc2
;sc1_sc3
;sc1_sc4
;sc2_sc3
;sc2_sc4
;sc3_sc4

for sc_pair=0,5 do begin

  case sc_pair of
   0:begin
     sc_a=0 & sc_b=1 
     plot_title='C1 vs C2, LMIN= '+LMIN+' LMAX= '+LMAX+' LUT='+LUT 
     xtitle='C1'
     ytitle='C2'
   end;sc1_sc2

   1:begin
     sc_a=0 & sc_b=2 
     plot_title='C1 vs C3, LMIN= '+LMIN+' LMAX= '+LMAX+' LUT='+LUT 
     xtitle='C1'
     ytitle='C3'

     end;sc1_sc3

   2:begin 
     sc_a=0 & sc_b=3
     plot_title='C1 vs C4, LMIN= '+LMIN+' LMAX= '+LMAX+' LUT='+LUT 
     xtitle='C1'
     ytitle='C4'
     end;sc1_sc4

   3:begin
     sc_a=1 & sc_b=2
     plot_title='C2 vs C3, LMIN= '+LMIN+' LMAX= '+LMAX+' LUT='+LUT 
     xtitle='C2'
     ytitle='C3'
     end;sc2_sc3

   4:begin
     sc_a=1 & sc_b=3
     plot_title='C2 vs C4, LMIN= '+LMIN+' LMAX= '+LMAX+' LUT='+LUT 
     xtitle='C2'
     ytitle='C4'
     end;sc2_sc4

   5:begin 
     sc_a=2 & sc_b=3
     plot_title='C3 vs C4, LMIN= '+LMIN+' LMAX= '+LMAX+' LUT='+LUT 
     xtitle='C3'
     ytitle='C4'
     end;sc3_sc4
 endcase

  window,sc_pair,title=plot_title,ypos=330,xpos=160,xsize=800,ysize=800 & wset,sc_pair
  !p.position=[0.1,0.1,0.9,0.85] 
  !p.position=[0.1,0.1,0.9,0.85] 
  !p.position=0 
  !p.region=[0.15,0.15,0.9,0.85] 
  !p.region=0 
  !p.multi=[1,2,3,0,1]
  !p.charsize=3
  !x.margin=[4,4] 
  !y.margin=[3,3] 
   !x.omargin=[2,2]
   !y.omargin=[2,2]
;  !Y.ticks=0& !X.ticks=0

  for i=0,ch do begin
   !p.multi(0) =i+1
   plot,counts(sc_a,i,*),counts(sc_b,i,*),psym=4,xrange=xrange,yrange=yrange,xtitle='CH '+string(i+1),color=(black+i) 
   plots,xrange,yrange
   slope=new_intercal_info.FIT_VALUES.(sc_pair).(i).(0)
   intercept=new_intercal_info.FIT_VALUES.(sc_pair).(i).(1)
fit_y=slope*xrange + intercept
   plots,xrange,fit_y,psym=-1,color=black
  endfor


 endfor
endif





end




;****************************************************************************8
;**********************************************************************88
;*
;*loop to generate fit values for different L ranges for each channel
;*
;*
;*
;*
;*************************************************************************
pro papco_cluster_rapid_intercal_analysis,intercal_info, LSTEP,LMIN,LMAX,new_intercal_fit_structure,new_intercal_info,DO_PLOT=DO_PLOT



wide_LRANGE=intercal_info.(1).(1)
L_RANGE_start=intercal_info.intcal_matches.LRANGE(0)
L_RANGE_stop=intercal_info.intcal_matches.LRANGE(1)

papco,/set_only

common papco_color_names
no_of_fits=((LMAX-LMIN)/LSTEP)

LVALUE=LMIN
;set up new structure to holdfit values and data

dummy111={fit_slope:0.0d,fit_intercept:0.0d,fit_chisq:0.0d,fit_conf68:dblarr(2),fit_conf95:dblarr(2),fit_conf99:dblarr(2)}
dummy222={ch1:dummy111, ch2:dummy111,ch3:dummy111,ch4:dummy111,ch5:dummy111,ch6:dummy111}
fitvalues={sc1_sc2:dummy222,sc1_sc3:dummy222,sc1_sc4:dummy222,sc2_sc3:dummy222,sc2_sc4:dummy222,sc3_sc4:dummy222}

new_intercal_fit_info=replicate(fitvalues,no_of_fits)

i=0
while LVALUE(0) lt LMAX do begin
LMIN=LVALUE
LMAX=LVALUE+LSTEP
print,(string(LVALUE))+'-'
     idx=where( (L_RANGE_start gt LMIN) and (L_RANGE_stop lt LMAX),c)
       if c eq 0 then print,'out of Lrange'
            if c ne 0 then begin
             pass=intercal_info.INTCAL_MATCHES(idx).PASS
             in_out=intercal_info.INTCAL_MATCHES(idx).in_out
             LRANGE=intercal_info.INTCAL_MATCHES(idx).LRANGE
             AV_COUNTS=intercal_info.INTCAL_MATCHES(idx).AV_COUNTS
             intcal_matches={PASS:pass,IN_OUT:in_out,LRANGE:LRANGE,AV_COUNTS:AV_COUNTS }
             new_intercal_info={intcal_matches:intcal_matches,FILE_DATA:intercal_info.FILE_DATA}
             LMIN=strcompress(string(LMIN))
             LMAX=strcompress(string(LMAX))
             LUT=intercal_info.FILE_DATA.LUT_VALUE
             LUT=strcompress(string(LUT))
           papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez
          new_intercal_fit_info(i)=fit_valuez
       i=i+1  
     endif
LVALUE=LVALUE+LSTEP
print,'   '+string(LVALUE)

endwhile
if keyword_set(DO_PLOT) then begin
sc_comb=dblarr(6,6,no_of_fits)


 for i=0,5 do begin;LOOP 6 SC COMBINATIONS
   for j=0,5 do begin;loop channels
   sc_comb(i,j,*)=new_intercal_fit_info.(i).(j).(0)
   endfor
 endfor
idx=where(sc_comb eq 0,c)
if c gt 0 then sc_comb(idx)=!VALUES.F_NAN

sc_pairs=['sc1-sc2','sc1-sc3','sc1-sc4','sc2-sc3','sc2-sc4','sc3-sc4']

xrange=[1,6]
yrange=[0.6,1.4]

set_plot,'ps'
device,/color

 ; window,7,title=plot_title,ypos=330,xpos=160,xsize=800,ysize=800 & wset,7
  !p.position=[0.1,0.1,0.9,0.85] 
  !p.position=[0.1,0.1,0.9,0.85] 
  !p.position=0 
  !p.region=[0.15,0.15,0.9,0.85] 
  !p.region=0 
  !p.multi=[1,2,3,0,1]
  !p.charsize=1.5
  !x.margin=[3,2] 
  !y.margin=[2,2] 
   !x.omargin=[3,3]
   !y.omargin=[3,3]
;  !Y.ticks=0& !X.ticks=0
ch=6
ch_n=findgen(ch)
ch_n=ch_n+1

for j=0,5 do begin
     !p.multi(0) =j+1
for i=0,no_of_fits-1 do begin

case j of 
5:title=' channel vs slope plot for august 2001'
2:title='LUT = '+string(LUT)+', L='+(string(LMIN))+'-'+string(LMAX)
else:title=''
endcase

   plot,ch_n,sc_comb(j,*,i),xrange=xrange,yrange=yrange,xtitle=sc_pairs(j),color=(black+i),title=title 
   plots,[1,6],[1,1]
  endfor
endfor

endif

DEVICE,/close
end



;************************************************************************************8
;*read in different LUT values
;*
;*
;*
;*
;*
;*
;**************************************************************************************
pro papco_rapid_intercal_LUT_RANGE_FITS_PLOT,LMIN,LMAX,DO_PLOT=DO_PLOT

papco,/set_only

common papco_color_names

;******************************************8
   restore,'~/NEW_CAL/sept2002_4_0.1.dat'

    L_RANGE_start=intercal_info.intcal_matches.LRANGE(0)
    L_RANGE_stop=intercal_info.intcal_matches.LRANGE(1)
    idx=where( (L_RANGE_start gt LMIN) and (L_RANGE_stop lt LMAX),c)
       if c eq 0 then print,'out of Lrange'
            if c ne 0 then begin
             pass=intercal_info.INTCAL_MATCHES(idx).PASS
             in_out=intercal_info.INTCAL_MATCHES(idx).in_out
             LRANGE=intercal_info.INTCAL_MATCHES(idx).LRANGE
             AV_COUNTS=intercal_info.INTCAL_MATCHES(idx).AV_COUNTS
             intcal_matches={PASS:pass,IN_OUT:in_out,LRANGE:LRANGE,AV_COUNTS:AV_COUNTS }
             new_intercal_info={intcal_matches:intcal_matches,FILE_DATA:intercal_info.FILE_DATA}
             LMIN=strcompress(string(LMIN))
             LMAX=strcompress(string(LMAX))
             LUT=intercal_info.FILE_DATA.LUT_VALUE
             LUT=strcompress(string(LUT))
             papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez
             new_intercal_fit_info=fit_valuez
             papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez
             new_intercal_info={new_intercal_info:new_intercal_info,fit_values:fit_valuez}
     endif

   LUT_4=new_intercal_info
;******************************************

;******************************************
   restore,'~/NEW_CAL/sept2002_5_0.1.dat'

    L_RANGE_start=intercal_info.intcal_matches.LRANGE(0)
    L_RANGE_stop=intercal_info.intcal_matches.LRANGE(1)
    idx=where( (L_RANGE_start gt LMIN) and (L_RANGE_stop lt LMAX),c)
       if c eq 0 then print,'out of Lrange'
            if c ne 0 then begin
             pass=intercal_info.INTCAL_MATCHES(idx).PASS
             in_out=intercal_info.INTCAL_MATCHES(idx).in_out
             LRANGE=intercal_info.INTCAL_MATCHES(idx).LRANGE
             AV_COUNTS=intercal_info.INTCAL_MATCHES(idx).AV_COUNTS
             intcal_matches={PASS:pass,IN_OUT:in_out,LRANGE:LRANGE,AV_COUNTS:AV_COUNTS }
             new_intercal_info={intcal_matches:intcal_matches,FILE_DATA:intercal_info.FILE_DATA}
             LMIN=strcompress(string(LMIN))
             LMAX=strcompress(string(LMAX))
             LUT=intercal_info.FILE_DATA.LUT_VALUE
             LUT=strcompress(string(LUT))
             papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez
             new_intercal_fit_info=fit_valuez
             papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez
             new_intercal_info={new_intercal_info:new_intercal_info,fit_values:fit_valuez}
     endif
   LUT_5=new_intercal_info
;************************************************

;*********************************************
restore,'~/NEW_CAL/sept2002_6_0.1.dat'
    L_RANGE_start=intercal_info.intcal_matches.LRANGE(0)
    L_RANGE_stop=intercal_info.intcal_matches.LRANGE(1)
    idx=where( (L_RANGE_start gt LMIN) and (L_RANGE_stop lt LMAX),c)
       if c eq 0 then print,'out of Lrange'
            if c ne 0 then begin
             pass=intercal_info.INTCAL_MATCHES(idx).PASS
             in_out=intercal_info.INTCAL_MATCHES(idx).in_out
             LRANGE=intercal_info.INTCAL_MATCHES(idx).LRANGE
             AV_COUNTS=intercal_info.INTCAL_MATCHES(idx).AV_COUNTS
             intcal_matches={PASS:pass,IN_OUT:in_out,LRANGE:LRANGE,AV_COUNTS:AV_COUNTS }
             new_intercal_info={intcal_matches:intcal_matches,FILE_DATA:intercal_info.FILE_DATA}
             LMIN=strcompress(string(LMIN))
             LMAX=strcompress(string(LMAX))
             LUT=intercal_info.FILE_DATA.LUT_VALUE
             LUT=strcompress(string(LUT))
             papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez
             new_intercal_fit_info=fit_valuez
             papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez
             new_intercal_info={new_intercal_info:new_intercal_info,fit_values:fit_valuez}
     endif
LUT_6=new_intercal_info
;*********************************************8

;**********************************************
restore,'~/NEW_CAL/sept2002_7_0.1.dat'

    L_RANGE_start=intercal_info.intcal_matches.LRANGE(0)
    L_RANGE_stop=intercal_info.intcal_matches.LRANGE(1)
    idx=where( (L_RANGE_start gt LMIN) and (L_RANGE_stop lt LMAX),c)
       if c eq 0 then print,'out of Lrange'
            if c ne 0 then begin
             pass=intercal_info.INTCAL_MATCHES(idx).PASS
             in_out=intercal_info.INTCAL_MATCHES(idx).in_out
             LRANGE=intercal_info.INTCAL_MATCHES(idx).LRANGE
             AV_COUNTS=intercal_info.INTCAL_MATCHES(idx).AV_COUNTS
             intcal_matches={PASS:pass,IN_OUT:in_out,LRANGE:LRANGE,AV_COUNTS:AV_COUNTS }
             new_intercal_info={intcal_matches:intcal_matches,FILE_DATA:intercal_info.FILE_DATA}
             LMIN=strcompress(string(LMIN))
             LMAX=strcompress(string(LMAX))
             LUT=intercal_info.FILE_DATA.LUT_VALUE
             LUT=strcompress(string(LUT))
             papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez
             new_intercal_fit_info=fit_valuez
             papco_cluster_rapid_sc_intercal_fit,new_intercal_info,fit_valuez
             new_intercal_info={new_intercal_info:new_intercal_info,fit_values:fit_valuez}
     endif


LUT_7=new_intercal_info
;***********************************************

LUT_RANGE={LUT_4:LUT_4,LUT_5:LUT_5,LUT_6:LUT_6,LUT_7:LUT_7}


;*******************************************************************************************************

if keyword_set(DO_PLOT) then begin
print,'in here'
no_of_luts=4
sc_comb=dblarr(6,6,no_of_luts)

 for k=0,no_of_luts-1 do begin;loop LUT
  for i=0,5 do begin;LOOP 6 SC COMBINATIONS
   for j=0,5 do begin;loop channels
   sc_comb(i,j,k)=LUT_RANGE.(k).FIT_VALUES.(i).(j).(0)
   endfor
  endfor
 endfor


idx=where(sc_comb eq 0,c)
if c gt 0 then sc_comb(idx)=!VALUES.F_NAN

sc_pairs=['sc1-sc2','sc1-sc3','sc1-sc4','sc2-sc3','sc2-sc4','sc3-sc4']

xrange=[1,6]
yrange=[0,2]

set_plot,'x'
;device,/color

  window,7,title=plot_title,ypos=130,xpos=160,xsize=1000,ysize=1000 & wset,7
  !p.position=[0.1,0.1,0.9,0.85] 
  !p.position=[0.1,0.1,0.9,0.85] 
  !p.position=0 
  !p.region=[0.15,0.15,0.9,0.85] 
  !p.region=0 
  !p.multi=[1,2,3,0,1]
  !p.charsize=1.5
  !x.margin=[3,2] 
  !y.margin=[2,2] 
   !x.omargin=[3,3]
   !y.omargin=[3,3]
!p.charsize=2
;  !Y.ticks=0& !X.ticks=0
ch=6
ch_n=findgen(ch)
ch_n=ch_n+1
no_of_luts=4

for j=0,5 do begin
     !p.multi(0) =j+1
  for i=0,no_of_luts-1 do begin
   case j of 
      5:title=' channel vs slope plot for august 2001'
      2:title='LUT = 4-7, L='+(string(LMIN))+'-'+string(LMAX)
   else:title=''
   endcase

   plot,ch_n,sc_comb(j,ch_n,i),xrange=xrange,yrange=yrange,xtitle=sc_pairs(j),title=title,color=black+i 
   plots,[1,6],[1,1]
  endfor
endfor

endif
stop
;DEVICE,/close
end
;BLACK,RED,GREEN,YELLOW
;******************************************************************************************************************



