;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_DOCAL
;
; Purpose     :	Applies calibration factors to data.
;
; Explanation :	Applies geometric factor, efficiency, energy bin width and sample time calibrations using info stored in
;               IF data set header.
;
; Use         : < rcs_docal, header, data, output_info >
;
; Inputs      : header      : STRUCTURE containing IF data set info
;               data        : STRUCTURE array containijg IF data
;               output_info : STRUCTURE containing display info
;
; Opt. Inputs : None.
;
; Outputs     : output_array : FLTARR(nsectors,ndetectors,newbands,npoints) calibrated data
;
; Opt. Outputs:	None.
;
; Keywords    : NOCAL  : FLAG indicating not to apply calibration factors
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :
;
; Version     :	Version 0.0, 17/9/00
;-
;**********************************************************

FUNCTION rcs_docal, header, data, output_info, NOCAL=nocal

  ; reform output array

  output_array = REFORM ( data.data, header.nsectors, header.ndetectors, header.nbands, N_ELEMENTS(data))

  IF KEYWORD_SET(nocal) THEN RETURN, output_array

  ; take into account channel sizes
  ; convert from counts per channel to count per keV

  IF output_info.div THEN ies_div, data.lut, header.nbands, header.ndetectors, header.ch_positions*header.energy_cal[0], output_array

  ; apply rate calibration i.e convert from counts to counts/sec
  ; store rates as count rate per nsectors as for POLAR
  ; to convert from count rate / nsectors to count rate multiply by the no of sectors
  ; ie accumulation time per sector is spin_time / nsectors

  IF output_info.rat THEN ies_rat, data.time, header.nsectors, header.nbands, header.ndetectors, output_array, REVERSE=reverse, ENDTIMES=data.endtime

  ; apply count calibration i.e convert from counts to counts/sr/cm2

  IF output_info.cal THEN ies_cal, data.lut, header.count_cal, output_array

  IF output_info.eff THEN ies_efficiency, data.lut, header.energy_efficiency, output_array

  ; return array

  RETURN, output_array

END
