;******************************************************************************
;* PROCEDURE:
;*      PRO papco_UpdateAverage_crres_efi
;*
;* DESCRIPTION:
;*      The info-window is a small window, in which data about the selected
;*	rectangle is displayed. (integral,average,deltat)
;*
;* INPUTS:
;*	none
;*
;*
;* CALLING SEQUENCE:
;*	papco_UpdateAverage
;*
;* MODIFICATION HISTORY:
;*     written august and september 1995, Andreas Keese
;*     modified February 1997 by Reiner Friedel, to be independent of x-axis
;*                                                format and to use mjdt time
;*     modified February 1998 by Doug Rowland to average and integrate
;*
;*  NB:  To modify this slice function for your module you will
;*       need to change several things, including the COMMON block
;*       below (currently set to COMMON crres_efi_data) to the
;*       COMMON block appropriate for your module's data.
;*       
;******************************************************************************
PRO papco_UpdateAverage_crres_efi

   COMMON PLOT_COMPOSER, widgetData
   COMMON MJDT, mjdt_start, mjdt_end 
   COMMON MOUSE_SELECT,old,click,pnlNr,n_x,n_y 
;----------change the three lines below to suit your module----------- 
   COMMON papco_CURSOR_AVERAGE_crres_efi, cursorWidgetDataAvg_crres_efi
   COMMON AverageSliceEFI,mouse_clicked,mouse_released,clickpos,currpos 
   COMMON crres_efi_data,input_header,input_data ;data common block 
   BADVAL = 99999.                          ;"bad data" value                         
;--------------------------------------------------------------------
   
   panel=widgetData.mouse_panelNr
   orbNr=widgetData.orbitInfo.number

;----------------erase the previously drawn selection----------------
;                so that when the sliders are updated
;                the "selection box" can be redrawn
;--------------------------------------------------------------------

   DEVICE,SET_GRAPH=6 
   
   polyfill,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)], $
            [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)], $
	     color=30,/NORMAL
   plots,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)], $
            [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)], $
	     color=0,/NORMAL
					
;-------------get the slider values and decide which data points----
;                            fall in that range
;--------------------------------------------------------------------
   widget_control,cursorWidgetDataAvg_crres_efi.smin,get_value=mintime
   widget_control,cursorWidgetDataAvg_crres_efi.smax,get_value=maxtime
  
   mint = min([mintime,maxtime])
   maxt = max([mintime,maxtime])
   mint = input_data(mint).time
   maxt = input_data(maxt).time
   
   index = where((input_data(*).time ge mint) and $
      (input_data(*).time le maxt) and (input_data(*).dat ne BADVAL))
  
  ;-------the following code assumes you pass in the time in---------
  ;       the PAPCO standard (time in seconds since the      
  ;       start of the data that is read) and uses the MJDT
  ;       COMMON block to convert the slider values to
  ;       "pretty" start and end strings  MM/DD/YYYY HH:MM:SS
  ;------------------------------------------------------------------
   
   stsec = (mint/86400.+floor(mjdt_start.t90/86400.))
   ensec = (maxt/86400.+floor(mjdt_start.t90/86400.))
   stdoy = day_to_doy(floor(stsec))
   endoy = day_to_doy(floor(ensec))
   stmnt = doy_to_month(stdoy.doy,stdoy.year)
   enmnt = doy_to_month(endoy.doy,endoy.year)
   stut  = day_to_ut(stsec-floor(stsec))
   enut  = day_to_ut(ensec-floor(ensec))
   
   stutstr =strtrim(string(stmnt.month,format='(I2.2)') + '/' + $
      string(stmnt.day,format='(I2.2)') + '/' + string(stmnt.year, $
      format='(I4.4)') + '  ' + string(stut.hr,format='(I2.2)') + ':' $
      + string(stut.min,format='(I2.2)') + ':' + string(stut.sec, $
      format='(I2.2)'),2)
   
   enutstr =strtrim(string(enmnt.month,format='(I2.2)') + '/' + $
      string(enmnt.day,format='(I2.2)') + '/' + string(enmnt.year, $
      format='(I4.4)') + '  ' + string(enut.hr,format='(I2.2)') + ':' $ 
      + string(enut.min,format='(I2.2)') + ':' + string(enut.sec, $
      format='(I2.2)'),2)
  ;---------------------end of "pretty string" generation------------

  ;--------------now calculate average, integral, and delta t--------
  ;              right now this function assumes that any
  ;              "data gaps" have the same average value as
  ;                     the data that is present
  ;------------------------------------------------------------------

  if (index(0) ne -1) then begin
     
     delt   = abs((max(input_data(index).time) - $
	min(input_data(index).time))/60.)
     
     avgval = ((total(input_data(index).dat))/n_elements(index))
     
     intval = avgval*delt

  ;----------------------now reset the widget text values------------
  ;                      to reflect the calculations and
  ;                      new start and end times for integral
  ;------------------------------------------------------------------

     widget_control,cursorWidgetDataAvg_crres_efi.intv, $
	set_value=strtrim(string(intval),2)
     widget_control,cursorWidgetDataAvg_crres_efi.avg,  $
	set_value=strtrim(string(avgval),2)
     widget_control,cursorWidgetDataAvg_crres_efi.del,  $
	set_value=strtrim(string(delt),2)
     widget_control,cursorWidgetDataAvg_crres_efi.sta,set_value=stutstr
     widget_control,cursorWidgetDataAvg_crres_efi.en,set_value=enutstr
    
;-------------------now calculate the new box corners----------------
;                   in preparation for a redraw and redraw the box
;--------------------------------------------------------------------
     n_xymin = papco_Data_To_Normal(pnlNr,[mint,0])
     n_xymax = papco_Data_To_Normal(pnlNr,[maxt,0])
     new_boxleft = n_xymin(0)
     new_boxright = n_xymax(0)
     clickpos(0) = new_boxleft
     currpos(0)  = new_boxright
     
     polyfill,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)],$
	      [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)],$
	      color=30,/NORMAL
     plots,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)],$
           [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)],$
           color=0,/NORMAL

     DEVICE,SET_GRAPH=3 

   endif else begin
     
     wm_nodata=widget_message('No data points selected',/error)
     return

   endelse
end
;*****************************************************************************
pro averageslicedraw_crres_efi_event,event

COMMON PLOT_COMPOSER,widgetData
COMMON MOUSE_SELECT,old,click,pnlNr,n_x,n_y

;----------change the COMMON block below to suit your module--------
COMMON AverageSliceEFI,mouse_clicked,mouse_released,clickpos,currpos
;-------------------------------------------------------------------

WIDGET_CONTROL,Event.id,GET_UVALUE=Ev

device,set_graph=6

mouse_Plot = widgetData.plotsDrawn(widgetData.mouse_panelNr)

if (mouse_clicked eq 1) then begin

  ;-------mouse was clicked, so erase previously drawn box----------
    polyfill,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)], $
      [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)], $
      color=30,/NORMAL
    plots,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)], $
      [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)], $
      color=0,/NORMAL
  ;-----------------------------------------------------------------
endif

case event.type of

      0: begin
	   mouse_clicked = 1
	   mouse_released = 0
	   clickpos = CONVERT_COORD(event.x,event.y,/DEVICE,/TO_NORMAL)
	   clickpos = clickpos(0:1)
           clickpos(0) = clickpos(0) > mouse_Plot.normal_xRange(0)
           clickpos(0) = clickpos(0) < mouse_Plot.normal_xRange(1)
           clickpos(1) = clickpos(1) > mouse_Plot.normal_yRange(0)
           clickpos(1) = clickpos(1) < mouse_Plot.normal_yRange(1)
	   currpos = clickpos
         end
      1: begin
	   mouse_released = 1
	   mouse_clicked = 0
	   relpos = CONVERT_COORD(event.x,event.y,/DEVICE,/TO_NORMAL)
	   relpos = relpos(0:1)
           relpos(0) = relpos(0) > mouse_Plot.normal_xRange(0)
           relpos(0) = relpos(0) < mouse_Plot.normal_xRange(1)
           relpos(1) = relpos(1) > mouse_Plot.normal_yRange(0)
           relpos(1) = relpos(1) < mouse_Plot.normal_yRange(1)
           currpos = relpos
           polyfill,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)], $
                    [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)], $
                    color=30,/NORMAL
           plots,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)], $
                 [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)], $
                 color=0,/NORMAL
           
           print,'loading data' 
	   callgood = execute(widgetData.plotsDrawn(pnlNr).get_data_call)

           if not callgood then begin
              print, '-------------------------------------'
              print, 'Program - error : unknown plot type'
              print,widgetData.plotsDrawn(pnlNr).panelKind
              print, '-------------------------------------'
              help,/traceback
              stop
           endif else print,'loaded data successfully'
           
  ;----------the following lines are specific to CRRES EFI----------
  ;          most routines won't use a "dataid"
  ;          and you'll have to change Averagewidgetcontrol_crres_efi
  ;          to suit your module
  ;-----------------------------------------------------------------
	   callseparr = str_sep(widgetData.plotsDrawn(pnlNr).get_data_call,',')           
	   reads,callseparr(1),dataid
	   Averagewidgetcontrol_crres_efi,dataid
  ;-----------------------------------------------------------------
	   return 
         end
      2: begin 
	   if (mouse_clicked eq 1) then begin
	      currpos = CONVERT_COORD(event.x,event.y,/DEVICE,/TO_NORMAL)
              currpos = currpos(0:1)
              currpos(0) = currpos(0) > mouse_Plot.normal_xRange(0)
              currpos(0) = currpos(0) < mouse_Plot.normal_xRange(1)
              currpos(1) = currpos(1) > mouse_Plot.normal_yRange(0)
              currpos(1) = currpos(1) < mouse_Plot.normal_yRange(1)
	   endif
         end
   else:
 endcase

if (mouse_clicked eq 1) then begin

;-------------draw new box selection---------------------------------
 polyfill,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)], $
   [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)], $
   color=30,/NORMAL
 plots,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)], $
   [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)], $
   color=0,/NORMAL

endif

device,set_graph=3
end

;******************************************************************************
;* PROCEDURE:
;*      PRO Averagewidgetcontrol_crres_efi_Event, event
;*
;* DESCRIPTION:
;*      The info-window is a small window, in which data about the selected
;*	rectangle is displayed. (average, integral, delta-t)
;*	This procedure handles events for that window.
;*
;* INPUTS:
;*	event	 an XMANAGER-event
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:
;*     written august and september 1995, Andreas Keese
;*     modified for use with averaging Feb 1998, Doug Rowland
;******************************************************************************
PRO Averagewidgetcontrol_crres_efi_Event, event

   COMMON PLOT_COMPOSER, widgetData
   COMMON MOUSE_SELECT,old,click,pnlNr,n_x,n_y

;-------modify the three lines below to suit your module---------------
   COMMON papco_CURSOR_AVERAGE_crres_efi, cursorWidgetDataAvg_crres_efi
   COMMON AverageSliceEFI,mouse_clicked,mouse_released,clickpos,currpos 
   module_name  = 'crres_efi'            ;change this to your module
   helpfilename = 'average_or_integrate_time_series_crres_efi.help'
;--------------------------------------------------------------------

   dw_draw = widgetData.dw_draw 
   WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev

   CASE Ev OF
      'ws_mintime' : papco_UpdateAVERAGE_crres_efi
                     
      'ws_maxtime' : papco_UpdateAVERAGE_crres_efi

      'pb_help'    : begin
		       helpfilepath = papco_getenv('PAPCO_MODULES')
		       helpfilepath = helpfilepath+module_name+'/papco_interface/'
		       xdisplayfile,helpfilepath+helpfilename, $
                         title='papco Online-Help', group=event.top,$
		         height = 41
		     end
      'pb_done' : BEGIN
                    device,set_graph=6 
                    polyfill,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)],$
	                     [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)],$
	                     color=30,/NORMAL
                    plots,[clickpos(0),currpos(0),currpos(0),clickpos(0),clickpos(0)],$
                             [clickpos(1),clickpos(1),currpos(1),currpos(1),clickpos(1)],$
                             color=0,/NORMAL
		    
		    device,set_graph=3
                    mouse_clicked = 0
                    mouse_released = 0
                    clickpos = click
                    currpos  = click
                    relpos   = click
                    old = click
                    n_x = click(0)
                    n_y = click(1)
		    widgetData.mouse_clicked = 0
                    print,'------------------------------------------'
		    print,'returning control of events to draw_window'
		    print,'preparing draw window for input'
		    print,'exiting Averaging slice'
		    print,'------------------------------------------'
		    WIDGET_CONTROL, dw_draw, /DRAW_BUTTON_EVENTS,/DRAW_MOTION_EVENTS, $
				    event_pro = 'papco_draw_window_Event'
;-------------- change the following line to suit your module-------- 
		    WIDGET_CONTROL, cursorWidgetDataAvg_crres_efi.base, /DESTROY
;--------------------------------------------------------------------
		 END

            ELSE : 
   ENDCASE

END
;******************************************************************************
;* PROCEDURE:
;*      PRO USER_Average_or_Integrate_Time_Series_crres_efi,panelNr, normal_x, normal_y, CLOSE=CLOSE
;*
;* DESCRIPTION:
;*	This procedure is called whenever the average_or_integrate_time_series-function is active and
;*	the mouse is dragged in the draw-widget.
;*	An info-window is opened - this is a small window, in which data
;*	about the selected rectangle is displayed. (integral, average, delta t)
;*      To be independent of the actual time axis format used by the plot,
;*      this routine uses the system variable !X.CRANGE and converts the
;*      cursor time returned to the papco internal time format.
;*
;*      N.B.!!: For this to work, the user plot routine needs to adhere to the
;*      papco philosophy and ALWAYS plot data for the time range given by
;*      COMMON mjdt, mjdt_start, mjdt_end
;*
;* INPUTS:
;*	panelNr	 	an integer
;*			the number of the panel for which the rectangular
;*			selection is done
;*	normal_x	a float
;*	normal_y	a float
;*			the normal coordinates of the last mouse-position
;*
;* KEYWORDS:
;* 	CLOSE		if set, the window is closed
;*
;* MODIFICATION HISTORY:
;*     written august and september 1995, Andreas Keese
;*     modified February 1997 by Reiner Friedel, to be independent of x-axis
;*                                                format and to use mjdt time
;*     modified February 1998 by Doug Rowland to use averaging 
;*                                and integrating
;******************************************************************************
pro USER_Average_or_Integrate_Time_Series_crres_efi,panelNr,normal_x,normal_y,CLOSE=CLOSE

COMMON PLOT_COMPOSER, widgetData
COMMON MOUSE_SELECT,old,click,pnlNr,n_x,n_y

;------------------change the line below to suit your module--------
COMMON AverageSliceEFI,mouse_clicked,mouse_released,clickpos,currpos
averagingeventhandler = 'averageslicedraw_crres_efi_event'
;-------------------------------------------------------------------

   IF XREGISTERED('Averagewidgetcontrol_crres_efi',/NOSHOW) THEN RETURN 
   print,'----------------------------' 
   print,'now entering averaging slice' 
   print,'----------------------------' 
   dw_draw = widgetData.dw_draw
   widget_control,dw_draw,draw_button_events=0,draw_motion_events=0
   xy = papco_Normal_To_Data(pnlNr,click)
   dw_draw = widgetData.dw_draw

   pnlNr = panelNr

   mouse_clicked = 0 
   mouse_released = 0
   clickpos = click
   currpos = click
   if (widgetData.mouse_clicked eq 1) then mouse_clicked=1
   papco_Cursor_ShowSelection,pnlNr,xy(0),xy(1),click(0),click(1),/ERASE_ONLY
   widget_control,dw_draw,draw_button_events=1,draw_motion_events=1
   widget_control,dw_draw,event_pro=averagingeventhandler
   return
end
;*****************************************************************************
pro Averagewidgetcontrol_crres_efi,dataid   ;dataid is for the CRRES EFI module

COMMON PLOT_COMPOSER, widgetData   
COMMON MOUSE_SELECT,old,click,pnlNr,n_x,n_y
COMMON MJDT, mjdt_start, mjdt_end

;-------------change the lines below to suit your module-------------
COMMON AverageSliceEFI,mouse_clicked,mouse_released,clickpos,currpos
COMMON crres_efi_data,input_header,input_data
COMMON papco_CURSOR_AVERAGE_crres_efi,cursorWidgetDataAvg_crres_efi

datainfostruct = get_one_info(dataid) ;for CRRES EFI
title = datainfostruct.name           ;slap in your own title
unit  = datainfostruct.unit           ;and unit information here

BADVAL = 99999                         ;"bad data" value
widgetmodulename = 'Average_or_Integrate_Time_Series_crres_efi'
averagewidgetname = 'Averagewidgetcontrol_crres_efi'
;--------------------------------------------------------------------

   dw_draw = widgetData.dw_draw
   print,'--------------------------------------------------'
   print,'disabling mouse events in draw window'
   print,'while averaging widget is in use'
   print,"click the 'done' button on the averaging widget"
   print,'to return control to the main PAPCO event handler'
   print,'--------------------------------------------------'
   WIDGET_CONTROL, dw_draw, event_pro = 'papco_draw_window_Event', $
	DRAW_BUTTON_EVENTS=0,DRAW_MOTION_EVENTS=0 

   numberofpoints = n_elements(input_data.time)

;-- close the info - window ? -------------------------------------------------


;--------change all instances of cursorWidgetDataAvg_crres_efi--------
;          below to cursorWidgetDataAvg_your_module_name
;---------------------------------------------------------------------

   IF KEYWORD_SET(CLOSE) THEN BEGIN
      IF XREGISTERED(widgetmodulename) THEN $
         IF N_ELEMENTS(cursorWidgetDataAvg_crres_efi) GT 0 THEN BEGIN
	    IF cursorWidgetDataAvg_crres_efi.base NE 0 THEN $
 	       WIDGET_CONTROL, cursorWidgetDataAvg_crres_efi.base, /DESTROY
            cursorWidgetDataAvg_crres_efi.base=0
         ENDIF
      RETURN
   ENDIF

;-- is the mouse still in the initially selected panel ? ----------------------
   IF pnlNr NE widgetData.mouse_panelNr THEN RETURN

;------------convert box coordinates to data coordinates-----------------------
    pos1 = papco_Normal_To_Data(widgetData.mouse_panelNr, $
			    clickpos)
    pos2 = papco_Normal_To_Data(widgetData.mouse_panelNr, $
                            currpos)
			   
   IF pos1(0) LT pos2(0) THEN BEGIN
      starttime=pos1(0) 
      endtime=pos2(0)
   ENDIF ELSE BEGIN
      starttime=pos2(0)
      endtime=pos1(0)
   ENDELSE
   IF pos1(1) LT pos2(1) THEN BEGIN
      startData=pos1(1) 
      endData=pos2(1)
   ENDIF ELSE BEGIN
      startData=pos2(1)
      endData=pos1(1)
   ENDELSE
   
   stindex = max(where(input_data(*).time le starttime))
   enindex = min(where(input_data(*).time ge endtime))

   if ((stindex eq -1) or (enindex eq -1)) then begin
     
      wm_stend = widget_message('start or end point out of range', $
	 /error)
      return
      
   endif

  ;-------the following code assumes you pass in the time in---------
  ;       the PAPCO standard (time in seconds since the      
  ;       start of the data that is read) and uses the MJDT
  ;       COMMON block to convert the slider values to
  ;       "pretty" start and end strings  MM/DD/YYYY HH:MM:SS
  ;------------------------------------------------------------------
  
   mint = input_data(stindex).time
   maxt = input_data(enindex).time
   stsec = (mint/86400.+floor(mjdt_start.t90/86400.))
   ensec = (maxt/86400.+floor(mjdt_start.t90/86400.))
   stdoy = day_to_doy(floor(stsec))
   endoy = day_to_doy(floor(ensec))
   stmnt = doy_to_month(stdoy.doy,stdoy.year)
   enmnt = doy_to_month(endoy.doy,endoy.year)
   stut  = day_to_ut(stsec-floor(stsec))
   enut  = day_to_ut(ensec-floor(ensec))
   
   stutstr =strtrim(string(stmnt.month,format='(I2.2)') + '/' + $
      string(stmnt.day,format='(I2.2)') + '/' + string(stmnt.year, $
      format='(I4.4)') + '  ' + string(stut.hr,format='(I2.2)') + ':' $
      + string(stut.min,format='(I2.2)') + ':' + string(stut.sec, $
      format='(I2.2)'),2)
   
   enutstr =strtrim(string(enmnt.month,format='(I2.2)') + '/' + $
      string(enmnt.day,format='(I2.2)') + '/' + string(enmnt.year, $
      format='(I4.4)') + '  ' + string(enut.hr,format='(I2.2)') + ':' $ 
      + string(enut.min,format='(I2.2)') + ':' + string(enut.sec, $
      format='(I2.2)'),2)

  ;----------end of "pretty string" generation-----------------------

  index = where((input_data(*).time ge mint) and  $
      (input_data(*).time le maxt) and (input_data(*).dat ne BADVAL))
  
   if (index(0) ne -1) then begin
  
  ;--------------now calculate average, integral, and delta t--------
  ;              right now this function assumes that any
  ;              "data gaps" have the same average value as
  ;                     the data that is present
  ;------------------------------------------------------------------
     
     delt   = abs((max(input_data(index).time) - $
        min(input_data(index).time))/60.)

     avgval = ((total(input_data(index).dat))/n_elements(index))
     
     intval = avgval*delt

     integstring=strtrim(string(intval),2)
     avergstring=strtrim(string(avgval),2)
     deltastring=strtrim(string(delt),2)

   endif else begin

     wm_nodat2=widget_message('No data points selected',/error)
     integstring='****'
     avergstring='****'
     deltastring='****'

   endelse

;-- open the info-window ------------------------------------------------------
   IF NOT XREGISTERED(averagewidgetname) $
     THEN BEGIN
     
      cursorAverageBase_crres_efi=WIDGET_BASE(COLUMN=1,  $
	  TITLE='Choose Time Range over which to average or'+$
            ' integrate        '+title, $
            GROUP=widgetData.main_base)

        butt_base=WIDGET_BASE(cursorAverageBase_crres_efi, ROW=6)

         text_base1=WIDGET_BASE(butt_base, COLUMN=3)
	  wt_intname = WIDGET_TEXT(text_base1, $
	    value = 'Integrated value over selected time range ')
          wt_intval  = WIDGET_TEXT(text_base1, $
	    value = integstring,uvalue='wt_intval')
          wt_intunit = WIDGET_TEXT(text_base1, $
	    value = unit +' * minutes')
         
	 text_base2=WIDGET_BASE(butt_base, COLUMN=3)
	  wt_avgname = WIDGET_TEXT(text_base2, $
	    value = '   Average value over selected time range ')
          wt_avgval  = WIDGET_TEXT(text_base2, $
	    value = avergstring,uvalue='wt_avgval')
          wt_avgunit = WIDGET_TEXT(text_base2, $
	    value = '    '+unit +'   ')
          
         text_base3=WIDGET_BASE(butt_base, COLUMN=3)
	  wt_deltname= WIDGET_TEXT(text_base3, $
	    value = '            Delta T (minutes):            ')
          wt_deltval = WIDGET_TEXT(text_base3, $
	    value = deltastring,uvalue='wt_deltval')
          wt_deltunit =WIDGET_TEXT(text_base3, $
	    value = '     minutes    ')
         
         slider_base1=WIDGET_BASE(butt_base, COLUMN=2)
	  ws_mintime = WIDGET_SLIDER(slider_base1,/suppress_value, $
	    minimum=0,maximum=numberofpoints-1,value=stindex, $
	    title='Start Time for average/integral ', $
	    uvalue='ws_mintime',/drag)
          wt_sttval  = WIDGET_TEXT(slider_base1, $
	    value=stutstr)
         
         slider_base2=WIDGET_BASE(butt_base, COLUMN=2)
	  ws_maxtime = WIDGET_SLIDER(slider_base2,/suppress_value, $
	    minimum=0,maximum=numberofpoints-1,value=enindex, $
	    title='End Time for average/integral   ', $
	    uvalue='ws_maxtime',/drag)
          wt_endval  = WIDGET_TEXT(slider_base2,value=enutstr)
         
	 butt_base2=WIDGET_BASE(butt_base,COLUMN=2)
          pb_help    = WIDGET_BUTTON(butt_base2,/align_center, $ 
            value='Help',uvalue='pb_help')
          pb_done    = WIDGET_BUTTON(butt_base2,/align_center, $
	    value='Done',uvalue='pb_done')

      cursorWidgetDataAvg_crres_efi={CURSOR_AVERAGE, base:cursorAverageBase_crres_efi, $
	    avg:wt_avgval,intv:wt_intval,del:wt_deltval, $
	    smin:ws_mintime,smax:ws_maxtime,sta:wt_sttval,en:wt_endval}
		                     
      WIDGET_CONTROL, cursorAverageBase_crres_efi, /REALIZE
      XMANAGER, averagewidgetname, $
		 cursorAverageBase_crres_efI,GROUP_LEADER=dw_draw,/modal,$
		 event_handler=averagewidgetname+'_Event'
   ENDIF

end
