;******************************************************************************
;* file papcoadd_crres_efi
;*      papcoadd_crres_efi
;* end
;*
;* this files contains all the collected routines which have to be added in
;* for a crres_efi. 
;*
;* THIS IS A WORKING EXAMPLE MODULE WHICH CAN BE INCLUDED INTO papco AS IS
;* (it doesn't plot very exciting data though!)
;* THIS TEMPLATE IS INTENDED AS THE STARTING POINT FOR DEVELOPING OWN
;* MODULES. SIMPLY COPY THE WHOLE crres_efi DIRECTORY TREE AND RENAME
;* EVERY OCCURRENCE OF "crres_efi" WITH YOUR MODULE NAME, IN ALL THE FILES
;* AND FILENAMES UNDER THE crres_efi MODULE DIRECTORY TREE.
;*
;* papco is written such that if the files starting with "papcoadd" exist 
;* in the papco_MODULES directory, then the routines contained therein
;* are utilized to add that plot type into the papco package. 
;* This ensures easy extendibility of papco; also makes papco "configurable" 
;* by adding or leaving out specific plot types.
;*
;* ALL that is needed to include the module is to include the path to the
;* module directory tree in the IDL search path in the papco startup file, 
;* eg assuming all modules are under the directory "papco_BASE":
;*
;* !path = !path +':'+ expand_path('+'+papco_BASE+'/papco_modules/crres_efi')
;*
;* If the plot type is in itself a sub-menu containing more crres_efis, then
;* these must be listed at the top of this file, as it is read by papco.
;* the entries for each sub-plot-type must come after the line 
;* "file papcoadd_crres_efi" and before the "end" line, one entry per line.
;* Each of the routines here must then be duplicated for each sub-plot-type
;* used: see $papco_MODULES/papcoadd_crres_plots for an example.
;*
;* Apart from editing this template the user has to write a panel 
;* editor widget for his crres_efi. Use the file 
;*    $papco_XX/papco_modules/crres_efi/papco_interface/crres_efi_panel.pro
;* as the template.
;*
;* If slice functions are to be supported a slice program needs to be written
;* too. Use the template file
;*    $papco_XX/papco_modules/crres_efi/papco_interface/crres_efi_slice.pro.
;*
;* Finally, a data read and data plot routine are required as well. The data
;* read routine will be specific for each crres_efi. An example for a standard
;* line plot is given in the file 
;*    $papco_XX/papco_modules/crres_efi/plot_read/p_data_type_line.pro
;* and for a standard color spectrogram in 
;*    $papco_XX/papco_modules/crres_efi/plot_read/p_data_type_spec.pro. 
;* These templates can also be used as a basis for more complex plots.
;*
;*
;* The Way these add-in routines work:
;* ===================================
;*
;* At papco compile the routine find_modules.pro is used to search the IDL
;* search path, and all the init_module.pro batch files found in the module 
;* sub-directories \papco_interface are written to the papco_add_init.pro
;* batch file and then executed: In this way the user can specify all the 
;* routines that need to be compiled for his module at startup.
;* 
;* At the start-up of papco itself, all module sub-directories 
;* \papco_interface are searched for all files beginning with "papcoadd_". 
;* From the names of these files the crres_efi name is stripped off and used 
;* to construct all the procedure names contained in this file. The first 
;* routine, "addplottype_crres_efi", is used to add the button for this 
;* crres_efi to the papco main window. Since "addplottype_crres_efi" simply 
;* returns widget ID of the button, the button itself can contain further 
;* sub-menus for plot sub-types (e.g. the button for SWE can contain a menu of
;* buttons for a range of SWE plots, ie moments, spectra, etc).
;*
;* To inform papco of all these sub-plot types (and to avoid having to
;* write a separate file for each sub-plot type) all the types have to
;* be listed in the header of the file papcoadd_crres_efi.pro. These entries
;* have to finish off with the line ";* end" - see papcoadd_crres_plots.pro
;* for an example. All crres_efi names are stored in the string array
;* crres_efis and are placed in a common block:
;*    COMMON ADDINS, crres_efis
;*
;* If there are no sub-plot types, then the crres_efi as used in the file name
;* for papcoadd_crres_efi.pro is used to construct the calls to the procedures
;* in that file. The convention for naming these procedures is
;* "procedure_name_crres_efi" , so that papco can always construct the right
;* procedure call when needed. 
;*
;* When there are sub-plot types, their names get used to construct the
;* required calls. There are 6 procedures that need to be called for each
;* crres_efi, so that a set of these 6 procedures has to be written for each
;* sub-plot type. In the same way, you need to write a panel editor for each
;* plot type (sometimes several plot sub-types may share the same editor,
;* e.g. multiple line plots or color spectra, see papcoadd_crres_plots).
;* 
;* In papco, whenever an action for a crres_efi is taken, the information
;* stored in the structure widgetData is queried. In this structure there
;* is an array of PlotInfo structures, which contain all the relevant 
;* information for a chosen panel. The field plotInfo.panelkind is loaded
;* with the name of the crres_efi. This is set by the user in this file in
;* the routine addpanel_crres_efi ( "panelKind='crres_efi'" ). THIS MUST
;* BE SET CORRECTLY AS ALL THE ROUTINE NAMES USED IN THIS ADD-IN FILE ARE
;* CONSTRUCTED USING THIS INFORMATION!
;*
;* Whenever papco has to undertake some action for a
;* crres_efi, the field plotInfo.panelkind is compared to the entries in the
;* (COMMON ADDINS) crres_efiS array. If a match is found, the required
;* procedure name is constructed and called If not, an error occurs.
;*
;*    These procedures are contained:
;*
;*    PRO addplottype_crres_efi,plottypes_base,pb_plottype
;*        ->  adds the button for the new plot type to the main window.
;*
;*    PRO plottable_crres_efi, plottable
;*        -> Sets a variable to indicate plottable without orbit.
;*
;*    PRO descriptor_crres_efi, plotInfo, descriptStr
;*        -> Constructs the string used to label plots in the panels window
;*
;*    PRO addpanel_crres_efi
;*        -> Calls the panel editor for this plottype and adds the plot to the
;*            panel window.
;*
;*    PRO editor_crres_efi, plotNumber, newPlotData
;*        -> This procedure calls the panel editor when called from 
;*           papco_EditPlot (papco_paneledit.pro).
;*
;*    PRO  draw_crres_efi, panelVector, currPlotInfo, get_data_call, IsRead
;*        -> This procedure performs the actual data read call and the plot 
;*           call for this plottype
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      PRO addplottype_crres_efi,plottypes_base,buttonGeometry,pb_plottype
;* 
;* DESCRIPTION:  
;*      This procedure adds a button for this crres_efi to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*      package, so that they can be automatically called when needed.
;*      The button itself can contain access to a sub-menu for further
;*      crres_efis.
;*
;* INPUTS:       
;*      plottypes_base  the widget ID of the parent widget to contain the
;*                      plottype buttons.
;*
;* OUTPUTS: 
;*      pb_plottype     the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for sub-types.
;*
;* KEYWORDS:
;*       none
;* 
;* CALLING SEQUENCE:
;*      addplottype_crres_efi,plottypes_base,buttonGeometry,pb_plottype
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro addplottype_crres_efi,plottypes_base,buttonGeometry,pdm_crres_efi

; VALUE assigns a label for the button
; The crres_efi portion of UVALUE is used to construct the calls to all
; other procedures in this add-in needed by papco.

; example for simple button

    
;   pb_crres_efi = WIDGET_BUTTON(plottypes_base,  $
;                                 VALUE=strcenter('crres_efi',14), $
;                                 UVALUE='pb_crres_efi', $
;                                 _extra=buttonGeometry)

;example for simple pull-down for sub-types from the CRRES module:
  MenuDesc = [ $
        { CW_PDMENU_S,   3, strcenter('crres_efi',10) }, $ 
        { CW_PDMENU_S, 0, ' Configure data file location     ' }, $
        { CW_PDMENU_S, 2, ' plot CRRES EFI     ' } ]
;        { CW_PDMENU_S, 0, ' plot CRRES pitch    ' }, $
;        { CW_PDMENU_S, 0, ' plot CRRES mag      ' }, $ 
;        { CW_PDMENU_S, 2, ' plot CRRES overview ' } $     ]
  pdm_crres_efi = CW_PDMENU(plottypes_base, MenuDesc, $
                  UVALUE='pdm_crres_efi')

;note the convention for naming this widget "pdm_..." for pull-down menu.
;this obviously needs to replace "pb_..." in the procedure call above!

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO plottable_crres_efi, plottable
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate plottable with / without orbit.
;*      PAPCO provides "set time by orbit" feature for CRRES and POLAR
;*      so far. Included for compatibility with older CRRES modules
;*      which ONLY use orbit as input to their read/plot routines
;*      (plotting over orbit boundaries is not enabled for CRRES)
;* 
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      plottable        a boolean 0 if plottable only by orbit
;*                                 1 if plottable by time also.
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      plottable_crres_efi, plottable
;*
;* MODIFICATION HISTORY:       
;*      written November 1995, Reiner Friedel
;******************************************************************************
pro plottable_crres_efi, plottable

   plottable=1     ; 1 -> plotable without orbit info, by time 
                   ; 0 -> plotable only by orbit number not by time 
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO canget_crres_efi, canget
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate that crres_efi is capable of
;*      returning data from it's plot routine into a standard PAPCO
;*      array structure. Used for the scratch pad utility module.
;*      
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      canget         a boolean 0 if this feature is not available
;*                                1 if this feature is available
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      canget_crres_efi, canget
;*
;* MODIFICATION HISTORY:       
;*      written November 1997, Reiner Friedel
;******************************************************************************
pro canget_crres_efi, canget

   canget=  1      ; 1 -> plot routine can return just data 
                   ; 0 -> feature disabled
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO descriptor_crres_efi, plotInfo, descriptStr
;* DESCRIPTION:  
;*      Constructs the string used to label plots in the panel window.
;*      The plotinfo structure passed in here is the panel's plotinfo
;*      as returned by the panel editor for this crres_efi. You can use
;*      the information in that structure to construct some informative
;*      label for the panel which then appears in the Panel Compose list.
;*
;* INPUTS:       
;*      plotInfo        structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*      descriptStr     a string containing the label
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      descriptor_crres_efi, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro descriptor_crres_efi, plotInfo, descriptStr

   common data_path_list,crres_survey_path,decday_path
      crres_survey_path = papco_getenv('CRRES_EFI_DATA')
      decday_path = crres_survey_path+'data68' 
   datainfostruct = get_one_info(PlotInfo.typeVector(0))
   descriptStr = datainfostruct.name
   
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO addpanel_crres_efi
;*
;* DESCRIPTION:  
;*      Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      Using an instance of the papco_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled. The
;*      desired default values for the plotinfo tags need to be edited by
;*      the user. This plotinfo structure will be passed to the panel editor
;*      When it is first called for the crres_efi.
;*      "panelEditor" must be set to the name of the panel editor routine.
;*
;* INPUTS:       
;*      event           event value of papco main window. This is
;*                      only used if there are plot sub_types, 
;*                      for example see papcoadd_crres_plots
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      addpanel_crres_efi
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;***************************************************************************
pro addpanel_crres_efi,event

  panelKind='crres_efi'
  panelEditor=panelkind+'_panel'
  
  CASE event.value of
     1: BEGIN
          papco_module_configure,'crres_efi'
        end
     2: BEGIN
          path = papco_getenv('CRRES_EFI_DATA')
          result = FINDFILE(path+'papco_data_id.txt',count=numfiles)
          if numfiles ne 0 then begin
             defaults=papco_getPlotInfoStruct()  ; returns a basic plotinfo structure
             defaults.typeVector=[61,0,0,0]       ; set some tags to desired defaults
             defaults.channel=0                  ; channel tag is used for the color table
             papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults
           endif else begin
             wm_crres_efi_files_not_found = widget_message('DATA FILES NOT FOUND : PLEASE CONFIGURE EFI DATA FIRST',/error,dialog_parent=pdm_crres_efi)
           endelse
        end
    else:
  endcase


END

;******************************************************************************
;* PROCEDURE:     
;*      PRO editor_crres_efi, plotNumber, newPlotData
;* 
;* DESCRIPTION:  
;*      This procedure calls the panel editor when called from 
;*      papco_EditPlot (papco_paneledit.pro). Provided here to allow
;*      several crres_efis to share a common panel editor. Normally this
;*      procedure does not need to be edited beyond the required name
;*      change for crres_efi.
;*
;* INPUTS:       
;*      plotNumber      anInteger. 0<=plotNumber<=widgetData.numberOfPlots
;*                      the index of the plot in widgetData.plotInfos.
;*            
;* OUTPUTS: 
;*      newPlotData     the new structure returned by the panel editor
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      editor_crres_efi, plotNumber, newPlotData
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
PRO editor_crres_efi, plotNumber, newPlotData

  COMMON PLOT_COMPOSER, widgetData

   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=crres_efi_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
      GROUP=widgetData.main_base)

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO draw_crres_efi, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:  
;*      This procedure performs the actual data read call and the plot call
;*      for this plottype. The user need to pass to his plot routine all the
;*      parameters needed, typically these parameters are stored in the 
;*      currplotinfo structure or constructed from them. The currplotinfo
;*      structure tags normally used for passing information from the panel
;*      editor to the plot routine are:
;*          type_vector - a four element array for choosing the type of data
;*                        (eg. elec or ion, diff or integ., pitch angle, 
;*                             or sector, channel ....)
;*          swittch      - a three element vector for specific plot appearance
;*                        (eg. smoothing/averaging, interpolating ...)
;*          filename    - a filename
;*      
;*      These tags have grown out of traditional usage and can be used for
;*      anything the user wants to use them for. There are plenty variables
;*      for most applications: Adding a new tag to the plotinfo structure
;*      is not user-definable but need to be done at the papco core level.
;* 
;*      The panelVector MUST be passed to your plotroutine as it is used
;*      to set the panel position.
;*      The _EXTRA=extra_PlotInfo should be passed if you intend to make use
;*      of papco functionality such as overplotting, linestyle choice and
;*      color bar choice.
;*
;* INPUTS:       
;*      panelVector    position of the plot (see papco_conventions.text, 6)
;*      currPlotInfo   structure containing all data for this plot.
;*                     (structure papco_PLOTINFO, see papco_variables.text) 
;*
;* OUTPUTS: 
;*      get_data_call  a string containing the data call. Used by other
;*                     routines that need to know how to get the data
;*                     in a panel, e.g. to draw spectra, distribution functions
;*      IsRead         a boolean which is set when the the data is read the
;*                     first time. Useful if a given data-read puts data
;*                     into commons which can be plotted in many ways.
;*                     When set, data does not have to be read again.
;   slice_type:   Selects which slices are supported and for which slice
;                 routines have been written.
;                 This is an integer logical with 16 swittches. Currently
;                 there are 5 papco slices. You may extend this by
;                 further USER slices up to a total of 16 slices.
;                     0 = disable all slices
;                     1 = papco Zoom                 (2^0)
;                     2 = papco View Slice           (2^1)
;                     4 = papco Access level Zero    (2^2)
;                     8 = papco Write Paneldata      (2^3)
;                    16 = papco Hair Cursor          (2^4)
;                    32 = USER slice A or not used   (2^5)
;                    64 = USER slice B or not used   (2^6)
;                    "     "     "   "  "  "    "      "    
;                 32768 = USER slice Z or not used  (2^15)
;                        
;   You can support more than one type of slice by arithmetically adding the
;   options, eg slice_type=1+4  support Zoom and Level Zero
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      draw_crres_efi, panelVector, currPlotInfo, orbitNo, $
;*                                 get_data_call, slice_type, IsRead
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro draw_crres_efi, panelVector, currPlotInfo, orbitNo, $
                                 get_data_call, slice_type, IsRead

  COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
  common data_path_list,crres_survey_path,decday_path

  crres_survey_path = papco_getenv('CRRES_EFI_DATA')
  decday_path = crres_survey_path+'data68'
 
  dataid=currPlotInfo.typeVector(0)

  get_data_call="r_crres_efi,"+strtrim(string(dataid),2) ;data read call used by slices
  
; as papco dynamically allocates slice values for the user defined
; slices, one needs to be able to find out this assignment! Use the
; following function to find out the slice values for any slices you
; might have added for your module, so that you know which values to enable!
  
  slice_assigned_value=papco_slice_value('Average_or_Integrate_Time_Series')
  
; set up which mouse functions to allow
  if(slice_assigned_value eq -1) then slice_assigned_value=0 
  slice_type=1+8+16+slice_assigned_value

  IF NOT IsRead THEN BEGIN      ; check if data has already been read
    r_crres_efi,dataid,currPlotInfo   ; read data
    ; check the read for success.
    IF papco_Draw_CheckResult(currPlotInfo.panelKind, $
                              panelVector, orbitNr, $
                              currPlotInfo.typeVector, $
                              currPlotInfo.channel)       THEN IsRead=1
  ENDIF
  
  IF IsRead THEN BEGIN
          p_crres_efi_line, panelVector, dataid, currPlotInfo, _EXTRA=extra_PlotInfo
  ENDIF
; Note: The structure extra_PlotInfo passed to the plot routine contains the
;       following tags: 
;                  overPlot               - overplot swittch
;                  plots_AtThisPosition   - no. of overplots here
;                  subtable               - index of papco colortable 
;                  PSYM                   - linestyle keyword for plot
;                  COLOR                  - linecolor keyword for plot
;               
;       They are set by papco and your plot routine can use them if you
;       want to support that functionality.
  IsRead = 0

END

