;*******************************************************************
;mjdt_date_day returns dates as mm/dd
;               modified from "mjdt_date_4" (written by Friedel)
;               by Doug Rowland

function mjdt_date_day, axis, index, t

   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'

   mjdt_now = mjdt_start

   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

  convert_t90_to_date,mjdt_now, $
        year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

  date_str=string(month,dom,format="(i2.2,'/',i2.2)")
  return,down_str+date_str

end
;*******************************************************************
;*******************************************************************
;mjdt_date_sec returns dates as hh:mm:ss
;               modified from "mjdt_date_4" (written by Friedel)
;               by Doug Rowland

function mjdt_date_sec, axis, index, t

   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'

   mjdt_now = mjdt_start

   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

  convert_t90_to_date,mjdt_now, $
        year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

  date_str=string(hour,minutes,sec,format="(i2.2,':',i2.2,':',i2.2)")
  return,down_str+date_str

end
;*******************************************************************
;mjdt_date_ms returns dates as ss.mss 
;                     modified from Friedel's mjdt_date_4
;                     by Doug Rowland
;
function mjdt_date_ms, axis, index, t
    
   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'

   mjdt_now = mjdt_start

   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

   convert_t90_to_date,mjdt_now, $
	 year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   ms = sec - floor(sec)

   date_str=string(sec,ms,format="(i2.2,'.',i3.3)")
   return,down_str+date_str

end
;**************************************************************
;function find_timeticksmjd
		  ;takes starttime,endtime in time in seconds
		  ;since the start of the first Modified Julian day
		  ;loaded into PAPCO (PAPCO standard)
		  ;spits out "nice" ticks
		  ;formatstring is the name of the routine that
		  ;should be used to label the ticks
;**************************************************************

pro find_timeticksmjd,tickvalues,formatstring,NTICKS=NTICKS

common mjdt, mjdt_start, mjdt_end

       ;if time difference is at least this big display ticks at even

print,'using the right TIMETICKS program'
NMINDAY         = 5.            ;DAYS
NMINHOUR        = 3.            ;HOURS
NMINMINUTE      = 20.           ;MINUTES
NMINSECOND      = 5.            ;SECONDS
NMINMILLISECOND = 2.            ;MILLISECONDS

NTICKDEF   = 6.            ;default is 6 ticks (5 tick intervals)
			   ;this is almost always modified by
			   ;find_timeticks90 as the idea is to
			   ;label ticks only at even minutes, hours,
			   ;seconds, or days (the NTICKS keyword
			   ;is just a suggestion - it can be useful
			   ;for a small prime number of time units)

MAXTICKS   = 12             ;the maximum number of ticks  
MINTICKS   = 2             ;the minimum number of ticks

DAYFORMATSTRING    = 'mjdt_date_day'
HOURFORMATSTRING   = 'mjdt_date_4'
MINUTEFORMATSTRING = 'mjdt_date_4'
SECONDFORMATSTRING = 'mjdt_date_sec'
MSFORMATSTRING     = 'mjdt_date_ms'

i=0 & j=0 & k=0            ;dummy variables

SELECTED_UNIT = "SOMETHING'S WRONG"

CHECKTIMES = [NMINDAY,NMINHOUR,NMINMINUTE,NMINSECOND,NMINMILLISECOND]

		;number of seconds in a day, hour, minute, second or ms
CONVERTTOSECONDS = [86400.,3600.,60.,1.,.001] 

CHECKNAMES = ['DAYS','HOURS','MINUTES','SECONDS','MILLISECONDS']

NTRIALS = fix(n_elements(CHECKTIMES))

NTICKSET = check_if_set(NTICKS)
if (not(NTICKSET)) then NTICKS = NTICKDEF

deltat = (mjdt_end.mjd-mjdt_start.mjd)*86400l+(mjdt_end.t-mjdt_start.t)

starttime= mjdt_start.t
endtime  = (mjdt_end.mjd - mjdt_start.mjd)*86400l + mjdt_end.t

for i=0,NTRIALS-1 do begin

   if (deltat ge CHECKTIMES(i)*CONVERTTOSECONDS(i)) then begin
     
     ;first find first and last whole day, hour, minute, or second

     stunit = ceil(starttime/CONVERTTOSECONDS(i))
     enunit = floor(endtime/CONVERTTOSECONDS(i))

     nunits = enunit - stunit+1
     if ((nunits mod (NTICKS) eq 0) and (NTICKSET)) then begin
        k = NTICKS & print,'found NTICKS!'
     endif else begin
	for j=MAXTICKS,MINTICKS,-1 do begin
	   if ((nunits mod j) eq 0) then begin
	      k=j
	      j=MINTICKS-1 & print,'found '+strtrim(string(k),2)
           endif
        endfor	
     endelse
    
     ;startday   = floor(starttime)
     
     if (k eq 0) then begin
	sttick     = (stunit*CONVERTTOSECONDS(i)) 
	entick     = (enunit*CONVERTTOSECONDS(i))
	tickvalues = [sttick,entick]
     endif else begin
       unitstep   = nunits/k
       tickvalues = findgen(k) * unitstep*CONVERTTOSECONDS(i)
       tickvalues = tickvalues + stunit*CONVERTTOSECONDS(i)
     endelse
     
     SELECTED_UNIT = CHECKNAMES(i)
     print,SELECTED_UNIT 
     i=NTRIALS
   endif
     
endfor


index = where((tickvalues ge starttime) and (tickvalues le endtime))
if (index(0) ne -1) then tickvalues = tickvalues(index)

case SELECTED_UNIT of
	  'DAYS'        : formatstring = DAYFORMATSTRING
	  'HOURS'       : formatstring = HOURFORMATSTRING
	  'MINUTES'     : formatstring = MINUTEFORMATSTRING
	  'SECONDS'     : formatstring = SECONDFORMATSTRING
	  'MILLISECONDS': formatstring = MILLISECONDFORMATSTRING 
	  else          : formatstring = "SOMETHING'S WRONG"   
endcase
end
