pro get_available_data_names,namelist,idlist

common data_path_list,crres_survey_path,decday_path

crres_survey_path=papco_getenv('CRRES_EFI_DATA')
decday_path = crres_survey_path+'data68'

CURR_AVAIL_IDS=[61,1,2,8,9,11,15,21,22,23,28,509,59,60,61,67]
;as of 2/16/1997 we have:
; 1 = Ey (MGSE) (cylinders) (corotating frame)
; 2 = Ez (MGSE) (cylinders) (corotating frame)
; 8 = Ey (MGSE) (spheres) (corotating frame)
; 9 = Ez (MGSE) (spheres) (corotating frame)
; 11= (V1+V2)/2 negative of spacecraft potential from spheres
; 15= (V3+V4)/2 negative of spacecraft potential from cylinders
; 21= Band Pass Filter centered at 32 Hz
; 22= Band Pass Filter centered at 256 Hz
; 23= Band Pass Filter centered at 2048 Hz
; 59= BYZMAG/BX Ex quality flag (<2-4 Ex is decent)
; 60= Ex from spheres 
; 61= Ex from cylinders
; 67= time in days since the start of 1990

nids = n_elements(CURR_AVAIL_IDS)
namelist = strarr(nids)
idlist   = intarr(nids)

get_all_info,result

for i=0,nids-1 do begin
  index = where(result.num eq CURR_AVAIL_IDS(i)) 
  info = result(index) 
  namelist(i) = info.name
  idlist(i)   = info.num
endfor

end 


