;***************************************************************
function crres_efi_ephemeris_xticks, axis, index, t

   COMMON mjdt, mjdt_start, mjdt_end
   COMMON shift_label, down

   resultstring = ''
   if (down gt 0) then begin 
     for i=0,down-1 do begin
       resultstring = resultstring+'!C'
     endfor
   endif
   mjdt_now = mjdt_start
   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t = mjdt_now.t - 86400l
      mjdt_now.mjd = mjdt_now.mjd + 1
   endif

   timezero = convert_tzero_to_t90(0,1,1990,/mjdt)
   day = mjdt_now.mjd - timezero.mjd
   day = day + mjdt_now.t/86400.

   start = fileloc_doy(day)
   
   dataidlist = [27,28,29]
   ephformat=['(F4.1)','(F3.1)','(F5.1)']
   for i=0,n_elements(dataidlist)-1 do begin
     read_crres_data,start,start,dataidlist(i),junk
     resultstring = resultstring+string(junk(0),format=ephformat(i))+'!C'
   endfor

return,resultstring
end
;******************************************************************************
;* file p_crres_efi_line.pro
;*
;* this file is a template for a plot routine which can be used by papco.
;* it includes all the periphery needed, the user simply has to add in
;* the actual plot statement for his/her kind of data.
;*
;* This is a working example for a pre-defined example data array.
;******************************************************************************
;******************************************************************************
;* PROCEDURE:     
;*      p_crres_efi_line, panel, type, $
;*           OVERPLOT=OVERPLOT,$
;*           PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           SUBTABLE=SUBTABLE, $
;*           _EXTRA=extra_par
;* 
;* DESCRIPTION:  
;*	This procedure plots data of type data_type for inclusion in papco.  
;*      Data must have been read and placed into common blocks before this
;*      routine is called. Behavior is controlled by the vector panel
;*	which controls positioning of the plot (see papco_conventions.text
;*      in $papco). In general, the following plot conventions are used:
;*              - if the panel is at the bottom plot time axis plus any
;*                additional axis (ie ephemeris) needed.
;*              - if panel is at the top also plot a title
;*              - a descriptor for panels is plotted to the right of each
;*                panel, rotated by 90 deg if there is a papco_colorbar.
;*              - panels all have common time
;*              - y-scaling (or z-scaling for color plots) is either
;*              - automatic or manualy set using common yscale or zscale   
;*
;* INPUTS:       
;*      panel   three element integer vector. Controls positioning of the plot
;*              (see papco_conventions.text in $papco)
;*      type    optional parameter for options. Normally is a four element
;*              integer vector. This is normally equivalent to the field
;*              typeVector of the papco structure papco_PLOTINFO which is set
;*              by the panel editor. Additional fields that can be used if
;*              needed are papco_plotinfo.ioptions (20 element vector) and 
;*              papco_PLOTINFO.channel (integer). If your plot routine needs
;*              more input fields than these you have to extend the definition
;*              of the structure papco_PLOTINFO
;*              (procedure papco_getPlotInfoStruct in $papco/papco.pro). Try to
;*              avoid this!
;*              
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      OVERPLOT  if you support this you can alter the appearance of your
;*              plot if it is an overplot to an existing panel. Standard is
;*              to plot data, no axis, using the y-scaling of the first plot
;*              and to shift the labeling on the left down one line. Useful
;*              to plot model data together with real data, ie mag. field.
;*              see p_crres_mag for an example.
;*      PLOTS_ATTHISPOSITION  used to control the left side labeling for more
;*              than one overplot at the same position.
;*      _EXTRA  the plot structure containing some keyword for calls to
;*              plot. Used to customize color and line style.   
;* 
;* CALLING SEQUENCE:
;*       p_crres_efi_line, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;*
;* MODIFICATION HISTORY:       
;*     written December 1995, Reiner Friedel, at Goddard
;******************************************************************************
pro p_crres_efi_line, panel, dataid, currPlotInfo, $
                      OVERPLOT=OVERPLOT, $
                      PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION, $
                      SUBTABLE=SUBTABLE, $
                      _EXTRA=extra_par

; NOTE: I use a little trick in passing in the keywords to to this
; routine. The calling routine's call is simply:
;         p_crres_efi_line, panelVector, currPlotInfo.typeVector(0), $ 
;                           _EXTRA=extra_PlotInfo
; extra_PlotInfo contains the tags OVERPLOT, PLOTS_ATTHISPOSITION,
; SUBTABLE and then some tags which are meant to be passed to the plot
; call. By putting in the explicit keywords in the procedure definition they
; get split out of the structure extra_PlotInfo that was passed in, and only
; those tags which are meant for the plot routine remain in extra_par.

; Comments here should include an explanation of the plot options used
; in type, swittch. Replace type in the call with whatever variables
; you need, or add more

; The following common blocks are needed:

   common mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
   common yscale, yscl			;man/auto yscaling
   common shift_label, down             ;common for x-axis label shifting
   common coordinateSystems, plotted_x, plotted_y  
                                        ;info on coords used by mouse

; One of the common blocks should contain the plot data as returned by the
; data read procedure r_crres_efi. 

   common crres_efi_data, input_header, input_data
  
   panelset,panel			;sets the panel position viewport

; option to automatically calculate ytick numbers in order to avoid to
; many ticks if panels get too narrow. Maximum is set to 10. You may
; leave this out and allow plot to use the built-in defaults.

   ytickno=50*(!p.position(3)-!p.position(1))
   if ytickno gt 10 then ytickno=10

; since there is a common time axis plots look better if they all use the same
; number of xticks. In papco, this number is 6 by default. This is set by papco
; using the IDL graphics system variable !X.TICKS.
; You can override this for your own plot by setting the variable
; below. However, for plotting panels together, it makes sense to stick to the
; default. If you do set this variable, it needs to be included in the 
; extra_plotPar_common definition below.

;   xtickno=6

; NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! 
; Avoid setting the global IDL graphics system variables in your plot routine,
; as they may affect other modules' plot routines. The IDL graphics system 
; variables are set by papco to default values that guarantee some uniformity
; of plot appearance and should not be tampered with - unless you don't
; care if your plot "looks good" when combined with the other modules.
; NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! 

; the plot-calls normally use the arrays time for the time axis and yarr (ymat 
; for color plots) for the y or z axis.
; depending on your plot options, different data may be selected and different
; axis-labeling may be needed. This is normally done using a case statement.
; In this example the data array consist of flux values in ten channels 
; at different energies, typical of particle spectrometer data. Here I use the
; channel information passed in the plotinfo structure from the panel editor
; to select the channel to be drawn.

; set the begin end end times. papco convention is to use running seconds
; starting with the no of seconds since the beginning of the start day.
   time=input_data.time
   xut1=mjdt_start.t                       
   xut2=long(mjdt_end.mjd-mjdt_start.mjd)*86400l+mjdt_end.t

   yray = input_data(*).dat
   datainfostruct = get_one_info(dataid)
   utitle = datainfostruct.ptitle
   uytitle = datainfostruct.unit
   if (currPlotInfo.typevector(1) gt 1) then begin
      utitle=utitle+'!Csmoothed over!C'+string(currPlotInfo.typevector(1),format='(I2)')+' points'
   endif

; restrict data to actual time range requested - this makes for faster zooming

   index=where((time ge xut1) and (time le xut2),count)
   if count ne 0 then begin
      yray=yray(index)
      time=time(index)
      if ((n_elements(time) eq 1) and (n_elements(yray) eq 1)) then begin
	 time = [0,10,100]
	 yray = [9,99,999]
      endif
   endif
   ;ylim3,time,yray,yst,yen
   goodindex = where(yray ne 99999)
   if (goodindex(0) ne -1) then begin
      ymn = min(yray(goodindex))
      ymx = max(yray(goodindex))
      dty = ymx - ymn
      yst = ymn - .1*dty
      yen = ymx + .1*dty
   endif else begin 
      yst = 0
      yen = 99999
   endelse
   if (yst eq yen) then begin
     yst = yst - .5
     yen = yen + .5
     xut1 = xut1 -1.
     xut2 = xut2 +1.
   endif

; the variables used above have the following meaning:
; 	uytitle : the y-axis label
;	utitle  : the right-of plot label defining the data
;
; the procedure YLIM3 is optional and sets the ylimit automatically for the
; data leaving a 10% gap at the top and bottom limits.
; this routine is very simple and does not handle spikes or bad data, you may
; need to supply your own procedure for your own data. 
; (in $papco/papco_Lib/ylim.pro)

; yscl of common block yscale is an array of dimensions (*,4) and contains info
; on the yscaling to be used. The first dimension identifies the panel, and the
; next dimension has three entries:  
;         yscl(*,0)  is  0 for "use automatic scaling", 1 for "use manual"
;         yscl(*,1)  is then ymin (or zmin)
;         yscl(*,2)  is then ymax (or zmax)
;         yscl(*,3)  is 0 for "linear" and 1 for "log"  scale
; when scaling is set to automatic, the automatic y-limits are loaded in.
   
   if (yscl(panel(0),0) eq 1) then begin
      yst=yscl(panel(0),1)
      yen=yscl(panel(0),2)
   endif else begin
      yscl(panel(0),1)=yst
      yscl(panel(0),2)=yen
   endelse

; set up extra plot keywords, common ones first. 
; yrange, xrange  are always needed. 
; the rest you can set if you want to override papco defaults.
; See $papco_BASE/papco/papco_draw for the definition of the papco default
; graphic system variable settings.

   extra_plotPar_common={yrange:[yst,yen], xrange:[xut1,xut2], $
                         yticks:ytickno, ytitle:uytitle, $
                         ylog:yscl(panel(0),3)}
   
; check if the passed-in structure extra_par was set. If not, create
; it and set color to default black; which for the color table used by
; papco is 1. If extra_par was set, see if the tag color exists. If it
; does, leave it unchanged, if not, add it and set color to default
; black. 

  if n_elements(extra_par) EQ 0 then extra_par={color:1} else begin
    names=tag_names(extra_par)
    res=where(names eq 'COLOR',count)
    if count eq 0 then extra_par=create_struct({color:1}, extra_par)
  endelse     
   
; add keyword structure set here with the one passed in

   extra_plotPar_common=create_struct(extra_plotPar_common, extra_par)

; extend this structure by those keywords specific to the plot being bottom
; panel or not. 
; You might have to add your own xtickformat for time axis labeling. If you 
; stick to the papco convention of having your plot  time array having 
; consecutive seconds from midnight of the start day, then  you can use the 
; pre-defined xtickformat functions defined in ticks.pro in
; papco_Lib/axis_label.
; You can at this point also define a custom ytickformat, or leave it out for
; IDL default plot behavior.
; down sets the axis labeling level

   find_timeticksmjd,xtickvals,xtickformatstring,nticks=6
   nticks=n_elements(xtickvals)
   down=0
   if panel(0) eq 0 then $
     extra_plotPar=create_struct({xtickformat:xtickformatstring,xticks:nticks-1,xtickv:xtickvals}, $
                                  extra_plotPar_common) $
   else $
     extra_plotPar=create_struct({xtickformat:'noticks',xtickv:xtickvals,xticks:nticks-1}, $
                                  extra_plotPar_common)

; To keep things general, plotting of the data is split up into plotting the 
; axis with no data, and then plotting the data with no axis. This is done to 
; enable the feature of overplots, which just plot data into an existing axis.
; plot the axis in color=1, and only plot axis if if you're NOT over-plotting!
; down sets the axis labeling level (adds carriage returns [!C] to labels).

   down=0
   color1_plotpar=extra_plotPar
   color1_plotpar.color=1

   if not keyword_set(overplot) then $
               plot,time,yray, _extra=color1_plotPar, /NODATA,xstyle=1,ystyle=1

; now do the actual data plot, data only, no axis

   plot,time,yray, _extra=extra_plotPar, xstyle=5, ystyle=5

; now plot an axis at y=0 if necessary

   if (yst*yen lt 0) then plots,!X.CRANGE,[0,0],linestyle=2,color=1

; store the coordinate information into common block for slices

   plotted_x = !x
   plotted_y = !y

; plot extra x-axis labels (eg. ephemeris) and a x-axis label if required.
; plot in color=1. Example here adds an axis with date information.
; The routine x_side_label puts x-axis label to the right of the axis.
; If you stick to the papco convention of always having your plot 
; time array having consecutive seconds from midnight of the start day, then 
; you can use the pre-defined xtickformat functions defined in ticks.pro in
; papco_Lib/axis_label.
; Or use any other function you define yourself.
; down sets the axis labeling level

  if ((panel(0) eq 0) and (not keyword_set(OVERPLOT)) and (xtickformatstring ne 'mjdt_date_day')) then begin
     extra_plotPar=create_struct({xtickformat:'MJDT_DATE_DAY',$
				  xtickv:xtickvals,xticks:nticks-1$
				  }, $
                                 extra_plotPar_common) 
     extra_plotPar.color=1     
     down=1
     plot,time,yray, _extra=extra_plotPar, /NODATA,xstyle=1,ystyle=1
     x_side_label,panel,'time (UT)!CDate'
     extra_plotPar=create_struct({xtickformat:'crres_efi_ephemeris_xticks',$
				  xtickv:xtickvals,xticks:nticks-1$
				  }, $
                                 extra_plotPar_common) 
     extra_plotPar.color=1     
     down=2
     plot,time,yray, _extra=extra_plotPar, /NODATA,xstyle=1,ystyle=1
     x_side_label,panel,'!C!CMLT!CL!CMLat'    
  endif

; plot info right of the panel. If you want overplots to have their own labels
; you need to add position-control for this label using the keyword
; PLOTS_ATTHISPOSITION

   if not keyword_set(overplot) then begin
     right_side_label,panel,utitle,_extra=extra_Par
   endif else begin
     for i=0, PLOTS_ATTHISPOSITION-1 do utitle='!C'+utitle
     right_side_label,panel,utitle,_extra=extra_Par
   endelse

end
