;*****************************************************
; WAVEPOYNT.pro
;
; calculate the FAC components of wave poynting flux
; (in corot. frame)
; 

pro wavepoynt,start,stop

BADVAL = 99999.0
CONST  = .79577
NDETRENDPOINTS = 15.*2.    ;15 minutes
NAVGMAGFIELDPOINTS = 15.*2. ;15 minutes


read_crres_data,start,stop,521,bxsm,time
read_crres_data,start,stop,522,bysm
read_crres_data,start,stop,523,bzsm
read_crres_data,start,stop,515,exsm
read_crres_data,start,stop,516,eysm
read_crres_data,start,stop,517,ezsm
read_crres_data,start,stop,529,xsm
read_crres_data,start,stop,530,ysm
read_crres_data,start,stop,531,zsm



npts = n_elements(bxsm)
emsm = fltarr(npts)
easm = emsm
epsm = emsm
bmsm = emsm
bpsm = emsm
basm = emsm

for i=0L,npts-1 do begin
    bxsms = smooth(bxsm,NAVGMAGFIELDPOINTS)
    bysms = smooth(bysm,NAVGMAGFIELDPOINTS)
    bzsms = smooth(bzsm,NAVGMAGFIELDPOINTS)
    bsmmag = sqrt(bxsms(i)^2+bysms(i)^2+bzsms(i)^2) 
    bxsmun = bxsms(i)/bsmmag
    bysmun = bysms(i)/bsmmag
    bzsmun = bzsms(i)/bsmmag
        zx = bxsmun
	zy = bysmun
	zz = bzsmun
	yx = (ysm(i)*zz - zsm(i)*zy)
	yy = (zsm(i)*zx - xsm(i)*zz)
	yz = (xsm(i)*zy - ysm(i)*zx)
      ymag = sqrt(yx^2 + yy^2 + yz^2)
        yx = yx/ymag
        yy = yy/ymag
        yz = yz/ymag
	xx = (yy*zz - yz*zy)
        xy = (yz*zx - yx*zz)
        xz = (yx*zy - yy*zx)
    rotmat = [[xx,xy,xz],$
              [yx,yy,yz],$
	      [zx,zy,zz]]
 inputvect = [[exsm(i)],[eysm(i)],[ezsm(i)]]
outputvect = rotmat##inputvect
   emsm(i) = outputvect(0,0)     ;radial inward e field
   easm(i) = outputvect(0,1)     ;westward e field
   epsm(i) = outputvect(0,2)     ;"parallel" e field
 inputvect = [[bxsm(i)],[bysm(i)],[bzsm(i)]]
outputvect = rotmat##inputvect
   bmsm(i) = outputvect(0,0)     ;radial inward b field
   basm(i) = outputvect(0,1)     ;westward b field
   bpsm(i) = outputvect(0,2)     ;"parallel" b field

endfor

easm1 = easm - smooth(easm,NDETRENDPOINTS)
epsm1 = epsm - smooth(epsm,NDETRENDPOINTS)
emsm1 = emsm - smooth(emsm,NDETRENDPOINTS)
basm1 = basm - smooth(basm,NDETRENDPOINTS)
bpsm1 = bpsm - smooth(bpsm,NDETRENDPOINTS)
bmsm1 = bmsm - smooth(bmsm,NDETRENDPOINTS)


wpr = CONST * (easm1*bpsm1 - epsm1*basm1)
wpa = CONST * (epsm1*bmsm1 - emsm1*bpsm1)
wpp = CONST * (emsm1*basm1 - easm1*bmsm1)

bmag = sqrt(basm^2 + bpsm^2 + bmsm^2)
dvr  = 1000. * (easm1*bpsm1 - epsm1*basm1)/(bmag^2)
vr = 1000. * (easm1*(bpsm-bpsm1)  - epsm1*(basm-basm1))/(bmag^2)

index = where((exsm eq BADVAL)or(eysm eq BADVAL)or(bxsm eq BADVAL) or (ezsm eq BADVAL)or(bzsm eq BADVAL) or (bysm eq BADVAL))

if (index(0) ne -1) then begin
   wpr(index) = BADVAL
   wpa(index) = BADVAL
   wpp(index) = BADVAL
endif

STOP
end
