;******************************************************************************
;* file papcoadd_crres_efi_overview
;*      papcoadd_crres_efi_overview_line
;*      papcoadd_crres_efi_overview_spectra
;* end
;*
;*    These procedures are contained:
;*
;*    PRO addplottype_crres_efi_overview,plottypes_base,pb_plottype
;*        ->  adds the button for the new plot type to the main window.
;*
;*    PRO plottable_crres_efi_overview, plottable
;*        -> Sets a variable to indicate plottable without orbit.
;*
;*    PRO canget_crres_efi_overview, canget
;*        -> Sets a variable to indicate output to file is supported.
;*
;*    PRO descriptor_crres_efi_overview, plotInfo, descriptStr
;*        -> Constructs the string used to label plots in the panels window
;*
;*    PRO addpanel_crres_efi_overview
;*        -> Calls the panel editor for this plottype and adds the plot to the
;*            panel window.
;*
;*    PRO editor_crres_efi_overview, plotNumber, newPlotData
;*        -> This procedure calls the panel editor when called from 
;*           papco_EditPlot (papco_paneledit.pro).
;*
;*    PRO  draw_crres_efi_overview, panelVector, currPlotInfo, get_data_call, IsRead
;*        -> This procedure performs the actual data read call and the plot 
;*           call for this plottype
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      PRO addplottype_crres_efi_overview,plottypes_base,buttonGeometry,pb_plottype
;* 
;* DESCRIPTION:  
;*      This procedure adds a button for this crres_efi_overview to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*      package, so that they can be automatically called when needed.
;*      The button itself can contain access to a sub-menu for further
;*      crres_efi_overviews.
;*
;* INPUTS:       
;*      plottypes_base  the widget ID of the parent widget to contain the
;*                      plottype buttons.
;*
;* OUTPUTS: 
;*      pb_plottype     the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for sub-types.
;*
;* KEYWORDS:
;*       none
;* 
;* CALLING SEQUENCE:
;*      addplottype_crres_efi_overview,plottypes_base,buttonGeometry,pb_plottype
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro addplottype_crres_efi_overview,plottypes_base,buttonGeometry,pdm_crres_efi_overview


  MenuDesc = [ $
        { CW_PDMENU_S, 3, strcenter('efi_overv',10) }, $ 
        { CW_PDMENU_S, 0, ' configure efi_overview ' }, $
        { CW_PDMENU_S, 0, ' crres_efi_overview_spectra' }, $
        { CW_PDMENU_S, 2, ' crres_efi_overview_line ' } ]  
  
  pdm_crres_efi_overview = CW_PDMENU(plottypes_base, MenuDesc, $
                            UVALUE='pdm_crres_efi_overview')
  
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO addpanel_crres_efi_overview
;*
;* DESCRIPTION:  
;*      Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      Using an instance of the papco_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled. The
;*      desired default values for the plotinfo tags need to be edited by
;*      the user. This plotinfo structure will be passed to the panel editor
;*      When it is first called for the crres_efi_overview.
;*      "panelEditor" must be set to the name of the panel editor routine.
;*
;* INPUTS:       
;*      event           event value of papco main window. This is
;*                      only used if there are plot sub_types, 
;*                      for example see papcoadd_crres_plots
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      addpanel_crres_efi_overview
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;***************************************************************************
pro addpanel_crres_efi_overview,event
  
  common get_error, get_err_no, get_err_msg
  
; The case statement here needs an entry for every submenu type you
; added in  the first procedure in this file (addplottype_crres_efi_overview).
; For each submenu entry, you will need to specify the panelEditor to use.  
  
; The FIRST time you use this module you will have to configure it,
; i.e. set the data paths etc. Once you have done this PAPCO will
; write a crres_efi_overview.config file into your papco_user_XX/papco_modules_defaults
; directory. 
; So here we check if this crres_efi_overview.config file exists, and if not,
; we diallow the execution of any other option apart from "configure
; crres_efi_overview". In this way the user is forced to configure the module
; before using it the first time!
  
  r_module_config, strlowcase('crres_efi_overview'), config_data, msg
  if (get_err_no ne 0) and (event.value ne 1) then begin
    print,'%addpanel_crres_efi_overview: You need to configure the module first'
    papco_module_configure,'crres_efi_overview'
    return
  endif  
 
  CASE event.value of
    1: BEGIN
        papco_module_configure,'crres_efi_overview'
    end
    2: BEGIN
        panelKind='crres_efi_overview_spectra'
        panelEditor=panelkind+'_panel'
        defaults=papco_getPlotInfoStruct() ;returns a basic plotinfo structure
        defaults.typeVector=[0,0,0,0]      ;set some tags to desired defaults
        defaults.channel=0            
        defaults.ylinlog=0
        defaults.zlinlog=0
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults     
    end
    3: BEGIN
        panelKind='crres_efi_overview_line'
        panelEditor=panelkind+'_panel'
        defaults=papco_getPlotInfoStruct() ;returns a basic plotinfo structure
        defaults.typeVector=[0,0,0,0]      ;set some tags to desired defaults
        defaults.channel=0            
        defaults.ylinlog=0
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults     
    end
    else: begin
      print,'%addpanel_crres_efi_overview: Nothing defined for this submenu entry'
      return
    end  
  endcase
      
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO plottable_crres_efi_overview, plottable
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate plottable with / without orbit.
;*      PAPCO provides "set time by orbit" feature for CRRES and POLAR
;*      so far. Included for compatibility with older CRRES modules
;*      which ONLY use orbit as input to their read/plot routines
;*      (plotting over orbit boundaries is not enabled for CRRES)
;* 
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "plottable_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_crres_efi_overview.
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      plottable        a boolean 0 if plottable only by orbit
;*                                 1 if plottable by time also.
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      plottable_crres_efi_overview, plottable
;*
;* MODIFICATION HISTORY:       
;*      written November 1995, Reiner Friedel
;******************************************************************************
pro plottable_crres_efi_overview_spectra, plottable

   plottable=1     ; 1 -> plotable without orbit info, by time 
                   ; 0 -> plotable only by orbit number not by time 
END
pro plottable_crres_efi_overview_line, plottable

   plottable=1     ; 1 -> plotable without orbit info, by time 
                   ; 0 -> plotable only by orbit number not by time 
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO canget_crres_efi_overview, canget
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate that crres_efi_overview is capable of
;*      returning data from it's plot routine into a standard PAPCO
;*      array structure. Used for the scratch pad utility module.
;*      
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "canget_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_crres_efi_overview.
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      canget         a boolean 0 if this feature is not available
;*                                1 if this feature is available
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      canget_crres_efi_overview, canget
;*
;* MODIFICATION HISTORY:       
;*      written November 1997, Reiner Friedel
;******************************************************************************
pro canget_crres_efi_overview_spectra, canget

   canget=  1      ; 1 -> plot routine can return just data to file
                   ; 0 -> feature disabled
END
pro canget_crres_efi_overview_line, canget

   canget=  1      ; 1 -> plot routine can return just data to file
                   ; 0 -> feature disabled
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO descriptor_crres_efi_overview, plotInfo, descriptStr
;*
;* DESCRIPTION:  
;*      Constructs the string used to label plots in the panel window.
;*      The plotinfo structure passed in here is the panel's plotinfo
;*      as returned by the panel editor for this crres_efi_overview. You can use
;*      the information in that structure to construct some informative
;*      label for the panel which then appears in the Panel Compose list.
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "descriptor_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_crres_efi_overview.
;*
;* INPUTS:       
;*      plotInfo        structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*      descriptStr     a string containing the label
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      descriptor_crres_efi_overview, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro descriptor_crres_efi_overview_spectra, plotInfo, descriptStr

     descriptStr=descriptStr+'EFI overview  plot'
   
END
pro descriptor_crres_efi_overview_line, plotInfo, descriptStr

     descriptStr=descriptStr+'EFI overview  plot'
   
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO editor_crres_efi_overview, plotNumber, newPlotData
;* 
;* DESCRIPTION:  
;*      This procedure calls the panel editor when called from 
;*      papco_EditPlot (papco_paneledit.pro). Provided here to allow
;*      several crres_efi_overviews to share a common panel editor. Normally this
;*      procedure does not need to be edited beyond the required name
;*      change for crres_efi_overview.
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "editor_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_crres_efi_overview.
;*
;* INPUTS:       
;*      plotNumber      anInteger. 0<=plotNumber<=widgetData.numberOfPlots
;*                      the index of the plot in widgetData.plotInfos.
;*            
;* OUTPUTS: 
;*      newPlotData     the new structure returned by the panel editor
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      editor_crres_efi_overview, plotNumber, newPlotData
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
PRO editor_crres_efi_overview_spectra, plotNumber, newPlotData

  COMMON PLOT_COMPOSER, widgetData

   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=crres_efi_overview_spectra_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
      GROUP=widgetData.main_base)

END
PRO editor_crres_efi_overview_line, plotNumber, newPlotData

  COMMON PLOT_COMPOSER, widgetData

   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=crres_efi_overview_line_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
      GROUP=widgetData.main_base)

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO draw_crres_efi_overview, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:  
;*      This procedure performs the actual data read call and the plot call
;*      for this plottype. The user need to pass to his plot routine all the
;*      parameters needed, typically these parameters are stored in the 
;*      currplotinfo structure or constructed from them. The currplotinfo
;*      structure tags normally used for passing information from the panel
;*      editor to the plot routine are:
;*          type_vector - a four element array for choosing the type of data
;*                        (eg. elec or ion, diff or integ., pitch angle, 
;*                             or sector, channel ....)
;*          swittch      - a three element vector for specific plot appearance
;*                        (eg. smoothing/averaging, interpolating ...)
;*          filename    - a filename
;*      
;*      These tags have grown out of traditional usage and can be used for
;*      anything the user wants to use them for. There are plenty variables
;*      for most applications: Adding a new tag to the plotinfo structure
;*      is not user-definable but need to be done at the papco core level.
;* 
;*      The panelVector MUST be passed to your plotroutine as it is used
;*      to set the panel position.
;*      The _EXTRA=extra_PlotInfo should be passed if you intend to make use
;*      of papco functionality such as overplotting, linestyle choice and
;*      color bar choice.
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "draw_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_crres_efi_overview.
;*
;* INPUTS:       
;*      panelVector    position of the plot (see papco_conventions.text, 6)
;*      currPlotInfo   structure containing all data for this plot.
;*                     (structure papco_PLOTINFO, see papco_variables.text) 
;*
;* OUTPUTS: 
;*      get_data_call  a string containing the data call. Used by other
;*                     routines that need to know how to get the data
;*                     in a panel, e.g. to draw spectra, distribution functions
;*      IsRead         a boolean which is set when the the data is read the
;*                     first time. Useful if a given data-read puts data
;*                     into commons which can be plotted in many ways.
;*                     When set, data does not have to be read again.
;   slice_type:   Selects which slices are supported and for which slice
;                 routines have been written.
;                 This is an integer logical with 16 swittches. Currently
;                 there are 5 papco slices. You may extend this by
;                 further USER slices up to a total of 16 slices.
;                     0 = disable all slices
;                     1 = papco Zoom                 (2^0)
;                     2 = papco View Slice           (2^1)
;                     4 = papco Access level Zero    (2^2)
;                     8 = papco Write Paneldata      (2^3)
;                    16 = papco Hair Cursor          (2^4)
;                    32 = USER slice A or not used   (2^5)
;                    64 = USER slice B or not used   (2^6)
;                    "     "     "   "  "  "    "      "    
;                 32768 = USER slice Z or not used  (2^15)
;                        
;   You can support more than one type of slice by arithmetically adding the
;   options, eg slice_type=1+4  support Zoom and Level Zero
;*
;* KEYWORDS:
;*      OUTPUT        if set then plot routine should output data to file,
;*                    as well as to screen.
;*
;* 
;* CALLING SEQUENCE:
;*      draw_crres_efi_overview, panelVector, currPlotInfo, orbitNo, $
;*                      get_data_call, slice_type, IsRead, NODATA=NODATA
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro draw_crres_efi_overview_spectra, panelVector, currPlotInfo, orbitNo, $
                    get_data_call, slice_type, IsRead, $
                    OUTPUT=OUTPUT

  COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
    
  get_data_call="r_crres_efi_overview"   ; data read call used by slices

; set up which mouse functions to allow
  slice_type=1+2+4+8+16
  
  IsRead=0
  IF NOT IsRead THEN BEGIN      ; check if data has already been read
    r_crres_efi_overview, currPlotInfo.typeVector ; read data
    ; check the read for success.
    IF papco_Draw_CheckResult(currPlotInfo.panelKind, $
                              panelVector, orbitNr, $
                              currPlotInfo.typeVector, $
                              currPlotInfo.channel)       THEN IsRead=1
  ENDIF
  
  
  IF IsRead THEN BEGIN
    p_crres_efi_overview_spectra, panelVector, currPlotInfo.typeVector, $
      OUTPUT=OUTPUT, _EXTRA=extra_PlotInfo
  ENDIF

; Note: The structure extra_PlotInfo passed to the plot routine contains the
;       following tags: 
;                  overPlot               - overplot swittch
;                  plots_AtThisPosition   - no. of overplots here
;                  subtable               - index of papco colortable 
;                  PSYM                   - linestyle keyword for plot
;                  COLOR                  - linecolor keyword for plot
;               
;       They are set by papco and your plot routine can use them if you
;       want to support that functionality.

END

pro draw_crres_efi_overview_line, panelVector, currPlotInfo, orbitNo, $
                    get_data_call, slice_type, IsRead, $
                    OUTPUT=OUTPUT

  COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
    
  get_data_call="r_crres_efi_overview"   ; data read call used by slices

; set up which mouse functions to allow
  slice_type=1+2+4+8+16
  
  IsRead=0
  IF NOT IsRead THEN BEGIN      ; check if data has already been read
    r_crres_efi_overview                ; read data
    ; check the read for success.
    IF papco_Draw_CheckResult(currPlotInfo.panelKind, $
                              panelVector, orbitNr, $
                              currPlotInfo.typeVector, $
                              currPlotInfo.channel)       THEN IsRead=1
  ENDIF
  
  
  IF IsRead THEN BEGIN
    p_crres_efi_overview_line, panelVector, channel, OUTPUT=OUTPUT, $
      _EXTRA=extra_PlotInfo
  ENDIF

; Note: The structure extra_PlotInfo passed to the plot routine contains the
;       following tags: 
;                  overPlot               - overplot swittch
;                  plots_AtThisPosition   - no. of overplots here
;                  subtable               - index of papco colortable 
;                  PSYM                   - linestyle keyword for plot
;                  COLOR                  - linecolor keyword for plot
;               
;       They are set by papco and your plot routine can use them if you
;       want to support that functionality.

END
