;******************************************************************************
;*  NAME:        r_crres_efi_overview
;*
;*  DESCRIPTION: Routine to read crres_efi_overview files. Adheres to
;*               papco conventions: Error common block
;*                                  Uses MJDT time
;*                                  papco read philosophy
;*
;*  INPUT:       none (uses common block time from papco)
;*
;*  OUTPUT:      none (places data into common blocks)
;*
;*  KEYWORDS:    VERBOSE  -  enables print comments, save/restore comments
;*
;*  DATE:        June 1996
;*
;*  AUTOR:       R. Friedel
;*
;*  CHANGES:     February 1997. Used MJDT time now, and is a fully
;*               running example module on it's own
;*               October 1997. Rewritten to be more general and fully
;*               adhering to papco philosophy. Added remore Get feature, and
;*               the example data file is no longer part of the 
;*               module - it needs to be gotten remotely first!
;******************************************************************************
pro r_crres_efi_overview,what, VERBOSE=VERBOSE
  
  
  common crres_efi_overview, info, lsum, valdat
  common crres_efi_overview_extra, time, sp, lbin, lrange
  
  common mjdt, mjdt_start, mjdt_end ;common time limit in mjdt
  common get_error, get_err_no, get_err_msg
  
  lsum=0
  valdat=0
  
  sp=0
  lbin=0.0
  paequ=0
  lrange=0.0
  type=0
  efi_modes=[61,1,2,60,8,9,110,116,111]
  
  get_err_no=0
  get_err_msg='LAV-file read successfully'
  
  cpath=papco_getenv('crres_efi_overview')
  if strmid(cpath,strlen(cpath)-1,1) ne '/' then cpath=cpath+'/' 
  
  if strlen(cpath) eq 0 then begin
    get_err_no=1
    get_err_msg='LAV environmental variable (crres_efi_overview) not set'
    print,get_err_msg
    return
  endif

  fl='crres_efi_lsrt_'+string(efi_modes(what(0)),format="(i2.2)")
  fln=cpath+fl+'.idl'
  print,'% r_crres_efi_overview: Reading ',fl
  openr, f_unit ,fln, ERROR=err, /GET_LUN
  IF err EQ 0 THEN BEGIN
    readu,f_unit,type,sp,lbin,lrange,paequ
    print,'% r_crres_efi_overview: Header',sp,lbin,lrange
    
    nobins=(lrange-1)/float(lbin)+1
    lsum=  fltarr(sp,nobins)
    valdat=fltarr(sp,nobins)
    info=  fltarr(sp,5)
    
    readu,f_unit,info,lsum,valdat
    
    close,f_unit
    free_Lun, f_unit
    
  ENDIF ELSE BEGIN
    print, fln+'  : binary not available.'
    get_err_no=2
    get_err_msg=!ERR_STRING
    print, !ERR_STRING
    RETURN
  ENDELSE
  
  if keyword_set(OLDTIME) then goto, out
  
; convert the times to mjdt standard ready to plot. Since plot is float
; accuracy convert times here to mjd decimal day, ie mjd +daysec/86400
  res=size(info)
  sp=fix(res(1))
  time=dblarr(sp,2)             ;to keep the times for the two rad belt traverses
  for i=0,sp-1 do begin
    if info(i,3,0) ne 0 then begin
      year=info(i,0)
      doy =info(i,1)
      sec =info(i,2)
      t=convert_date_to_t90(doy=doy,year=year,seconds=sec,/mjdt)
      time(i,0)=t.mjd + double(t.t / 86400.0)
                                ;print,i,time(i,*),format="(i4,4(f10.2))"
      sec =info(i,4)
      t=convert_date_to_t90(doy=doy,year=year,seconds=sec,/mjdt)
      time(i,1)=t.mjd + double(t.t / 86400.0)
    endif
    
  endfor
  
; restrict array to the range handed in be mjdt_start and mjdt_end
  
  st = mjdt_start.mjd + mjdt_start.t / 86400.0
  ed =  mjdt_end.mjd +  mjdt_end.t / 86400.0
  
  index=where((time(*,0) ge st) and (time(*,1) le ed),count)
  if count ge 2 then begin
    time=temporary(time(index,*))
    info=temporary(info(index,*,*))
    lsum=temporary(lsum(index,*,*,*))
    valdat=temporary(valdat(index,*,*,*))
  endif
  sp=count
  
  if count lt 2 then begin
    get_err_no=2
    get_err_msg='No Data found in timerange'
    print,get_err_msg
    return    
  endif  
  
out:
  
end
