
;------------------------------------------------------------------------------
;* Sets up some common blocks for the polar ephemeris module.
;* Needs to be compiled and called befroe module is used, done in init_module
PRO crres_eph_commons

COMMON crres_ephemeris, orig_names, crres_eph_control

;str arr containing coord labels, units, unit format string.
orig_names = [$
   'XSAT',' YSAT',' ZSAT',' XRAD',' XALT ','XLAT',' XLONG','XLT',' XMLT', $
   'XILAT',' XLSHEL',' BTEPF',' BYEPF',' BZEPF',' VXEPF',' VYEPF',' VZEPF']

;finally, set up a structure for all the variables needed by the
;crres eph module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains moe
;descriptive and verbose tags for easier use.
crres_eph_control = {$
  product:0,    product_info:'Index into orig_names, choice of original '+$
                             'ephemeris coord', $pe
  orig:0,       orig_info:'original (0) or model (1) coords'}

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to polar_eph_control

crres_eph_control = CREATE_STRUCT(name = 'crres_eph_control', $
                       crres_eph_control, $
                       papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))
END

