; Program to read crres ephemeris files from SSC and to convert them to the
; COMMON INTERFACE fortran format needed by the UNIRAD package

pro crres2cif_ssc

;read in SSC ascii file of ephemeris - split up into orbits, output in
;                                      UNIRAD V3.0 CIF format
  
  path='/data/crres/EPHEMERIS/CIF/'
  openr,unit,path+'crres_ssc.txt',/get_lun
  junk='' & year=0 & doy=0 & hour=0 & sep=' ' & min=0
  lon=0.0 & lat=0.0 & rad=0.0 & orb=1 & pertime=0.0 & oldper=0.0
  radrec=fltarr(3)
  
  ;read the header info
  for i=0,39 do readf,unit,junk
  
  ;read the first two records to initialise perigess checking
  for i=0,1 do begin
    readf,unit,year,doy,hour,sep,min,lat,long,rad, $
      format="(i4.4,i4,i3,a1,i2,f8.3,f8.3,f11.2)"
    radrec=[rad,radrec]
    radrec=radrec(0:2)  
  endfor  
    
  while not eof(unit) do begin
  ;for i=0,1400 do begin

    readf,unit,year,doy,hour,sep,min,lat,long,rad, $
      format="(i4.4,i4,i3,a1,i2,f8.3,f8.3,f11.2)"
    
    radrec=[rad,radrec]
    radrec=radrec(0:2)
    diff=[radrec(0)-radrec(1),radrec(1)-radrec(2)]
    
    if rad lt 7000.0 then begin
      if (diff(0) gt 0) and (diff(1) lt 0) then begin
        fln='crres'+string(orb,format="(i4.4)")+'.int'
        pertime=doy+(hour+min/60.0)/24.0
        print,fln,year,doy,hour,min,rad,pertime-oldper
        orb=orb+1
        oldper=pertime
      endif  
    endif  
    
  ;endfor
  endwhile  
    
  close,unit
  free_lun,unit
  
end

;*****************************************************************************
pro crres2cif
  
   common crres_eph_data, input_header, input_data
   common get_error, get_err_no, get_err_msg   
   
 ; check for env. variable pointing to data directory
   data_dir='crres_EPH_DATA'
   c_path=papco_getenv(data_dir)
   if strlen(c_path) eq 0 then begin
     get_err_no=1
     get_err_msg='Environmental variable '+data_dir+' not set'
     print,get_err_msg
     return
   endif
   
   out_path='/data/crres/EPHEMERIS/CIF/'
   check=findfile(out_path+'*.int',count=chn)
   checkin=findfile(c_path+'archive/*.txt',count=chn)

  for i=3,1067 do begin            ;loop through all orbits  
   
    file_id='crres_EPH_'+string(i,format="(i4.4)")

    hour=0 & min=0 & sec=0.0 & doy=180
    apog=42000 & perig=380
    incl=17
    outfile=out_path+file_id+'.int'
    
    result=strpos(check,outfile)
    index=where(result ne -1,chn)
    if chn eq 1 then begin
      ;print,'%crres2cif: ',outfile,' already exists'
      goto,next
    endif  
    
    infile='e'+string(i,format="(i4.4)")+'.txt'
    result=strpos(checkin,infile)
    index=where(result ne -1,chn)
    if chn eq 0 then begin
      ;print,'%crres2cif: ',infile,' does not exist'
      goto,next
    endif  
    
    r_crres_eph, orbit=i
    if get_err_no ne 0 then goto, next
    
    t=convert_date_to_t90(doy=input_header.doy, $
                          year=input_header.year,/MJDT)
    t.mjd=t.mjd-33282.0    ;convert to Mod. Jul. Day since 1950
    convert_t90_to_Date, t, yr, day_oy, hour, min, sec, $
			      mon, cmonth, day, /MJDT    
    
;HEADER RECORDS - all must be 178 bytes/characters long!
    Head_rec_1=string('crres ephemeris','',format="(1x,a15,a162)")
    Head_rec_2=string(yr,mon,day,hour,min,sec,apog,perig,incl,'', $
                          format="(1X,5i6,f8.4,2e14.6,f10.5,a101)")
    Head_rec_3=string('','',-1,-1,'',format="(2(1X,a32),2i6,a100)")
    Head_rec_4=string('','',-1,-1,'',format="(2(1X,a32),2i6,a100)")
    Head_rec_5=string(0,0,0,0,0,0,0,'','',-1,1,'',$
                      format="(1X,2f10.4,f9.6,4e14.6,2(2x,a8),2i3,a66)")
    Head_rec_6=string('(1X,3F14.8,1P,E14.6,0P,F14.8,2(0P,F11.8,1P,E14.6),1P,4E14.6)','',format="(1X,a60,a117)")
    Head_rec_7=string('   MJD (1950)      Longitude      Latitude     Altitude     Pitch Angle  B (prot.)   L (protons)  B (elec.)   L (elec.)    Proton Flux1  Proton Flux2  Elec. Flux 1  Elec. Flux 2','',format="(a177,a1)")
     
;write with fixed record length of 178 bytes
    openw,unit,outfile,/get_lun
      writeu,unit,byte(Head_rec_1)
      writeu,unit,byte(Head_rec_2)
      writeu,unit,byte(Head_rec_3)
      writeu,unit,byte(Head_rec_4)
      writeu,unit,byte(Head_rec_5)
      writeu,unit,byte(Head_rec_6)
      writeu,unit,byte(Head_rec_7)
       
;DATA RECORDS 
      for ii=0,n_elements(input_data)-1 do begin
        mjd=t.mjd+input_data(ii).time/86400.0
        lon=input_data(ii).xlong
        lat=input_data(ii).xlat
        alt=(input_data(ii).xalt-1)*6371    ;in km above earth's surface
        PA=90.0
        dummy=fltarr(8) & dummy(*)=-1.0
        Data_rec=string(mjd,lon,lat,alt,PA,dummy,'', $
              format="(1X,F14.8,2F14.8,E14.6,F14.8,2(F11.8,E14.6),4E14.6,a1)")
        writeu,unit,byte(Data_rec)
      endfor   
      
;END OF FILE LINE
      dy=fltarr(13) & dy(*)=-1.0
      End_rec=string(dy,'', $
             format="(1X,F14.8,2F14.8,E14.6,F14.8,2(F11.8,E14.6),4E14.6,a1)")
      writeu,unit,byte(End_rec)
      close,unit & free_lun,unit 
      close,/all
    print,'% crres2cif: Written file ',file_id+'.int'   
    next:
  endfor
  
end

;*****************************************************************************
; idl batch file to run all crres .int files through UNIRAD's BLXTRA

pro do_crres_blxtra
  
;setup search path for data
  data_dir='/data/crres/EPHEMERIS/'

  IF strmid(data_dir,strlen(data_dir)-1,1) NE '/' THEN data_dir=data_dir+'/'
   cif_data_dir=data_dir+'CIF/'
   bla_data_dir=data_dir+'CIF/bla/'
   
   files=findfile(cif_data_dir+'*.int')  
   
   crres_namelist='~/UNIRAD_3-0/CR_EPH_XXXX.nml'
   
   for i=0,n_elements(files)-1 do begin
     pos=strpos(files(i),'crres_EPH_')
     file_id=strmid(files(i),pos,14)
     check=findfile(bla_data_dir+file_id+'.bla',count=chn)
     if chn ne 1 then begin
       print,i,n_elements(files),' Doing ',file_id
       spawn,'cp '+crres_namelist+' '+file_id+'.nml'
       spawn,'cp '+files(i)+' .'
       spawn,'blxtra '+file_id+' > '+file_id+'.jrl'
       spawn,'cp '+file_id+'.bla '+ bla_data_dir
       spawn,'rm '+file_id+'*' 
     endif  
   endfor  
   
 end  
 
  
  
