;******************************************************************************
;*  NAME:        r_crres_lepa_spectra
;*
;*  DESCRIPTION: Routine to read crres_lepa_spectra files. Adheres to
;*               papco conventions: Error common block
;*                                  Uses MJDT time
;*                                  papco read philosophy
;*
;*  INPUT:       none (uses common block time from papco)
;*
;*  OUTPUT:      none (places data into common blocks)
;*
;*  KEYWORDS:    VERBOSE  -  enables print comments, save/restore comments
;*
;*  DATE:        June 1996
;*
;*  AUTOR:       R. Friedel
;*
;*  CHANGES:     February 1997. Used MJDT time now, and is a fully
;*               running example module on it's own
;*               October 1997. Rewritten to be more general and fully
;*               adhering to papco philosophy. Added remore Get feature, and
;*               the example data file is no longer part of the 
;*               module - it needs to be gotten remotely first!
;******************************************************************************
pro r_crres_lepa_spectra, orbit, VERBOSE=VERBOSE

  common lepa_time, xut
  common counts, e_cps, p_cps, e_cps_perp, p_cps_perp
  common bkg_factors, rec_arr, re9_arr, ric_arr, ri9_arr
  common special_arrays, lc_arr, an_arr, mo_arr, tc_arr
  common calibration, fe0,feA,fi,be0,beA,bi,gel,geh,gil,gih,bi9,bea9,be09
  common get_error, get_err_no, get_err_msg

  get_err_no=0
  get_err_msg='LEPA-file read successfully'
   
;----------------------------------------------------------------------------
; read the survey.cal file first to get all calibration data.
; Latest version of "survey.cal" is #4
;----------------------------------------------------------------------------
  
  junk = ''
  buf  = 0.0
  fe0  = fltarr(15)		;electron efficiencies mode 0
  feA  = fltarr(8)		;electron efficiencies mode 10
  fi   = fltarr(8)		;ion efficiencies
  be0  = fltarr(15)		;electron background mode 0
  beA  = fltarr(8)		;electron background mode 10
  bi   = fltarr(8)		;ion background
  gel  = fltarr(20)		;electron low voltage geometric factors
  geh  = fltarr(20)		;electron high voltage geometric factors
  gil  = fltarr(29)		;ion low voltage geometric factors
  gih  = fltarr(29)		;ion high voltage geometric factors
   
  path=papco_getenv('PAPCO_MODULES')
  path=path+'/crres_lepa/plot_read/'

  openr,1,path+'survey.cal', ERROR=err
  readf,1,junk 
  readf,1,junk                  ;electron efficiencies mode 0
  print,junk
  for i=0,14 do begin 
    readf,1,buf
    fe0(i)=1./buf
  endfor
  readf,1,junk                  ;electron efficiencies mode 10
  print,junk
  for i=0,7 do begin 
    readf,1,buf 
    feA(i)=1./buf 
  endfor
  readf,1,junk                  ;ion efficiencies
  print,junk
  for i=0,7 do begin 
    readf,1,buf 
    fi(i)=1./buf 
  endfor
  readf,1,junk                  ;electron background mode 0
  print,junk
  for i=0,14 do begin  
    readf,1,buf 
    be0(i)=buf 
  endfor
  readf,1,junk                  ;electron background mode 10
  print,junk
  for i=0,7 do begin 
    readf,1,buf  
    beA(i)=buf 
  endfor
  readf,1,junk                  ;ion background
  print,junk
  for i=0,7 do begin 
    readf,1,buf 
    bi(i)=buf 
  endfor
  readf,1,junk                  ;electron low voltage geometric factors
  print,junk
  for i=0,19 do begin 
    readf,1,buf,format='(E10.4)' 
    gel(i)=1./buf 
  endfor
  readf,1,junk                  ;electron high voltage geometric factors
  print,junk
  for i=0,19 do begin 
    readf,1,buf,format='(E10.4)' 
    geh(i)=1./buf 
  endfor
  readf,1,junk                  ;ion low voltage geometric factors
  print,junk
  for i=0,28 do begin 
    readf,1,buf,format='(E10.4)' 
    gil(i)=1./buf 
  endfor
  readf,1,junk                  ;ion high voltage geometric factors
  print,junk
  for i=0,28 do begin 
    readf,1,buf,format='(E10.4)' 
    gih(i)=1./buf 
  endfor
  readf,1,junk 
  print,'survey.cal: '+junk
  close,1
  
;----------------------------------------------------------------------------
; Calculate bi9, be09, bea9
;----------------------------------------------------------------------------

   bi9 = (bi(3) + bi(4)) * 0.5
   bea9 = (beA(3) + beA(4)) *0.5
   be09 = (be0(6) + be0(7) + be0(8) + be0(9)) * 0.25
     
;----------------------------------------------------------------------------
; Open the LEPA file
;----------------------------------------------------------------------------

   buffer=bytarr(3000,595)
   inst=replicate(0B,595)
   
   path=getenv('LEPA_PATH')
   if strlen(path) eq 0 then begin
      get_err_no=1
      get_err_msg='LEPA environmental variable LEPA_PATH for data path not set'
      print,get_err_msg
      return
   endif

   fln=path+'/'+string(orbit,format="(i8.8)")+'.lsdbin*'
   
   FileExist=findfile(fln) ; Look for file at LEPA_PATH
   if FileExist(0) ne '' then goto, read_file
   
   fln=getenv('FTP_DOWNLOAD_DIR')+'/'+string(orbit,format="(i8.8)")+'.lsdbin*'

   FileExist=findfile(fln) ; Look for file at FTP_DOWNLOAD_DIR
   if FileExist(0) ne '' then goto, read_file
   
   c_url=papco_getenv('LEPA_FTP_ARCHIVE') ; remote get file
   c_file=string(orbit,format="(i8.8)")+'.lsdbin*'
   c_download_dir=getenv('FTP_DOWNLOAD_DIR')+'/'
   papco_get_remote_data, c_url, c_file, c_download_dir
   if get_err_msg eq 'Remote GET cancelled' then begin
     print, fln+' : Remote GET cancelled'
     get_err_no=2
     get_err_msg=fln+' : Binary not available.'       
     return
   endif
   FileExist=findfile(fln)
   if FileExist(0) ne '' then goto, read_file
   print, fln+' : Binary not available.'
   get_err_no=2
   get_err_msg=fln+' : Binary not available.'       
   return
   
;----------------------------------------------------------------------------
; read file
;----------------------------------------------------------------------------
   
   read_file:
   fln=FileExist(0)    
   str_length=strlen(fln)
   str_end=strmid(fln,str_length(0)-2,2)    
   if str_end eq 'gz' then begin ; check if file needs uncompressing
     print, 'uncompressing: '+fln
     spawn, 'gzip -df '+fln
     fln=strmid(fln,0,str_length(0)-3)
     FileExist=findfile(fln)
     if FileExist(0) eq '' then begin ; check if file has been uncompressed
       print, fln+' : Binary not available.'
       get_err_no=2
       get_err_msg=fln+' : Binary not available.'       
       return
     endif
   endif
     
   openr,f_Unit,fln, ERROR=err, /GET_LUN
   
   IF err EQ 0 THEN BEGIN
     iorbit=0 & iday=0 & iyear=0 & ndat=0
     readu,f_Unit,iorbit,iday,iyear,ndat
     
     xut=fltarr(ndat)
     
     e_cps=fltarr(ndat,20,15)
     p_cps=fltarr(ndat,29,8)
     e_cps_perp=fltarr(ndat,20)
     p_cps_perp=fltarr(ndat,29)
     
     lc_arr=byte(intarr(ndat))
     mo_arr=byte(intarr(ndat))
     an_arr=byte(intarr(ndat))
     tc_arr=fltarr(ndat)
     
     rec_arr=fltarr(ndat)
     re9_arr=fltarr(ndat)
     ric_arr=fltarr(ndat)
     ri9_arr=fltarr(ndat)
     
     readu,f_Unit,xut, $
                  e_cps,p_cps,e_cps_perp,p_cps_perp, $
                  lc_arr, mo_arr, an_arr, tc_arr, $
                  rec_arr,re9_arr,ric_arr,ri9_arr
     
     close,f_Unit
     free_lun, f_Unit

   ENDIF ELSE BEGIN
     print, fln+' : Binary not available.'
     get_err_no=2
     get_err_msg=fln+' : Binary not available.'
     RETURN
   ENDELSE
   
   for ii=0, ndat-1 do begin
     mjdt_dummy = convert_tzero_to_t90(xut(ii),iday,iyear,/mjdt)
     xut(ii)=mjdt_dummy.T
   endfor
   
 end
