pro r_crres_mag, orbit, T90=T90

  common crres_mag_data, input_header, input_data
  common plot1, iorb,iday,iyear
   
  common get_error, get_err_no, get_err_msg
  common TimeFormat, UseT90

  IF NOT KEYWORD_SET(T90) THEN T90=0
  UseT90=T90

  get_err_no=0
  get_err_msg='CRRES-MAG-Data successfully read'

   time=fltarr(1000,/nozero)
   bdat=fltarr(1000,3,/nozero)
   bmod=fltarr(1000,3,/nozero)

   iorb=long(0)
   iyear=long(0)
   iday=long(0)
   xt1=float(0)
   xt2=float(0)
   imodel=long(0)
   xkp=float(0)

   t=0.0
   bd=fltarr(3)
   bm=fltarr(3)
   
;---------------------------------------------------------------------------
; find file   
;---------------------------------------------------------------------------
   
   cpath=papco_getenv('CRRES_MAG_DATA')
   if strlen(cpath) eq 0 then begin
      get_err_no=1
      get_err_msg='CRRES_MAG_DATA environmental variable for data path not set'
      print,'% r_crres_mag: ',get_err_msg
      return
   endif
   fln=cpath+'/mag'+string(format='(i4.4)',orbit)+'.dat'
   
   FileExist=findfile(fln)
   if FileExist(0) ne '' then goto, read_file
   
   fln=getenv('CRRES_MAG_FTP_DOWNLOAD_DIR')+ $
     '/mag'+string(format='(i4.4)',orbit)+'.dat'
   FileExist=findfile(fln)
   if FileExist(0) ne '' then goto, read_file

   c_url=papco_getenv('CRRES_MAG_FTP_ARCHIVE') ; remote get file
   c_file='mag'+string(format='(i4.4)',orbit)+'.dat'
   c_download_dir=getenv('CRRES_MAG_FTP_DOWNLOAD_DIR')+'/'
   papco_get_remote_data, c_url, c_file, c_download_dir

   if get_err_msg eq 'Remote GET cancelled' then begin
     print, fln+' : Remote GET cancelled'
     get_err_no=2
     get_err_msg=fln+' : Binary not available.'       
     return
   endif
   FileExist=findfile(fln)
   if FileExist(0) ne '' then goto, read_file
   print, fln+' : Binary not available.'
   get_err_no=2
   get_err_msg=fln+' : Binary not available.'       
   return
   
;---------------------------------------------------------------------------
; open/read file   
;---------------------------------------------------------------------------

   read_file:
   
   ndat=0

   openr,f_Unit,fln,/f77_unformatted, /GET_LUN, ERROR=err
   IF err NE 0 THEN BEGIN
      get_err_no=2
      get_err_msg=!ERR_STRING
      print,'% r_crres_mag: ',get_err_msg
      return   
   ENDIF

   ON_IOERROR, readError
   readu, f_Unit,IORB,IDAY,IYEAR,XT1,XT2,IMODEL,XKP
   IF UseT90 THEN BEGIN
      xt1=convert_tZERO_to_t90(xt1, iday, iyear)
      xt2=convert_tZERO_to_t90(xt2, iday, iyear)
   ENDIF

   while(not eof(f_Unit)) do begin
      
      readu,f_Unit,t,bd,bm
      IF UseT90 THEN $
        time(ndat)=CONVERT_TZERO_TO_T90(t, iday, iyear) $
      ELSE $
        time(ndat)=t 
        bdat(ndat,*)=bd
        bmod(ndat,*)=bm
        ndat=ndat+1
  
   endwhile

   nd=ndat-1
   if nd gt 0 then begin
      time=time(0:nd)
      bdat=bdat(0:nd, *)
      bmod=bmod(0:nd, *)
   endif else begin
      get_err_no=3
      get_err_msg='Data file empty apart from header'
      print,'% r_crres_mag: ',get_err_msg
   endelse   

   close,f_Unit
   free_lun, f_Unit
   print,'% r_crres_mag: ',get_err_msg
   
; convert data read to papco standard input_data and input_header structures
   input_header={crres_mag_header,orbit:iorb,ndat:ndat,doy:iday,year:iyear}
   dummy={crres_mag_data, time:0.0d, bdat:fltarr(3), bmod:fltarr(3)}  
   input_data=replicate(dummy, ndat)
   input_data.time=time
   input_data.bdat=transpose(bdat)
   input_data.bmod=transpose(bmod)
   
   ;for i=0,nd do begin
   ;  input_data(i).time=time(i)
   
   return

; this label is called, when an io-error occurs
readError:
   close, f_Unit
   free_lun, f_Unit
   GET_ERR_NO=3
   GET_ERR_MSG=!ERR_STRING
   print,'% r_crres_mag: ',get_err_msg
   return
end


pro readmag2,orbit, T90=T90

   common magdat, time,bdat,bmod,nd
   common plot1, iorb,iday,iyear

   bdat=fltarr(1000,3,/nozero)
   bmod=fltarr(1000,3,/nozero)
   time=fltarr(1000,/nozero)

   iorb=long(orbit)
   iyear=long(0)
   iday=long(0)
   xt1=float(0)
   xt2=float(0)
   imodel=long(0)
   xkp=float(0)

   ndat=long(0)

   lib_name = '/export/home/friedel/idlprog/fortran/readcrres.so'
   entry_name = 'readmag_'

; Call the function in the sharable object file:
   result= 0.0
   
   result = call_external(lib_name,  $ ;The sharable object file
                          entry_name, $ ;The entry point
                          iorb,iday,iyear, $
                          float(xt1),float(xt2), $
                          imodel,float(xkp), $
                          float(time),float(bdat),float(bmod), $
                          ndat, $
                          /f_value) ;The function returns a float.
   nd=ndat

   time=time(0:nd-1)
   bdat=bdat(0:nd-1,*)
   bmod=bmod(0:nd-1,*)

end

pro readmag3,orbit

   common magdat, time,bdat,bmod,nd
   common plot1, iorb,iday,iyear

   time=fltarr(1000,/nozero)
   bdat=fltarr(1000,3,/nozero)
   bmod=fltarr(1000,3,/nozero)

   iorb=long(orbit)
   iyear=long(0)
   iday=long(0)
   xt1=float(0)
   xt2=float(0)
   imodel=long(0)
   xkp=float(0)

   ndat=long(0)

   lib_name = '/export/home/friedel/idlprog/fortran/readcrres.so'
   entry_name = 'readmag_'

; Call the function in the sharable object file:
   result= 0.0
   
   result = call_external(lib_name,  $ ;The sharable object file
                          entry_name, $ ;The entry point
                          iorb,iday,iyear, $
                          float(xt1),float(xt2), $
                          imodel,float(xkp), $
                          float(time),float(bdat),float(bmod), $
                          ndat, $
                          /f_value) ;The function returns a float.
   nd=ndat

   if (nd gt 0) then begin

      time=time(0:nd-1)
      bdat=bdat(0:nd-1,*)
      bmod=bmod(0:nd-1,*)

      cpath=papco_getenv('CRRES_MAG')
      fln=cpath+'/mag'+string(format='(i4.4)',orbit)+'.txt'

      openw,1,fln

      printf,1, format='(1x,i4.4,1x,i3.3,1x,i2.2)', IORB,IDAY,IYEAR

      for j=0,nd-1 do begin
         printf,1, format='(f8.1,(6(f9.2)) )', time(j),bdat(j,*),bmod(j,*)
      endfor

      close,1

   endif

end
