pro r_crres_mag_hr,orb
;program to read the high resolution magnetic field data produced with
;prvdh.f 

common magdat, time,bdat,bmod,nd
   common get_error, get_err_no, get_err_msg

   get_err_no=0
   get_err_msg='CRRES-MAG-Data successfully read'

iorb=0 & iday=0 & iyear=0 & ndat=0L & ts=0.0 & te=0.0 & bf=fltarr(3) & xut=0.0
cpath=papco_getenv('CRRES_FILES')
file='/vdh'+string(format='(i4.4)',orb)+'.dat'
fln=cpath+file

openr,1,fln

readf,1,iorb,iday,iyear,ndat,ts,te
print,iorb,iday,iyear,ndat,ts,te
bdat=fltarr(ndat,3)
time=fltarr(ndat)
i=-1L
while not eof(1) do begin
 i=i+1
 readf,1,xut,bf
; print,i,xut,bf
 time(i)=xut
 bdat(i,*)=bf
endwhile

print,i

close,1

file='/vdh'+string(format='(i4.4)',orb)+'.bin'
fln=cpath+file

openw,1,fln
  writeu,1,iorb,iday,iyear,ndat,ts,te
  writeu,1,time,bdat
close,1

end

;******************************************************************************
pro r_crres_mag_hr_bin,orb, T90=T90

common magdat, time,bdat,bmod,nd
common time, xut1,xut2

   common get_error, get_err_no, get_err_msg
   common TimeFormat, UseT90

   IF NOT KEYWORD_SET(T90) THEN T90=0
   UseT90=T90

iorb=0 & iday=0 & iyear=0 & ndat=0L & ts=0.0 & te=0.0

cpath=papco_getenv('CRRES_FILES')
file='/vdh'+string(format='(i4.4)',orb)+'.bin'
fln=cpath+file

openr,1,fln
  readu,1,iorb,iday,iyear,ndat,ts,te
  print,iorb,iday,iyear,ndat,ts,te
  bdat=fltarr(ndat,3)
  time=fltarr(ndat)
  readu,1,time,bdat
close,1

index=where((time ge xut1) and (time le xut2),count)

if count gt 0 then begin
 time=time(index)
 bdat=bdat(index,*)
endif

end

;******************************************************************************
pro r_crres_mag_highres, orb, VERBOSE=VERBOSE
  
  common crres_mag_data, input_header, input_data  
  common get_error, get_err_no, get_err_msg
  
  get_err_no=0  &  get_err_msg='CRRES MAG Highres read succesfully'  
  
  IORBIT=long(0)
  IDAY=long(0)
  IYEAR=long(0)
  XT1=float(0)  &  XT2=float(0)
  IMODEL=long(0)
  XKP=float(0)
  
; check env. variable pointing to data directory
  if not (papco_check_data_env('CRRES_MAG_DATA', path=PATH)) then return
  
; check VERBOSE keyword and set
  if keyword_set(VERBOSE) then verbose=VERBOSE else verbose=0     
   
; clear data arrays for reuse
  input_header=0  &  input_data=0
  
  file='highres'+string(format='(i4.4)',orb)+'.dat'
  fln=path+'highres/'+file
  message,'Reading Fortran binary file '+ file + ' (slow)', /cont
  
  on_ioerror, readError
  openr,u,fln,/f77_unformatted, /GET_LUN
  
  readu, u, IORBIT,IDAY,IYEAR,XT1,XT2,IMODEL,XKP
  
  input_header={crres_mag_header,orbit:iorbit,ndat:0l,doy:iday,year:iyear}
  dummy={crres_mag_data, time:0.0d, bdat:fltarr(3), bmod:fltarr(3)}  
  input_data=replicate(dummy, 350000)
                         
  ndat=0l
  while not eof(u) do begin
    readu,u,t,bd,bm
    input_data(ndat).time=t 
    input_data(ndat).bdat=bd
    input_data(ndat).bmod=bm
    ndat=ndat+1
  endwhile
  close, u  &  free_lun, u  
  
  input_header.ndat=ndat
  input_data=input_data(0:ndat-1)
  
  message,'Read file '+fln, /cont
  
  return

; this label is called, when an io-error occurs
readError:
   close, u  &  free_lun, u
   GET_ERR_NO=3
   GET_ERR_MSG=!ERR_STRING
   message, get_err_msg, /cont
   
end
