pro r_CRRES_MAG_overview,OLDTIME=OLDTIME

; KEYWORD OLDTIME       inhibts time conversion

   common crres_mag_overview, info, lsum, valdat
   common crres_mag_overview_extra, time, sp, lbin, lrange
   
   common mjdt, mjdt_start, mjdt_end ;common time limit in mjdt
   common get_error, get_err_no, get_err_msg

   pitches=[90,90,90,90]
   lsum=0
   valdat=0

   sp=0
   nn=0
   lbin=0.0
   lrange=0.0
   type=intarr(4)
   paequ=0

   get_err_no=0
   get_err_msg='LAV-file read successfully'

   cpath=papco_getenv('CRRES_MAG_OVERVIEW')
   if strmid(cpath,strlen(cpath)-1,1) ne '/' then cpath=cpath+'/' 

   if strlen(cpath) eq 0 then begin
      get_err_no=1
      get_err_msg='LAV environmental variable (LAV_DATA) not set'
      print,get_err_msg
      return
   endif

   fl='crres_mag_lsrt_OlPf_090'
   fln=cpath+fl+'.idl'
   print,'% r_CRRES_MAG_overview: Reading ',fl
   openr, f_unit ,fln, ERROR=err, /GET_LUN
   IF err EQ 0 THEN BEGIN
      readu,f_unit,type,sp,nn,lbin,lrange,paequ
      print,'% r_CRRES_MAG_overview: Header',sp,lbin,lrange,nn

      nobins=(lrange-1)/float(lbin)+1
      lsum=  fltarr(sp,nn,nobins)
      valdat=fltarr(sp,nn,nobins)
      info=  fltarr(sp,5)

      readu,f_unit,info,lsum,valdat

      close,f_unit
      free_Lun, f_unit

   ENDIF ELSE BEGIN
      print, fln+'  : binary not available.'
      get_err_no=2
      get_err_msg=!ERR_STRING
      print, !ERR_STRING
      RETURN
   ENDELSE

   if keyword_set(OLDTIME) then goto, out
  
; convert the times to mjdt standard ready to plot. Since plot is float
; accuracy convert times here to mjd decimal day, ie mjd +daysec/86400
   res=size(info)
   sp=fix(res(1))
   time=dblarr(sp,2)    ;to keep the times for the two rad belt traverses
   for i=0,sp-1 do begin
     if info(i,3,0) ne 0 then begin
       year=info(i,0)
       doy =info(i,1)
       sec =info(i,2)
       t=convert_date_to_t90(doy=doy,year=year,seconds=sec,/mjdt)
       time(i,0)=t.mjd + double(t.t / 86400.0)
       ;print,i,time(i,*),format="(i4,4(f10.2))"
       sec =info(i,4)
       t=convert_date_to_t90(doy=doy,year=year,seconds=sec,/mjdt)
       time(i,1)=t.mjd + double(t.t / 86400.0)
     endif
     
   endfor
  
; restrict array to the range handed in be mjdt_start and mjdt_end

  st = mjdt_start.mjd + mjdt_start.t / 86400.0
  ed =  mjdt_end.mjd +  mjdt_end.t / 86400.0
  
  index=where((time(*,0) ge st) and (time(*,1) le ed),count)
  if count ge 2 then begin
     time=temporary(time(index,*))
     info=temporary(info(index,*,*))
     lsum=temporary(lsum(index,*,*,*))
     valdat=temporary(valdat(index,*,*,*))
  endif
  sp=count
  
  if count lt 2 then begin
      get_err_no=2
      get_err_msg='No Data found in timerange'
      print,get_err_msg
      return    
  endif  

out:
  
;check for slices which have non zero counts, but are all the same in
;Btot, type=10 - for which the data is not valid, set to zero
   test=fltarr(nobins) & nums=fltarr(nobins)
   for i=0,sp-1 do begin  
      ymat=  lsum(i,10-1,*)
      yval=valdat(i,10-1,*)
      index=where(yval(*) ne 0,count)
      if count ne 0 then test(index)=ymat(index)/yval(index)
      for j=0,nobins-1 do begin
        index=where(abs(test-test(j)) lt 0.01, count)
        nums(j)=count
      endfor  
      nosame=max(nums,maxdex)
      if (nosame gt 1) and (test(maxdex) ne 0) then begin
        ;print,i,nosame,test(maxdex)
        index=where(test eq test(maxdex))
        lsum(i,9,index) = 0
     endif  
   endfor    
   
end
