; routine to set up common info for crres mea.
PRO crres_mea_commons

COMMON crres_mea, ech, $
                  average_names, average_range, average_frmts, $
                  crres_mea_control

; make array of energy channel labels
ech=fltarr(18,2)
ech( 0,0)=110  &ech( 0,1)=181
ech( 1,0)=181  &ech( 1,1)=244
ech( 2,0)=244  &ech( 2,1)=306
ech( 3,0)=306  &ech( 3,1)=379
ech( 4,0)=379  &ech( 4,1)=464
ech( 5,0)=464  &ech( 5,1)=556
ech( 6,0)=556  &ech( 6,1)=648
ech( 7,0)=648  &ech( 7,1)=737
ech( 8,0)=737  &ech( 8,1)=829
ech( 9,0)=829  &ech( 9,1)=926
ech(10,0)=926  &ech(10,1)=1033
ech(11,0)=1033 &ech(11,1)=1135
ech(12,0)=1135 &ech(12,1)=1233
ech(13,0)=1233 &ech(13,1)=1330
ech(14,0)=1330 &ech(14,1)=1421
ech(15,0)=1421 &ech(15,1)=1527
ech(16,0)=0000 &ech(16,1)=0000
ech(17,0)=1527 &ech(17,1)=1633

;enter variables for averaging/selecting the data
average_names = ['Energy','Pitch']
average_range = [[0, 18, 1], [0, 180, 1]]
average_frmts = ['(i2)', '(i3)']

;set up a structure for all the variables needed by the crres mea
;module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains are
;descriptive and verbose tags for easier use.

crres_mea_control = { $
  pl_type:0,    pl_type_info:'0: Ek @ PA, 1: PA @ Ek, 2: Mu Range', $
  spec:1,       spec_info:'0: line plot, 1: color plot', $
  mu:'',        mu_info:'String of comma seperated mu, (MeV/G)', $
  reload:0,     reload_info:'0: reload data, 1: adopt from memory',  $
  pa_bin:10,    pa_bin_info:'Pitch angle bin width, centered on 90 deg.', $
  slice_av:0,   slice_av_info:'number of spectra to average in slice', $
  time_av:30,   time_av_info:'time bin to sample pitch angles'}

;get the papco_panel tags for the average variables.
FOR i = 0, n_elements(average_names)-1 DO $
  crres_mea_control = CREATE_STRUCT(crres_mea_control, $
               papco_panel_AddVar_Ave_Widgets(aBase, average_names(i), $
                                              st, en, v1, v2, vr, $
                                              average_frmts(i), /STRUCT_ONLY))


;set some defaults for the average variables
crres_mea_control.PITCH_AVERAGE_FROM_VAL = 85
crres_mea_control.PITCH_AVERAGE_TO_VAL = 95

;finally name the control structure. This is required for load/save operations!
crres_mea_control = CREATE_STRUCT(name = 'crres_mea_controll', $
                                          crres_mea_control)


  
END   
