;******************************************************************************
; Program to produce crres meb plasma paramter (moments) data. Reads
; the crres meb energy pitchangle array and then calls the plaspar
; fortran routine to calculate the moments.
; Include mag field data for calculating pressures.
;******************************************************************************
pro g_crres_meb_plaspar, orb, type, ERANGE=ERANGE
  
  common crres_meb_data, input_header, input_data
  common get_error, get_err_no, get_err_msg   
  common crres_meb_plaspar, plaspararr
  common magdat, time,bdat,bmod,nd
  
  ;list energy ranges and set swittches. 
  ;energy ranges are given in one array, giving all the bounds of the
  ;channels.
  if type(0) eq 0 then begin
    ekarr=[21., 31.5, 40., 49.5, 59., 69., 81., 94.5, 112., 129.5, 151., $
           177.5, 208., 242.5, 285.]
    iep=1l  &  ch=14
  endif else begin
    ekarr=[37.,54.,69.,85.,113.,147.,193.,254.,335.,447.,602., $
           805.,3200. ]
    iep=2l  &  ch=12
  endelse
  
  ;limit arrays to be handed over to energy channel range required
  if keyword_set(ERANGE) then erange=erange else erange=[0,ch-1]
  ekarr=ekarr(erange(0):erange(1)+1)
    
  print,'% g_crres_meb_plaspar: reading crres_meb data'
  r_crres_meb, orb, type  &   if get_err_no ne 0 then return
  r_crres_mag, orb        &   if get_err_no ne 0 then return
  
  ;fold mag data into time resolution of meb data
  newtime=interpol(time,time,input_data.time)
  newbdat=fltarr(n_elements(newtime),3)
  newbmod=fltarr(n_elements(newtime),3)
  for i=0,2 do begin
      temp=bdat(*,i)
      temp2=bmod(*,i)
      temp=interpol(temp,time,input_data.time)
      temp2=interpol(temp2,time,input_data.time)
      newbdat(*,i)=temp
      newbmod(*,i)=temp2
  endfor
  bdat=newbdat  
  bmod=newbmod
  time=newtime
  bmag=sqrt(bdat(*,0)^2+bdat(*,1)^2+bdat(*,2)^2)
  
  ;make required data arrays
  ndat=n_elements(input_data)
  dummy={time:0.0, EDP:0.0, NDP:0.0, PPP:0.0, PPA :0.0, iret:0l, MAG:0.0}
  plaspararr=replicate(dummy,ndat)
  plaspararr.time=input_data.time
  plaspararr.MAG=bmag
  
  print,'% g_crres_meb_plaspar: calculating crres_meb plasma parameters'
  for i=0,ndat-1 do begin
    
    inarr=input_data(i).data(*,erange(0):erange(1))
    
    ; call fortran plaspar routine.      
    ;!!! fortran is column major, idl row major !!!
    ;Transpose 2 x 2 matrices befor handing to fortran
    f77_plaspar, iep, transpose(inarr), ekarr, EDP,NDP,PPP,PPA,iret
    
    plaspararr(i).EDP=EDP
    plaspararr(i).NDP=NDP
    plaspararr(i).PPP=PPP
    plaspararr(i).PPA=PPA
    plaspararr(i).iret=iret

    ;print,i,edp,ndp,ppp,ppa,iret
      
  endfor
  
  print,'% g_crres_meb_plaspar: done'
  
  
end
