pro p_crres_meb_plaspar,panel,type, $
             OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
             _EXTRA=extra_par
   
;    Arrays for plasma parameters
;    EDP - energy density,                NDP - number density
;    PPP - perpendicular plasma pressure, PPA - parallel plasma pressure
;    PTOT - total plasma pressure
;    BPP - beta perpendicular,            BPA - beta parallel
;    BTOT - beta total,                   ANISO - anisotropy

; type chooses plot type (4 element vector)
;        type(0)    -    0 electrons, 1 ions
;        type(1)    -    0 energy density
;        type(1)    -    1 number density
;        type(1)    -    2 perpendicular plasma pressure
;        type(1)    -    3 parallel plasma pressure
;        type(1)    -    4 total plasma pressure
;        type(1)    -    5 beta perpendicular
;        type(1)    -    6 beta parallel
;        type(1)    -    7 beta total
;        type(1)    -    8 anisotropy
;        type(1)    -    9 % data missing in pw/e array

   common parameters, plaspararr
;      plaspararr(*,0)=EDP
;      plaspararr(*,1)=NDP
;      plaspararr(*,2)=PPP
;      plaspararr(*,3)=PPA
;      plaspararr(*,4)=float(iret)
;      plaspararr(*,5)=mag field total

  common crres_meb_plaspar, plaspararr
  
  common time, xut1,xut2
  common yscale, yscl
  common coordinateSystems, plotted_x, plotted_y

  panelset,panel   ;setup viewport

   if (panel(1) eq 1) then begin
      ctit='CRRES/MEB     ORBIT  '+ string (iorbit,format= "(i4.4)")+$
      '     ' + string (moday,cmonth,iyear, "(i2.2,a4,i3)") +$
      '     Plasma Parameters     !C Time Averaged 60 secs'
   endif else begin
      ctit=' '
   endelse

   if type(0) eq 0 then begin
      spec='MEB e'   
      totno=266
   endif else begin
      spec='MEB i'   
      totno=228
   endelse 

   case type(1) of
      0:begin
         yray=plaspararr(*,1)
         yst=0.001 & yen=0.2 & plotcall='plot_io' & refline=-1
         ctit2='!Cnumber density' & ytit='cm!E-3'
      end
      1:begin
         yray=plaspararr(*,0)
         autorange,panel(0),time,yray,yen,yst,1 & plotcall='plot_io'
         ctit2='!Cenergy density' & ytit='keVcm!E-3' & refline=-1
      end
      2:begin
         yray=plaspararr(*,2)
         yst=0.05 & yen=10 & plotcall='plot_io'
         ctit2='!Cperp. plasma pres.' & ytit='Nm!E-2' & refline=-1
      end
      3:begin
         yray=plaspararr(*,3)
         yst=0.05 & yen=10 & plotcall='plot_io'
         ctit2='!Cparal. plasma pres.' & ytit='Nm!E-2' & refline=-1
      end
      4:begin
         yray=2./3. * plaspararr(*,0)
         yst=0.05 & yen=10 & plotcall='plot_io'
         ctit2='!Ctotal plasma pres.' & ytit='Nm!E-2' & refline=-1
      end
      5:begin
         endenb=2.4834E-3*plaspararr(*,5)^2
         yray=plaspararr(*,2) / endenb
         ylim2,time,yray,yst,yen & plotcall='plot' & refline=-1
         ctit2='!Cbeta perp.' & ytit='!7b!I!9x!3'
      end
      6:begin
         endenb=2.4834E-3*plaspararr(*,5)^2
         yray=plaspararr(*,3) / endenb
         ylim2,time,yray,yst,yen & plotcall='plot' & refline=-1
         ctit2='!Cbeta paral.' & ytit='!7b!I!9#!3'
      end
      7:begin
         endenb=2.4834E-3*plaspararr(*,5)^2
         yray=2./3. * plaspararr(*,0) / endenb
         ylim2,time,yray,yst,yen & plotcall='plot' & refline=-1
         ctit2='!Cbeta total' & ytit='!7b!3'
      end
      8:begin
         ppar=plaspararr(*,3)
         pperp=plaspararr(*,2)
         index= where(pperp ne 0)
         yray=ppar & yray(*)=1
         yray(index)=ppar(index)/pperp(index) & refline=1
         ylim2,time,yray,yst,yen & plotcall='plot'
         ctit2='!CPress. aniso.' & ytit='P!Ipar!N/P!Iperp'
      end
      9:begin
         yray=(plaspararr(*,4) / totno) * 100
         ylim2,time,yray,yst,yen & yst=0.0 & plotcall='plot' & refline=-1
         ctit2='!Cdata missing' & ytit='%'
      end
   endcase
  
   ;select time interval
   ;if xut1=xut2 then the whole orbit is returned   
   ixut1=0
   ixut2=ndat-1
   if xut1 eq xut2 then begin
     xut1=time(ixut1)
     xut2=time(ixut2)
   endif else begin
      for i=0,ndat-2 do begin
         if (time(i) le xut1) and (time(i+1) gt xut1) then ixut1=i
         if (time(i) lt xut2) and (time(i+1) ge xut2) then ixut2=i+1
      endfor
   endelse

   if (yscl(panel(0),0) eq 1) then begin
      yst=yscl(panel(0),1)
      yen=yscl(panel(0),2)
   endif else begin
      yscl(panel(0),1)=yst
      yscl(panel(0),2)=yen
   endelse

   !x.ticks=10
   ytickno=fix(35*(!p.position(3)-!p.position(1)))

   extra_plotPar={yrange:[yst, yen], xrange:[xut1, xut2], $
                  yticks:ytickno, noerase:1, $
                  ticklen:-0.015, $
                  xminor:10, $
                  ytitle:ytit}

   if panel(0) eq 0 then $
     extra_plotPar=create_struct({xtickformat:'timeticks', $
                                  title:ctit}, $
                                  extra_plotPar) $
   else $
     extra_plotPar=create_struct({xtickformat:'noticks'}, $
                                  extra_plotPar)
   
   if n_elements(extra_par) EQ 0 then $
     extra_par={color:1}

   extra_plotPar=create_struct(extra_plotPar, extra_par)

;--- plot the axis in color=1 -------------------------------------------------

   color1_plotpar=create_struct({color:1}, extra_plotPar)
   if not keyword_set(overplot) then begin
      call_procedure, plotcall, $ 
               time,yray, _extra=color1_plotPar, /NODATA, $
               xstyle=3, ystyle=1
      ctit2=spec+ctit2
   endif else begin
      for i=0,PLOTS_ATTHISPOSITION-1 do ctit2='!C'+ctit2
   endelse
   
; plot actual data

   call_procedure, plotcall, $ 
               time,yray, _extra=extra_plotPar, xstyle=3, ystyle=5

   plotted_x = !x
   plotted_y = !y
   
   if not keyword_set(OVERPLOT) and (refline gt 0) THEN $
     oplot,[xut1,xut2],[refline,refline],linestyle=2,color=1

;--- plot Ephemeris - information ---------------------------------------------
   if (panel(0) eq 0) and not keyword_set(OVERPLOT) then begin
      plot,time,yray,/noerase,/nodata,xstyle=3,$
         xrange=[xut1,xut2],ystyle=12,xtickformat='mltticks',$
        ticklen=-0.015,color=1
      plot,time,yray,xrange=[xut1,xut2],/noerase,$
         /nodata,xstyle=3,ystyle=12,xtickformat='ilatticks',$
        ticklen=-0.015,color=1
      plot,time,yray,xrange=[xut1,xut2],/noerase,$
         /nodata,xstyle=3,ystyle=12,xtickformat='lshelticks',$
        ticklen=-0.015,color=1
      plot,time,yray,xrange=[xut1,xut2],/noerase,$
         /nodata,xstyle=3,ystyle=12,xtickformat='radticks',$
        ticklen=-0.015,color=1
   endif

   ; plot info right of the panel
   right_side_label,panel,ctit2,_extra=extra_plotPar

end
