pro plaspar,iep,epwint,en,EDP,NDP,PPP,PPA,iret

;initialise retun variables. Integers are always passed as longs.

EDP=1.0 & NDP=1.0 & PPP=1.0 & PPA=1.0 & iret=1l

lib_name = '/net/hydra/export/home/friedel/idlprog/fortran/plaspar.so'
entry_name = 'endenp_'

; Call the function in the sharable object file:
result= 0.0
                                 
result = call_external(lib_name,  $	    ;The sharable object file
	 entry_name, $			    ;The entry point
         long(iep),float(epwint),float(en), $  ;input variables 
         float(EDP),float(NDP),float(PPP), $
         float(PPA),long(iret), $           ;return values
	 /f_value)			    ;The function returns a float.

end

;-----------------------------------------------------------------------------
pro get_plaspar,orb,type,T90=T90

   common ephem, xutepf,xmlt,xilat,xlshel,xrad,ndat
   common magdat, time,bdat,bmod,nd
   common orbinfo, iorb,iday,iyear
   common fluxes, ymat
   common time, xut1,xut2
   common parameters, plaspararr
   common get_error, get_err_no, get_err_msg

   if type(0) eq 0 then begin
     ekarr=[21.,31.5,40.,49.5,59.,69.,81.,94.5,112.,129.5,151., $
            177.5,208.,242.5,285.]
     iep=1l
     ch=14
   endif else begin
     ekarr=[37.,54.,69.,85.,113.,147.,193.,254.,335.,447.,602., $
            805.,3200,0.,0.]
     iep=2l
     ch=12
   endelse

   if keyword_set(T90) then begin
     get_crres_bin,orb,type,/T90
     if get_err_no ne 0 then return
     r_crres_mag, orb,/T90
   endif else begin 
     get_crres_bin,orb,type
     if get_err_no ne 0 then return
     r_crres_mag, orb
   endelse

   if get_err_no eq 0 then begin
     newtime=interpol(time,time,xutepf)
     newbdat=fltarr(n_elements(newtime),3)
     newbmod=fltarr(n_elements(newtime),3)
     for i=0,2 do begin
       temp=bdat(*,i)
       temp2=bmod(*,i)
       temp=interpol(temp,time,xutepf)
       temp2=interpol(temp2,time,xutepf)
       newbdat(*,i)=temp
       newbmod(*,i)=temp2
     endfor
     bdat=newbdat  
     bmod=newbmod
     time=newtime
     bmag=sqrt(bdat(*,0)^2+bdat(*,1)^2+bdat(*,2)^2)
   endif else begin
     bmag=bdat(*,0)
     bmag(*)=1
   endelse

   get_err_no=0

   ndat=n_elements(xutepf)

   plaspararr=fltarr(ndat,12)

   int=fltarr(19,14)

;!!! fortran is column major, idl row major. Transpose 2 x 2 matrices before
;    handing to fortran

   for i=0,ndat-1 do begin 
      int(0:18,0:ch-1)=ymat(i,0:18,0:ch-1)     
      plaspar,iep,transpose(int),ekarr,EDP,NDP,PPP,PPA,iret
      plaspararr(i,0)=EDP
      plaspararr(i,1)=NDP
      plaspararr(i,2)=PPP
      plaspararr(i,3)=PPA
      plaspararr(i,4)=float(iret)
      plaspararr(i,5)=2.4834E-3 * bmag(i)^2
      plaspararr(i,6:8)=bdat(i,0:2)
      plaspararr(i,9:11)=bmod(i,0:2)
   endfor
end
