;***************************************************************************
;* 
;* PROCEDURE:     
;*      FUNCTION goes_satlist
;* 
;* DESCRIPTION:  
;*      for the given time period return a list of available 
;*      Goes satellite ID's 
;* 
;* INPUTS:       
;*      none
;* 
;* KEYWORDS:
;*      none
;*      
;* OUTPUT: 
;*      A string array of satellite id's eg GOES 07
;* 
;* CALLING SEQUENCE:
;*      result=goes_satlist
;*
;* MODIFICATION HISTORY:       
;*      october 1995, written by R. Friedel
;*      January 1997, to allow MJDT format time only
;***************************************************************************
FUNCTION goes_satlist

COMMON PLOT_COMPOSER, widgetData

   xut1=widgetData.startTime
   xut2=widgetData.endTime

;get the number of GOES satellite present in the database
path = getenv('GOES_DATA')

; check for env. variable pointing to data directory
   if strlen(path) eq 0 then begin
      dummy=messagebox(['Environmental variable GOES_DATA not set'],$
                           ['O.K,'], $
                           title='no data found')
      get_err_msg='Environmental variable GOES_DATA not set'
      print,get_err_msg
      files = 'no sat. found'
      return,files
   endif
   
; check for existence of data directory
   res=findfile(path,count=cc)
   if cc le 0 then begin
      dummy=messagebox(['Data directory '+path+' not found'],$
                           ['O.K,'], $
                           title='no data found')
      get_err_msg='Data directory '+path+' not found'
      print,get_err_msg
      files = 'no sat. found'
      return,files
   endif
   




result=findfile(path,count=tot)
index=where(strmid(result,0,5) eq 'GOES_')
goes_name = result(index)
index=where(strpos(goes_name,'KP') eq -1)
goes_name = goes_name(index)
;print,goes_name
id_sat = intarr(n_elements(goes_name))
id_sat(*) = -1

   for i=0,n_elements(goes_name)-1 do begin
      count=0
      sat_ID = strmid(goes_name(i),5,2)
      xut1=widgetData.startTime
      while xut1.mjd le widgetData.endTime.mjd do begin
         convert_t90_to_Date, xut1, year,doy,hr,min,sec,mon,cmon,doym, /mjdt

         fln = path+goes_name(i)+'/EPS_MAG/'+string(year,format="(i4.4)")+'/data/z' $
           +sat_ID+'5'+string(year-1900,mon,format="(i2.2,i2.2)")+'*'
;         print,fln
         found=findfile(fln,count=nfs)
         if nfs ne 0 then count=count+1
         if nfs eq 0 then begin
            mon = mon+1
            day_om=1
            xut1=convert_date_to_t90(year=year, mon=mon, day=day_om ,/MJDT)
         endif else goto,endloop1
      endwhile
   endloop1:   if count ge 1 then id_sat(i) = i
   endfor

index = where(id_sat ne -1,count)
if count ne 0 then begin
   files = goes_name(index)
endif else begin
   files = 'no sat. found'
endelse


return,files

end
