PRO goes_eph_commons

COMMON goes_eph, sat_names, eph_names,  yunits, goes_eph_control

sat_names = ['GOES_06', 'GOES_07','GOES_08','GOES_09','GOES_10','GOES_12']

eph_names = ['Lat', 'Long', 'Rad', 'GEO x', 'GEO y', 'GEO z', $
             'GSE x', 'GSE y', 'GSE z', 'GSM x', 'GSM y', 'GSM z']

yunits    = ['deg.',  'deg.',   'R!DE!N', $
             'km',    'km',     'km', $
             'km',    'km',     'km', $
             'km',    'km',     'km' ]

;finally, set up a structure for all the variables needed by the
;lanl geo eph  module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains mre
;descriptive and verbose tags for easier use.

goes_eph_control = { $
  sc_id:0,      sc_id_info:'Index into sat_names, GOES Satellite ID', $
  product:0,    product_info:'Index into eph_names, choice of original '+$
                             'ephemeris coord', $
  ticks:0,      ticks_info:'Plot Style; 0: line, 1: x-axis ticks', $
  orig:0,       orig_info:'Coord source; 0: original, 1: model'}

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to goes_eph_control
goes_eph_control = CREATE_STRUCT(goes_eph_control, $
                           papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))

;finally name the control structure. This is required for load/save operations!
goes_eph_control = CREATE_STRUCT(name = 'goes_eph_control_a', $
                           goes_eph_control)

END
