;******************************************************************************
;* PROCEDURE:     
;*      PRO gps_eph_commons
;* 
;* DESCRIPTION:  
;*      simply sets up a couple of often used arrays in common blocks.
;*
;* INPUTS:       
;*      none
;*                  
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      gps_eph_commons
;******************************************************************************
PRO gps_eph_commons
  
COMMON gps_eph, sat_id, eph_names, select_names, gps_eph_control
  
sat_id = ['ns08', 'ns10', 'ns18', 'ns24', 'ns28', 'ns33', 'ns39', $
          'ns41', 'ns54']

eph_names = ['LAT' ,'LONG','RAD' ,'RHO' ,'Z',   'MLONG',$
             'LT89','BBO' ,'LOCT','BSAT','BEQU', 'MLAT']  

;enter variables for filtering the data
select_names = ['L', 'L_STAR', 'MLT', 'MLAT']
select_frmts = ['(f4.1)', '(f4.1)', '(f4.1)', '(f5.1)']

;finally, set up a structure for all the variables needed by the
;lanl geo eph  module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains mre
;descriptive and verbose tags for easier use.

gps_eph_control = { $
  sc_id:0,      sc_id_info:'Index into sat_names, GPS Satellite ID', $
  product:0,    product_info:'Index into eph_names, choice of original '+$
                             'ephemeris coord', $
  orig:0,       orig_info:'original (0) or model (1) coords', $
  seg_av:0,     seg_av_info:'0: plot filtered segments, 1: average',  $
  reload:0,     reload_info:'0: reload data, 1: adopt from memory',  $
  filter:0,     filter_info:'Index into select_names filter varibale to use'}

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to lanl_geo_eph_control
gps_eph_control = CREATE_STRUCT(gps_eph_control, $
                       papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))
  
;now get the papco panel tags for the various select variables.
FOR i = 0, n_elements(select_names)-1 DO $
  gps_eph_control = CREATE_STRUCT(gps_eph_control, $
        papco_panel_AddVar_Sel_Widgets(aBase, select_names(i), $
                                       select, st, en, v1, v2, vr, $
                                       select_frmts(i), /STRUCT_ONLY))

;finally name the control structure. This is required for load/save operations!
gps_eph_control = CREATE_STRUCT(name = 'gps_eph_control4', gps_eph_control)

END 
