;******************************************************************************
;* PROCEDURE:     
;*      PRO heo_eph_commons
;* 
;* DESCRIPTION:  
;*      simply sets up a couple of often used arrays in common blocks.
;*
;* INPUTS:       
;*      none
;*                  
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      heo_eph_commons
;******************************************************************************
PRO heo_eph_commons
  
COMMON heo_eph, heo_eph_sats, heo_eph_products, heo_eph_units, $
                heo_eph_select_names, heo_eph_select_frmts, heo_eph_control

heo_eph_sats = ['HEO_1', 'HEO_3']

heo_eph_products = ['LSHELL', 'INVLAT', 'MLT', 'MLAT', 'RDIPOLE', 'BTOT', 'BEQU', 'BMIRR', 'BNORTH', 'BSOUTH', 'BECI_X', 'BECI_Y', 'BECI_Z', 'LOSSCONE', 'TILTANGLE', 'GEO_LONG', 'GEO_LAT', 'RADDIST']

heo_eph_units = heo_eph_products

;enter varibales for filtering the data
heo_eph_select_names = ['L_VAL', 'MLT', 'MLAT']
heo_eph_select_frmts = ['(f4.1)', '(f4.1)', '(f5.1)']

;finally, set up a structure for all the variables needed by the
;lanl geo eph  module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains mre
;descriptive and verbose tags for easier use.

heo_eph_control = { $
  sat_id:0,   sat_id_info: 'Satellite choice, index into heo_eph_sats', $
  product:0, product_info:'Product to plot, index into heo_eph_products',  $
  orig:0,       orig_info:'original (0) or model (1) coords', $
  filter:0,   filter_info:'Index into select_names filter varibale to use'}

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to lanl_geo_eph_control
heo_eph_control = CREATE_STRUCT(heo_eph_control, $
                       papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))
  
;now get the papco panel tags for the various select variables.
FOR i = 0, n_elements(heo_eph_select_names)-1 DO $
  heo_eph_control = CREATE_STRUCT(heo_eph_control, $
        papco_panel_AddVar_Sel_Widgets(aBase, heo_eph_select_names(i), $
                                       select, st, en, v1, v2, vr, $
                                       heo_eph_select_frmts(i), /STRUCT_ONLY))

;finally name the control structure. This is required for load/save operations!
heo_eph_control = CREATE_STRUCT(name = 'heo_eph_control3', heo_eph_control)

END
