FUNCTION day_of_year, year, month, day, date=date, verbose=verbose, stop=stop
;
;
;  Calculate the day of the year given the date
;
;
n = n_params()

IF (n EQ 0) THEN BEGIN
   IF keyword_set(date) THEN BEGIN 
      year = fix(strmid(date,6,2))
      month = fix(strmid(date,0,2))
      day = fix(strmid(date,3,2))
   ENDIF ELSE BEGIN
      print, 'ERROR in day_of_year: No date specified'
      stop
   ENDELSE
ENDIF ELSE BEGIN
   IF (n NE 3) THEN BEGIN 
      print, 'ERROR in day_of_year: Need 3 arguments.'
      stop
   ENDIF
ENDELSE
IF (year LT 90) THEN BEGIN
   year = year+2000
ENDIF ELSE BEGIN
   IF (year LT 100) THEN BEGIN
      year = year + 1900
   ENDIF
ENDELSE

month_length = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]

dday = day
IF (month GT 2) THEN BEGIN
   IF (year MOD 4 EQ 0) THEN BEGIN
      IF (year MOD 100 EQ 0) THEN BEGIN
         IF (year MOD 400 EQ 0) THEN BEGIN
            dday = dday + 1
         ENDIF
      ENDIF ELSE BEGIN
         dday = dday + 1
      ENDELSE
   ENDIF
ENDIF


FOR i=1,month-1 DO BEGIN
   dday = dday + month_length(i-1)
   IF keyword_set(verbose) THEN print, i, year, month, day, dday
ENDFOR

IF keyword_set(stop) THEN stop

return, dday
END
