pro draw_hydra_bfield, panelVector, currPlotInfo, orbitNo, $
                       get_data_call, slice_type, IsRead, $
                       OUTPUT=OUTPUT

   common extra, extra_PlotInfo
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg
   common hydra_bfield_data, $
    bfield_type, $
    bfield_header, $
    bfield_lr_data, $
    bfield_mr_data, $
    bfield_hr_data, $
    bfield_ppar_data
   
   COMMON bfield_loaded, lrloaded, mrloaded, hrloaded, pparloaded
   
   bfield_type = currPlotInfo.typeVector(0)-1
   options= currPlotInfo.typeVector(2) and long(31)
   
   if bfield_type eq -1 then bfield_type= hyd_bfield_res() ; AutoSelect
   
   get_data_call="r_hydra_bfield"
   
   if hydra_new_papco() then begin
      n=(papco_slice_value('USER Hydra fV Slice')>0)
      slice_type= 1+16
   endif else begin
      slice_type= 1
   endelse
   
   IF n_elements( bfield_header ) EQ 0 THEN YesLoad=1 ELSE BEGIN        
      YesLoad= $
       (NOT keyword_set(lrloaded) AND bfield_type EQ 0)    OR  $
       (NOT keyword_set(mrloaded) AND bfield_type EQ 1)    OR  $
       (NOT keyword_set(hrloaded) AND bfield_type EQ 2)    OR  $
       (NOT keyword_set(pparloaded) AND bfield_type EQ 3)  OR  $
       (bfield_header(bfield_type).start_time gt xut1)     OR  $
       (bfield_header(bfield_type).end_time lt xut2 )      OR  $
       (bfield_header(bfield_type).options ne options) OR  $
       (bfield_header(bfield_type).reload_flag) ; set with panel
   ENDELSE 
   
   IF YesLoad THEN BEGIN
       r_hydra_bfield, options= options
       IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                 panelVector, orbitNr, $
                                 currPlotInfo.typeVector, $
                                 currPlotInfo.channel) $
         THEN BEGIN
           bfield_header(bfield_type).reload_flag=0
           IsRead=1
           p_hydra_bfield, panelVector, currPlotInfo.typeVector, $
             _EXTRA=extra_PlotInfo
           
; Who have we loaded so far?
         IF bfield_type EQ 0 THEN lrloaded =  1
         IF bfield_type EQ 1 THEN mrloaded =  1
         IF bfield_type EQ 2 THEN hrloaded =  1
         IF bfield_type EQ 3 THEN pparloaded = 1
      ENDIF
   ENDIF ELSE BEGIN
      p_hydra_bfield, panelVector, currPlotInfo.typeVector, $
       OUTPUT=OUTPUT, _EXTRA=extra_PlotInfo
   ENDELSE
   
END

