pro draw_hydra_current, panelVector, currPlotInfo, orbitNo, $
                     get_data_call, slice_type, IsRead

   common extra, extra_PlotInfo
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg
   common hydra_current_data, $
    current_header, $
    current_data
   
   get_data_call="r_hydra_current"
   
   if hydra_new_papco() then begin
      n=(papco_slice_value('USER Hydra fV Slice')>0)
      slice_type= 1+16
   endif else begin
      slice_type= 1
   endelse
   
   IF n_elements(current_header) EQ 0 THEN YesLoad = 1 ELSE BEGIN 
      YesLoad= $
       (current_header.start_time gt xut1)     OR  $
       (current_header.end_time lt xut2 )      OR  $
       (current_header.reload_flag ) ; set with panel
   ENDELSE 
   
   IF YesLoad THEN BEGIN
      r_hydra_current
      IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                panelVector, orbitNr, $
                                currPlotInfo.typeVector, $
                                currPlotInfo.channel) $
       THEN BEGIN
         current_header.reload_flag=0
         IsRead=1
         p_hydra_current, panelVector, currPlotInfo.typeVector, $
          _EXTRA=extra_PlotInfo
         pdcr = PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                       panelVector, orbitNr, $
                                       currPlotInfo.typeVector, $
                                       currPlotInfo.channel)
      ENDIF
   ENDIF ELSE BEGIN
      p_hydra_current, panelVector, currPlotInfo.typeVector, $
       _EXTRA=extra_PlotInfo
      pdcr = PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                    panelVector, orbitNr, $
                                    currPlotInfo.typeVector, $
                                    currPlotInfo.channel)
   ENDELSE
   
END

