pro draw_hydra_fv, panelVector, currPlotInfo, orbitNo, $
                   get_data_call, slice_type, IsRead

   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg

   common rp_hydra_fv_common, fv_out_header, fv_ele, fv_ion

   if n_elements( fv_out_header ) eq 0 then begin
       fv_out_header= { $
                        start_time:[0L,0L], $
                        end_time:[0L,0L], $
                        reload:[0,0] $
                      }
   endif
       
   get_data_call=""

   species= currPlotInfo.typevector(0)
   hydra_fv_rw_list, /read, species, fv_header, fv_data

;  logic to load series or no
   if n_elements( fv_data ) eq 1 and $
     currPlotInfo.filename ne '' then begin
       hydra_fv_load, currPlotInfo.filename
       common hydra_fv_common, $
         fve_header, fve_data, fve_input_global, $
         fvi_header, fvi_data, fvi_input_global
       fv_out_header.reload(*)=1
       hydra_fv_rw_list, /read, species, fv_header, fv_data
   endif       
   
   if hydra_new_papco() then begin
       n=(papco_slice_value('USER Hydra fV Slice')>0)
       slice_type= 1+16+n
   endif else begin
       slice_type= 1+8
   endelse
   
   YesLoad= $
     fv_out_header.start_time(species) gt xut1    or  $
     fv_out_header.end_time(species) lt xut2      or  $
     fv_out_header.reload(species) 

   IF YesLoad THEN BEGIN
       fv_out_header.reload(species)=1
       r_hydra_fv, species
       IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                 panelVector, orbitNr, $
                                 currPlotInfo.typeVector, $
                                 currPlotInfo.channel) $
         THEN BEGIN
           fv_out_header.reload(species)=0
           fv_out_header.start_time(species)=xut1
           fv_out_header.end_time(species)=xut2
           IsRead=1
           p_hydra_fv, panelVector, currPlotInfo.typeVector, $
             _EXTRA=extra_PlotInfo
       ENDIF
   ENDIF ELSE BEGIN
       p_hydra_fv, panelVector, currPlotInfo.typeVector, $
         _EXTRA=extra_PlotInfo
   ENDELSE
END

