pro draw_hydra_kptest, panelVector, currPlotInfo, orbitNo, $
                     get_data_call, slice_type, IsRead

   common extra, extra_PlotInfo
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg
   common hydra_kptest_data, $
    kptest_species, $
    kptest_header, $
    kptest_lr_ele_data, $
    kptest_lr_ele_attr, $
    kptest_lr_ion_data, $
    kptest_lr_ion_attr, $
    kptest_hr_ele_data, $
    kptest_hr_ele_attr

COMMON kptest_loaded, lreleloaded, lrionloaded, hreleloaded

   kptest_species = currPlotInfo.typeVector(0)

   if n_elements( kptest_header ) eq 0 then begin
      mh1={ hydra_kptest_dum_header, $
           start_time:long(0), $
           end_time:long(0), $
           data_version:float(0), $
           reload_flag:fix(0) $
         }
      kptest_header = replicate(mh1,3)
   endif

   get_data_call="r_hydra_kptest"

   if hydra_new_papco() then begin
       n=(papco_slice_value('USER Hydra fV Slice')>0)
       slice_type= 1+16
   endif else begin
       slice_type= 1
   endelse

   YesLoad= $
    (NOT keyword_set(lreleloaded) AND kptest_species EQ 0)  OR  $
    (NOT keyword_set(lrionloaded) AND kptest_species EQ 1)  OR  $
    (NOT keyword_set(hreleloaded) AND kptest_species EQ 2)  OR  $
     kptest_header(kptest_species).start_time gt xut1    or  $
     kptest_header(kptest_species).end_time lt xut2      or  $
     kptest_header(kptest_species).reload_flag      ; set with panel


   IF YesLoad THEN BEGIN
       kptest_header(kptest_species).start_time=xut1
       kptest_header(kptest_species).end_time=xut2
       kptest_header(kptest_species).reload_flag=1
       r_hydra_kptest
       IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                 panelVector, orbitNr, $
                                 currPlotInfo.typeVector, $
                                 currPlotInfo.channel) $
         THEN BEGIN
           kptest_header(kptest_species).reload_flag=0
           IsRead=1
           p_hydra_kptest, panelVector, currPlotInfo.typeVector, $
             _EXTRA=extra_PlotInfo

; Who have we loaded so far?
           IF kptest_species EQ 0 THEN lreleloaded =  1
           IF kptest_species EQ 1 THEN lrionloaded =  1
           IF kptest_species EQ 2 THEN hreleloaded =  1

       ENDIF
   ENDIF ELSE BEGIN
       p_hydra_kptest, panelVector, currPlotInfo.typeVector, $
         _EXTRA=extra_PlotInfo
   ENDELSE

END


