pro draw_hydra_other, panelVector, currPlotInfo, orbitNo, $
                     get_data_call, slice_type, IsRead

common extra, extra_PlotInfo
common time, xut1, xut2
common get_error, get_err_no, get_err_msg
common hydra_other_data, other_header, other_data, hydra_values

   if n_elements( other_header ) eq 0 then begin
       other_header={ $
                   start_time:long(0), $
                   end_time:long(0), $
                   data_version:float(0), $
                   reload_flag:fix(0) $
                 }
   endif

   get_data_call="r_hydra_other"

   if hydra_new_papco() then begin
       n=(papco_slice_value('USER Hydra fV Slice')>0)
       slice_type= 1+16
   endif else begin
       slice_type= 1
   endelse

   YesLoad= $
     other_header.start_time gt xut1    or  $
     other_header.end_time lt xut2      or  $
     other_header.reload_flag      ; set with panel


   IF YesLoad THEN BEGIN
       other_header.start_time=xut1
       other_header.end_time=xut2
       other_header.reload_flag=1
       r_hydra_other
       IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                 panelVector, orbitNr, $
                                 currPlotInfo.typeVector, $
                                 currPlotInfo.channel) $
         THEN BEGIN
           other_header.reload_flag=0
           IsRead=1
           p_hydra_other, panelVector, currPlotInfo.typeVector, $
             _EXTRA=extra_PlotInfo
       ENDIF
   ENDIF ELSE BEGIN
       p_hydra_other, panelVector, currPlotInfo.typeVector, $
         _EXTRA=extra_PlotInfo
   ENDELSE

END

